/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AdvancedPanel;
import oracle.dbtools.raptor.connections.BasicPanel;
import oracle.dbtools.raptor.connections.BequeathConnectionPanel;
import oracle.dbtools.raptor.connections.LDAPConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.connections.TNSPanel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public final class OracleConnectionType {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-connections";
    private static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-connections", "sqldev-connections-hook");
    private static final String TYPE_ELEMENT = "oracleConnectionType";
    private static final String NAME_ATTRIBUTE = "type";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String PANEL_ATTRIBUTE = "panelClass";
    private static final String PROCESSOR_ATTRIBUTE = "processorClass";
    private static Map<String, OracleConnectionType> sTypes = new LinkedHashMap<String, OracleConnectionType>();
    private static Listener listener;
    public static final OracleConnectionType BASIC;
    public static final OracleConnectionType TNS;
    public static final OracleConnectionType LDAP;
    public static final OracleConnectionType ADVANCED;
    public static final OracleConnectionType BEQUEATH;
    private final String mName;
    private final String mLabel;
    private final MetaClass<? extends OracleConnectionTypePanel> clsPanel;
    private final MetaClass<? extends OracleConnectionProcessor> clsProcessor;

    public static Builder builder(String string) {
        return new Builder(string);
    }

    private static void attachListener() {
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        if (hashStructureHook != null) {
            listener = new Listener();
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)listener);
        }
    }

    public static synchronized OracleConnectionType findType(String string) {
        OracleConnectionType oracleConnectionType = sTypes.get(string);
        if (oracleConnectionType == null) {
            throw new IllegalArgumentException("Unknown type: " + string);
        }
        return oracleConnectionType;
    }

    public static Collection<OracleConnectionTypePanel> getConnectionPanels() {
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        ArrayList<OracleConnectionTypePanel> arrayList = new ArrayList<OracleConnectionTypePanel>();
        for (OracleConnectionType oracleConnectionType : sTypes.values()) {
            OracleConnectionTypePanel oracleConnectionTypePanel = oracleConnectionType.getPanel();
            if (oracleConnectionTypePanel == null) continue;
            arrayList.add(oracleConnectionTypePanel);
        }
        return arrayList;
    }

    public static OracleConnectionProcessor getConnectionProcessor(String string) {
        OracleConnectionProcessor oracleConnectionProcessor;
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        OracleConnectionProcessor oracleConnectionProcessor2 = OracleConnectionProcessor.NULL_PROCESSOR;
        OracleConnectionType oracleConnectionType = sTypes.get(string);
        if (oracleConnectionType != null && (oracleConnectionProcessor = oracleConnectionType.getProcessor()) != null) {
            oracleConnectionProcessor2 = oracleConnectionProcessor;
        }
        return oracleConnectionProcessor2;
    }

    public static Collection<OracleConnectionProcessor> getConnectionProcessors() {
        if (listener == null) {
            OracleConnectionType.attachListener();
        }
        ArrayList<OracleConnectionProcessor> arrayList = new ArrayList<OracleConnectionProcessor>();
        for (OracleConnectionType oracleConnectionType : sTypes.values()) {
            OracleConnectionProcessor oracleConnectionProcessor = oracleConnectionType.getProcessor();
            if (oracleConnectionProcessor == null) continue;
            arrayList.add(oracleConnectionProcessor);
        }
        return arrayList;
    }

    private OracleConnectionType(String string, String string2, MetaClass<? extends OracleConnectionTypePanel> metaClass, MetaClass<? extends OracleConnectionProcessor> metaClass2) {
        this.mName = string;
        this.mLabel = string2 != null ? string2 : string;
        this.clsPanel = metaClass;
        this.clsProcessor = metaClass2;
    }

    public String name() {
        return this.mName;
    }

    public String toString() {
        return this.mLabel;
    }

    public OracleConnectionTypePanel getPanel() {
        OracleConnectionTypePanel oracleConnectionTypePanel = null;
        if (this.clsPanel != null) {
            try {
                oracleConnectionTypePanel = (OracleConnectionTypePanel)this.clsPanel.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return oracleConnectionTypePanel;
    }

    public OracleConnectionProcessor getProcessor() {
        OracleConnectionProcessor oracleConnectionProcessor = null;
        if (this.clsProcessor != null) {
            try {
                oracleConnectionProcessor = (OracleConnectionProcessor)this.clsProcessor.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return oracleConnectionProcessor;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mName == null ? 0 : this.mName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OracleConnectionType oracleConnectionType = (OracleConnectionType)object;
        return !(this.mName == null ? oracleConnectionType.mName != null : !this.mName.equals(oracleConnectionType.mName));
    }

    static {
        BASIC = OracleConnectionType.builder("BASIC").label(Messages.getString("OracleConnectionType.0")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(BasicPanel.class)).build();
        TNS = OracleConnectionType.builder("TNS").label("TNS").panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(TNSPanel.class)).build();
        LDAP = OracleConnectionType.builder("LDAP").label("LDAP").panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(LDAPConnectionPanel.class)).build();
        ADVANCED = OracleConnectionType.builder("ADVANCED").label(Messages.getString("OracleConnectionType.3")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(AdvancedPanel.class)).build();
        BEQUEATH = OracleConnectionType.builder("BEQUEATH").label(Messages.getString("OracleConnectionType.4")).panelClass((MetaClass<? extends OracleConnectionTypePanel>)MetaClass.newMetaClass(BequeathConnectionPanel.class)).build();
    }

    public static final class Builder {
        private String name;
        private String label;
        private MetaClass<? extends OracleConnectionTypePanel> clsPanel;
        private MetaClass<? extends OracleConnectionProcessor> clsProcessor;

        private Builder(String string) {
            this.name = string;
        }

        public Builder label(String string) {
            this.label = string;
            return this;
        }

        public Builder panelClass(MetaClass<? extends OracleConnectionTypePanel> metaClass) {
            this.clsPanel = metaClass;
            return this;
        }

        public Builder processorClass(MetaClass<? extends OracleConnectionProcessor> metaClass) {
            this.clsProcessor = metaClass;
            return this;
        }

        public OracleConnectionType build() {
            if (sTypes.containsKey(this.name)) {
                throw new IllegalStateException("OracleConnectionType already exists: " + this.name);
            }
            OracleConnectionType oracleConnectionType = new OracleConnectionType(this.name, this.label, this.clsPanel, this.clsProcessor);
            sTypes.put(this.name, oracleConnectionType);
            return oracleConnectionType;
        }
    }

    private static final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(OracleConnectionType.TYPE_ELEMENT);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    MetaClass metaClass;
                    LazyClassAdapter lazyClassAdapter;
                    MetaClass metaClass2;
                    String string = hashStructure2.getString(OracleConnectionType.NAME_ATTRIBUTE);
                    if (string == null) continue;
                    Builder builder = OracleConnectionType.builder(string);
                    String string2 = hashStructure2.getString(OracleConnectionType.LABEL_ATTRIBUTE);
                    if (string2 != null) {
                        builder.label(string2);
                    }
                    if ((metaClass2 = (lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2)).getMetaClass(OracleConnectionType.PANEL_ATTRIBUTE)) != null) {
                        builder.panelClass((MetaClass<? extends OracleConnectionTypePanel>)metaClass2);
                    }
                    if ((metaClass = lazyClassAdapter.getMetaClass(OracleConnectionType.PROCESSOR_ATTRIBUTE)) != null) {
                        builder.processorClass((MetaClass<? extends OracleConnectionProcessor>)metaClass);
                    }
                    builder.build();
                }
            }
        }
    }
}

