/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AdvancedOracleConnectionProperties;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public final class OracleConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 530419491097270959L;
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    public static final String OS_AUTHENTICATION = "OS_AUTHENTICATION";
    public static final String KERBEROS_AUTHENTICATION = "KERBEROS_AUTHENTICATION";
    private JPanel mTypePanel;
    private JLabel lblRole = new JLabel();
    private String[] roles = new String[]{Messages.getString("OracleConnectionPanel.2"), "SYSDBA", "SYSOPER", "SYSBACKUP", "SYSDG", "SYSKM", "SYSASM"};
    private JComboBox<String> cbxRole = new JComboBox<String>(this.roles);
    private CardLayout layType;
    private JButton mAdvButton = new JButton();
    public static final String ORACLE_CONNECTION_PANEL_TYPE = "OracleConnectionType";
    public static final String THIN_URL = "jdbc:oracle:thin:@";
    private JComboBox<OracleConnectionType> cbxAuthType = new JComboBox();
    private JLabel lblAuthType = new JLabel();
    private JCheckBox chkOSAuth = new JCheckBox();
    private JCheckBox chkKerbAuth = new JCheckBox();
    private AdvancedOracleConnectionProperties mDetails;
    private Map<OracleConnectionType, OracleConnectionTypePanel> mPanels = new HashMap<OracleConnectionType, OracleConnectionTypePanel>();

    public Component getComponent() {
        this.initUI();
        return this;
    }

    @Override
    public void initUI() {
        if (this.layType == null) {
            this.setLayout(new GridBagLayout());
            this.mDetails = new AdvancedOracleConnectionProperties();
            this.layType = new CardLayout(0, 0);
            this.mTypePanel = new JPanel(this.layType);
            JPanel jPanel = new JPanel(new GridBagLayout());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.lblAuthType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add(this.cbxAuthType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)this.lblRole, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add(this.cbxRole, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            ResourceUtils.resLabel((JLabel)this.lblRole, this.cbxRole, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_ROLE"));
            ResourceUtils.resLabel((JLabel)this.lblAuthType, this.cbxAuthType, (String)ConnectionDialogArb.getString("CONNECTION_TYPE"));
            ResourceUtils.resButton((AbstractButton)this.chkKerbAuth, (String)ConnectionDialogArb.getString(KERBEROS_AUTHENTICATION));
            ResourceUtils.resButton((AbstractButton)this.mAdvButton, (String)ConnectionDialogArb.get("ADVANCED_BUTTON"));
            ResourceUtils.resButton((AbstractButton)this.chkOSAuth, (String)ConnectionDialogArb.getString(OS_AUTHENTICATION));
            this.add(jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            for (OracleConnectionTypePanel oracleConnectionTypePanel : OracleConnectionType.getConnectionPanels()) {
                oracleConnectionTypePanel.setOwner(this);
                oracleConnectionTypePanel.setDefaultPrompts();
                OracleConnectionType oracleConnectionType = oracleConnectionTypePanel.getConnectionType();
                this.mPanels.put(oracleConnectionType, oracleConnectionTypePanel);
                this.mTypePanel.add(oracleConnectionTypePanel.getPanel(), oracleConnectionType.name());
                this.cbxAuthType.addItem(oracleConnectionType);
            }
            this.add(this.mTypePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 15), 0, 0));
            jPanel2.add((Component)this.chkOSAuth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
            jPanel2.add((Component)this.chkKerbAuth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
            jPanel2.add((Component)this.mAdvButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.add(jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.cbxAuthType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        OracleConnectionPanel.this.togglePanels();
                    }
                }
            });
            this.chkKerbAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    if (actionEvent.getSource() instanceof JCheckBox && (bl = ((JCheckBox)actionEvent.getSource()).isSelected())) {
                        OracleConnectionPanel.this.chkOSAuth.setSelected(false);
                        OracleConnectionPanel.this.getDialog().useUserName(true);
                        OracleConnectionPanel.this.getDialog().usePassword(true);
                    }
                }
            });
            this.chkOSAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JCheckBox) {
                        boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                        if (bl) {
                            OracleConnectionPanel.this.chkKerbAuth.setSelected(false);
                        }
                        OracleConnectionPanel.this.getDialog().useUserName(!bl);
                        OracleConnectionPanel.this.getDialog().usePassword(!bl);
                    }
                }
            });
            this.mAdvButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OracleConnectionPanel.this.mDetails.showDialog((JComponent)((Object)OracleConnectionPanel.this));
                }
            });
        }
    }

    private void togglePanels() {
        OracleConnectionType oracleConnectionType = (OracleConnectionType)this.cbxAuthType.getSelectedItem();
        if (oracleConnectionType != null) {
            this.layType.show(this.mTypePanel, oracleConnectionType.name());
        }
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", DRIVER_CLASS_NAME);
        properties.setProperty("oraDriverType", "thin");
        properties.setProperty("RaptorConnectionType", "Oracle");
        String string = (String)this.cbxRole.getSelectedItem();
        properties.setProperty("role", string.equals(this.roles[0]) ? "" : string);
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.generateProperties(properties);
        properties.setProperty(OS_AUTHENTICATION, Boolean.toString(this.chkOSAuth.isSelected()));
        if (this.chkOSAuth.isSelected() || this.chkKerbAuth.isSelected()) {
            properties.setProperty("NoPasswordConnection", "FALSE");
        } else {
            properties.setProperty("NoPasswordConnection", "TRUE");
        }
        properties.setProperty(KERBEROS_AUTHENTICATION, Boolean.toString(this.chkKerbAuth.isSelected()));
        properties.putAll((Map<?, ?>)this.mDetails.getAdvancedProperties());
        return properties;
    }

    private CDComponentView getPanel() {
        Object object = this.cbxAuthType.getSelectedItem();
        return this.mPanels.get(object);
    }

    @Override
    protected void testConnection(Properties properties) throws ConnectionException {
        String string = properties.getProperty("customUrl");
        super.testConnection(properties);
        SwingUtilities.invokeLater(() -> this.getDialog().setPassword(properties.getProperty("password")));
    }

    @Override
    public void clear() {
        for (OracleConnectionTypePanel oracleConnectionTypePanel : this.mPanels.values()) {
            oracleConnectionTypePanel.clear();
        }
    }

    public static OracleConnectionType getOracleType(Properties properties) {
        String string = properties.getProperty(ORACLE_CONNECTION_PANEL_TYPE);
        if (string != null) {
            try {
                return OracleConnectionType.findType(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String string2 = properties.getProperty("hostname");
        String string3 = properties.getProperty("sid");
        String string4 = properties.getProperty("serviceName");
        if (ModelUtil.hasLength((String)string2) && (ModelUtil.hasLength((String)string3) || ModelUtil.hasLength((String)string4))) {
            return OracleConnectionType.BASIC;
        }
        String string5 = properties.getProperty("customUrl");
        if (string5 != null && !string5.startsWith("jdbc:")) {
            return OracleConnectionType.TNS;
        }
        return OracleConnectionType.ADVANCED;
    }

    @Override
    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        String string2 = properties.getProperty("role");
        OracleConnectionType oracleConnectionType = OracleConnectionPanel.getOracleType(properties);
        if (oracleConnectionType == null) {
            oracleConnectionType = OracleConnectionType.ADVANCED;
        }
        if (!ModelUtil.hasLength((String)string2)) {
            this.cbxRole.setSelectedIndex(0);
        } else {
            this.cbxRole.setSelectedItem(string2);
        }
        this.cbxAuthType.setSelectedItem(oracleConnectionType);
        this.mPanels.get(oracleConnectionType).updatePrompts(properties);
        properties.put("ConnName", this.getConnectionName());
        this.mDetails.setAdvancedProperties(properties);
        boolean bl = Boolean.parseBoolean(properties.getProperty(OS_AUTHENTICATION));
        this.chkOSAuth.setSelected(bl);
        this.getDialog().useUserName(!bl);
        this.getDialog().usePassword(!bl);
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(KERBEROS_AUTHENTICATION));
        this.chkKerbAuth.setSelected(bl2);
    }

    @Override
    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    @Override
    public String getDriver() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public void setDialog(ConnectionDialog connectionDialog) {
        super.setDialog(connectionDialog);
        for (OracleConnectionTypePanel oracleConnectionTypePanel : this.mPanels.values()) {
            this.getDialog().attachEnterKey(oracleConnectionTypePanel.getPanel());
        }
    }

    @Override
    public void setDefaultPrompts() {
        for (OracleConnectionTypePanel oracleConnectionTypePanel : this.mPanels.values()) {
            oracleConnectionTypePanel.setDefaultPrompts();
        }
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    @Override
    public String getConnectionType() {
        return "Oracle";
    }
}

