/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.javatools.util.Log;
import oracle.javatools.util.PlatformUtils;

public class ConnectionTypeRegistry {
    private static List<T> _panels = new ArrayList<T>();
    private static boolean s_inited;
    private static final String access = "ACCESS";

    public static synchronized void registerConnectionType(String string, Class<? extends IConnectionPanel> clazz, ConnectionTypeDetails connectionTypeDetails) {
        _panels.add(new T(string, clazz, connectionTypeDetails));
    }

    public static synchronized IConnectionPanel getPanelFor(String string) throws InstantiationException, IllegalAccessException {
        ConnectionTypeRegistry.init();
        for (T t : _panels) {
            try {
                if (!t.getName().equals(string)) continue;
                return t.getPanel().newInstance();
            }
            catch (Exception exception) {
                Log.error((String)("Failed to initialize connection " + exception.getMessage()));
            }
        }
        return null;
    }

    public static ArrayList<String> getTabNames() {
        ConnectionTypeRegistry.init();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (T t : _panels) {
            arrayList.add(t.getName());
        }
        return arrayList;
    }

    private static void init() {
        boolean bl = true;
        if (!s_inited) {
            Iterator<ConnectionType> iterator = NavigatorHook.getHookInstance("sqldev.nav").getConnectionTypes();
            while (iterator.hasNext()) {
                ConnectionType connectionType = iterator.next();
                ConnectionTypeDetails connectionTypeDetails = connectionType.getImpl();
                String string = connectionTypeDetails.getConnectionPanelLabel();
                String string2 = connectionTypeDetails.getType();
                if (string == null) continue;
                String string3 = connectionTypeDetails.getConnectionPanel();
                boolean bl2 = bl = PlatformUtils.isWindows() || !string2.equals(access);
                if (string3 == null || !bl) continue;
                try {
                    Class<?> clazz = Class.forName(string3, true, connectionType.getClassLoader());
                    ConnectionTypeRegistry.registerConnectionType(string, clazz, connectionTypeDetails);
                }
                catch (Exception exception) {}
            }
            s_inited = true;
        }
        Collections.sort(_panels, new C());
    }

    private static class C
    implements Comparator<T> {
        private C() {
        }

        @Override
        public int compare(T t, T t2) {
            ConnectionTypeDetails connectionTypeDetails = t.getDetails();
            Float f = Float.valueOf(connectionTypeDetails.getWeight());
            ConnectionTypeDetails connectionTypeDetails2 = t2.getDetails();
            Float f2 = Float.valueOf(connectionTypeDetails2.getWeight());
            if (connectionTypeDetails.isOracle() && connectionTypeDetails2.isOracle()) {
                return f.compareTo(f2);
            }
            if (connectionTypeDetails.isOracle() && !connectionTypeDetails2.isOracle()) {
                return -1;
            }
            if (!connectionTypeDetails.isOracle() && connectionTypeDetails2.isOracle()) {
                return 1;
            }
            if (f.floatValue() == 100.0f && f2.floatValue() == 100.0f) {
                return Collator.getInstance().compare(t.getName(), t2.getName());
            }
            if (f.floatValue() == 100.0f && f2.floatValue() != 100.0f) {
                return -1;
            }
            return f.compareTo(f2);
        }
    }

    private static class T {
        private String _name;
        private Class<? extends IConnectionPanel> _panel;
        private ConnectionTypeDetails _details;

        public T(String string, Class<? extends IConnectionPanel> clazz, ConnectionTypeDetails connectionTypeDetails) {
            this._name = string;
            this._panel = clazz;
            this._details = connectionTypeDetails;
        }

        public String getName() {
            return this._name;
        }

        public Class<? extends IConnectionPanel> getPanel() {
            return this._panel;
        }

        public ConnectionTypeDetails getDetails() {
            return this._details;
        }
    }
}

