/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.ide.util.ResourceUtils;

class BasicPanel
extends JPanel
implements OracleConnectionTypePanel {
    private static final String JDBC_TYPE = "jdbc:oracle:thin:@";
    private JLabel hostLbl = new JLabel();
    protected JTextField tfdHost = new JTextField(15);
    private JLabel portLbl = new JLabel();
    protected JTextField tfdPort = new JTextField(15);
    protected JTextField tfdSid = new JTextField(15);
    protected JTextField tfdService = new JTextField(15);
    protected JRadioButton btnSid = new JRadioButton();
    protected JRadioButton btnService = new JRadioButton();
    protected ButtonGroup group = new ButtonGroup();

    public BasicPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void clear() {
        this.tfdHost.setText("");
        this.tfdPort.setText("");
        this.tfdSid.setText("");
        this.tfdService.setText("");
        this.btnSid.setSelected(true);
    }

    @Override
    public void generateProperties(Properties properties) {
        String string = this.tfdHost.getText().trim();
        String string2 = this.tfdPort.getText().trim();
        properties.setProperty("hostname", string);
        properties.setProperty("port", string2);
        StringBuilder stringBuilder = new StringBuilder(JDBC_TYPE);
        if (this.btnSid.isSelected()) {
            String string3 = this.tfdSid.getText().trim();
            properties.setProperty("sid", string3);
            stringBuilder.append(string).append(':').append(string2).append(':').append(string3);
        } else if (this.btnService.isSelected()) {
            String string4 = this.tfdService.getText().trim();
            properties.setProperty("serviceName", string4);
            stringBuilder.append("//").append(string).append(':').append(string2).append('/').append(string4);
        }
        properties.setProperty("customUrl", stringBuilder.toString());
        properties.setProperty("OracleConnectionType", OracleConnectionType.BASIC.name());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.hostLbl, (Component)this.tfdHost, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this.portLbl, (Component)this.tfdPort, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_PORT"));
        ResourceUtils.resButton((AbstractButton)this.btnSid, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_SID"));
        ResourceUtils.resButton((AbstractButton)this.btnService, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_SERVICE"));
        this.group.add(this.btnSid);
        this.btnSid.setSelected(true);
        this.group.add(this.btnService);
        Insets insets = new Insets(2, 2, 0, 0);
        this.add((Component)this.hostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.tfdHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this.portLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.tfdPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this.btnSid, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.tfdSid, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this.btnService, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this.tfdService, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicPanel.this.toggleTextInputs();
            }
        };
        this.btnSid.getModel().addChangeListener(changeListener);
        this.btnService.getModel().addChangeListener(changeListener);
        this.toggleTextInputs();
        this.setDefaultPrompts();
    }

    private void toggleTextInputs() {
        if (this.btnSid.isSelected()) {
            this.tfdService.setEditable(false);
            this.tfdService.setBackground(Color.LIGHT_GRAY);
            this.tfdSid.setEditable(true);
            this.tfdSid.setBackground(Color.WHITE);
        } else if (this.btnService.isSelected()) {
            this.tfdService.setEditable(true);
            this.tfdService.setBackground(Color.WHITE);
            this.tfdSid.setEditable(false);
            this.tfdSid.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setDefaultPrompts() {
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("1521");
        this.btnSid.setSelected(true);
        this.tfdSid.setText("xe");
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public OracleConnectionType getConnectionType() {
        return OracleConnectionType.BASIC;
    }

    @Override
    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
    }

    @Override
    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this.tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this.tfdPort.setText(string2 != null ? string2 : "1521");
        String string3 = properties.getProperty("sid");
        this.tfdSid.setText(string3);
        String string4 = properties.getProperty("serviceName");
        this.tfdService.setText(string4);
        if (ModelUtil.hasLength((String)string3)) {
            this.btnSid.setSelected(true);
            this.btnService.setSelected(false);
        } else {
            this.btnService.setSelected(true);
            this.btnSid.setSelected(false);
        }
    }
}

