/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.WeakCache;

public class CloudConnection
extends DefaultElement
implements ViewableElement,
Subject {
    private static WeakCache<String, CloudConnection> s_cache;
    private URL m_url;
    private IdeSubject m_subject = new IdeSubject();
    private Object __LOCK__ = new Object();
    private Session m_conn;

    protected static WeakCache<String, CloudConnection> getNodeCache() {
        if (s_cache == null) {
            s_cache = new WeakCache();
        }
        return s_cache;
    }

    protected static void cacheNode(String string, CloudConnection cloudConnection) {
        WeakCache<String, CloudConnection> weakCache = CloudConnection.getNodeCache();
        weakCache.put((Object)string, (Object)cloudConnection);
    }

    protected static void uncacheNode(String string) {
        WeakCache<String, CloudConnection> weakCache = CloudConnection.getNodeCache();
        weakCache.remove((Object)string);
    }

    public static CloudConnection findConnectionNode(URL uRL) {
        CloudConnection cloudConnection = null;
        String string = DBURLFormatHelper.getConnectionName(uRL);
        if (string != null) {
            cloudConnection = (CloudConnection)CloudConnection.getNodeCache().get((Object)string);
        }
        return cloudConnection;
    }

    public static CloudConnection findOrCreateConnectionNode(URL uRL) {
        WeakCache<String, CloudConnection> weakCache;
        CloudConnection cloudConnection = null;
        String string = DBURLFormatHelper.getConnectionName(uRL);
        if (string != null && (cloudConnection = (CloudConnection)(weakCache = CloudConnection.getNodeCache()).get((Object)string)) == null) {
            cloudConnection = new CloudConnection();
            cloudConnection.setURL(uRL);
        }
        return cloudConnection;
    }

    public String getConnectionName() {
        return DBURLFormatHelper.getConnectionName(this.getURL());
    }

    protected Object getLock() {
        return this.__LOCK__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getConnection() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn == null) {
                this.m_conn = this.openConnectionImpl();
            }
        }
        return this.m_conn;
    }

    protected final boolean openConnection() {
        boolean bl = this.isConnectionOpen();
        if (!bl) {
            try {
                this.getConnection();
                bl = true;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Throwable)iOException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeConnection(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                if (bl) {
                    this.closeConnectionImpl();
                }
                this.m_conn = null;
            }
        }
    }

    protected final void closeConnection() {
        this.closeConnection(true);
    }

    protected Session openConnectionImpl() throws IOException {
        Session session = null;
        try {
            session = CConnections.getInstance().getConnection(this.getConnectionName(), true);
            if (session == null) {
                throw new ExceptionWrapper((Throwable)new ConnectionCanceledException());
            }
        }
        catch (SessionException sessionException) {
            Throwable throwable = sessionException.getCause();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new ExceptionWrapper(throwable);
            }
            throw new ExceptionWrapper(sessionException);
        }
        return session;
    }

    protected boolean closeConnectionImpl() {
        return CConnections.getInstance().closeConnection(this.getConnectionName());
    }

    public final boolean isConnectionOpen() {
        return this.m_conn != null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        return super.getIcon();
    }

    public final URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        String string;
        boolean bl = false;
        URL uRL2 = this.m_url;
        if (uRL2 != null) {
            bl = uRL != null;
            string = DBURLFormatHelper.getConnectionName(uRL2);
            if (string != null) {
                CloudConnection.uncacheNode(string);
            }
        }
        this.m_url = uRL;
        if (uRL != null && (string = DBURLFormatHelper.getConnectionName(uRL)) != null) {
            CloudConnection.cacheNode(string, this);
        }
        if (bl) {
            UpdateMessage.fireObjectRenamed((Subject)this);
        }
    }

    public final void attach(Observer observer) {
        this.m_subject.attach(observer);
    }

    public final void detach(Observer observer) {
        this.m_subject.detach(observer);
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subject.notifyObservers(object, updateMessage);
    }

    public static class ExceptionWrapper
    extends IOException {
        public ExceptionWrapper(Throwable throwable) {
            this.initCause(throwable);
        }
    }
}

