/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

public class OSSPanel
extends DialogTraversable {
    public static final String[] SUPPORTED_KEYS = new String[]{"oss.enabled", "oss.identity_domain", "oss.service_name", "oss.username", "oss.password", "oss.service_url"};
    private JCheckBox mConfigEnabled = new JCheckBox();
    private JTextField mDomain = new JTextField();
    private JTextField mService = new JTextField();
    private JTextField mUser = new JTextField();
    private JPasswordField mPwd = new JPasswordField();
    private JTextField mUrl = new JTextField();
    private String labelOssIdentityDomain = CloudBrowserResources.getString("LABEL_OSS_IDENTITY_DOMAIN");
    private String labelOssServiceName = CloudBrowserResources.getString("LABEL_OSS_SERVICE_NAME");
    private DocumentListener serviceAndDomainListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            OSSPanel.this.updateServiceUrl();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            OSSPanel.this.updateServiceUrl();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    private String formatServiceUrl = "https://%s-%s.storage.oraclecloud.com";
    private boolean userModifiedServiceUrl;
    private DocumentListener urlListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            OSSPanel.this.userModifiedServiceUrl = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            OSSPanel.this.userModifiedServiceUrl = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };

    public static Namespace createNamespace(Properties properties) {
        Namespace namespace = new Namespace();
        for (String string : SUPPORTED_KEYS) {
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            namespace.put(string, (Object)string2);
        }
        return namespace;
    }

    public static Properties createProperties(Namespace namespace) {
        Properties properties = new Properties();
        for (String string : SUPPORTED_KEYS) {
            String string2 = (String)namespace.get(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public String getHelpID() {
        return null;
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        ResourceUtils.resButton((AbstractButton)this.mConfigEnabled, (String)CloudBrowserResources.getString("LABEL_OSS_INCLUDE"));
        this.mConfigEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OSSPanel.this.enableControls(itemEvent.getStateChange() == 1);
            }
        });
        this.enableControls(this.mConfigEnabled.isSelected());
        jPanel.add((Component)this.mConfigEnabled, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mDomain, (String)this.labelOssIdentityDomain);
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.mDomain, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.mDomain.getDocument().addDocumentListener(this.serviceAndDomainListener);
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mService, (String)this.labelOssServiceName);
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mService, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.mService.getDocument().addDocumentListener(this.serviceAndDomainListener);
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mUser, (String)CloudBrowserResources.getString("LABEL_OSS_USERNAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mUser, LayoutControl.GBC.gbc(1, 2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mPwd, (String)CloudBrowserResources.getString("LABEL_OSS_PASSWORD"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 3, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mPwd, LayoutControl.GBC.gbc(1, 3, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mUrl, (String)CloudBrowserResources.getString("LABEL_OSS_SERVICE_URL"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 4, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mUrl, LayoutControl.GBC.gbc(1, 4, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.mUrl.setToolTipText(CloudBrowserResources.getString("TOOLTIP_OSS_SERVICE_URL"));
        this.mUrl.getDocument().addDocumentListener(this.urlListener);
        jPanel.add((Component)LayoutControl.GBC.createSubPanel(jPanel2), LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    @Override
    public Component getInitialFocusComponent() {
        return this.mDomain;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = this.mConfigEnabled.isSelected();
        String string = this.mDomain.getText();
        String string2 = this.mService.getText();
        String string3 = this.mUser.getText();
        String string4 = this.mUrl.getText();
        if (bl) {
            if (!OSSPanel.isValid(string)) {
                this.mDomain.requestFocusInWindow();
                throw new TraversalException(CloudBrowserResources.format("ERROR_INVALID_OSS_CONFIG", CloudBrowserResources.getString("ERROR_MISSING_IDENTITY_DOMAIN")));
            }
            if (!OSSPanel.isValid(string2)) {
                this.mService.requestFocusInWindow();
                throw new TraversalException(CloudBrowserResources.format("ERROR_INVALID_OSS_CONFIG", CloudBrowserResources.getString("ERROR_MISSING_SERVICE_NAME")));
            }
            if (!OSSPanel.isValid(string3)) {
                this.mUser.requestFocusInWindow();
                throw new TraversalException(CloudBrowserResources.format("ERROR_INVALID_OSS_CONFIG", CloudBrowserResources.getString("ERROR_MISSING_USERNAME")));
            }
            if (!OSSPanel.isValid(string4)) {
                this.mUrl.requestFocusInWindow();
                throw new TraversalException(CloudBrowserResources.format("ERROR_INVALID_OSS_CONFIG", CloudBrowserResources.getString("ERROR_MISSING_SERVICE_URL")));
            }
        }
        traversableContext.put("oss.enabled", (Object)Boolean.toString(bl));
        traversableContext.put("oss.identity_domain", (Object)string);
        traversableContext.put("oss.service_name", (Object)string2);
        traversableContext.put("oss.username", (Object)string3);
        int n = string4.indexOf("/v1/");
        if (n > 0) {
            string4 = string4.substring(0, n);
            this.mUrl.setText(string4);
        }
        traversableContext.put("oss.service_url", (Object)string4);
        char[] cArray = this.mPwd.getPassword();
        traversableContext.put("oss.password", (Object)(cArray != null ? new String(cArray) : new String()));
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        String string = (String)traversableContext.get("oss.identity_domain");
        if (string != null) {
            this.mDomain.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.service_name")) != null) {
            this.mService.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.username")) != null) {
            this.mUser.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.password")) != null) {
            this.mPwd.setText(string);
        }
        string = (String)traversableContext.get("oss.service_url");
        this.initServiceUrl(string);
        string = (String)traversableContext.get("oss.enabled");
        boolean bl = Boolean.parseBoolean(string);
        this.mConfigEnabled.setSelected(bl);
    }

    public void addEnabledItemListener(ItemListener itemListener) {
        this.mConfigEnabled.addItemListener(itemListener);
    }

    private void enableControls(boolean bl) {
        this.mDomain.setEnabled(bl);
        this.mService.setEnabled(bl);
        this.mUser.setEnabled(bl);
        this.mPwd.setEnabled(bl);
    }

    private static boolean isValid(String string) {
        return string != null && string.trim().length() > 0;
    }

    private void initServiceUrl(String string) {
        this.userModifiedServiceUrl = false;
        if (null == string) {
            this.updateServiceUrl();
            return;
        }
        this.mUrl.setText(string);
        this.userModifiedServiceUrl = !this.composeServiceUrl().equals(string);
    }

    private String composeServiceUrl() {
        String string;
        String string2 = this.mService.getText();
        if (null == string2 || string2.isEmpty()) {
            string2 = '[' + StringUtils.stripMnemonic((String)this.labelOssServiceName) + ']';
        }
        if (null == (string = this.mDomain.getText()) || string.isEmpty()) {
            string = '[' + StringUtils.stripMnemonic((String)this.labelOssIdentityDomain) + ']';
        }
        return String.format(this.formatServiceUrl, string2, string);
    }

    private void updateServiceUrl() {
        if (!this.userModifiedServiceUrl) {
            this.mUrl.setText(this.composeServiceUrl());
            this.userModifiedServiceUrl = false;
        }
    }
}

