/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionManager;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.cloud.connection.ui.ConnectionPanelFactory;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class ConnectionEditor {
    private static ConnectionEditor INSTANCE;
    private static List<ConnectionPanelFactory> sPanelFactories;

    public static void registerConnectionPanelFactory(ConnectionPanelFactory connectionPanelFactory) {
        sPanelFactories.add(connectionPanelFactory);
    }

    public static synchronized ConnectionEditor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionEditor();
        }
        return INSTANCE;
    }

    public String createConnection(SessionType sessionType) {
        String string = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(sessionType);
        if (baseConnectionPanel != null) {
            CConnections cConnections = CConnections.getInstance(sessionType);
            Namespace namespace = baseConnectionPanel.createNamespace(null, cConnections.listConnections());
            SessionInfo sessionInfo = this.runDialog(baseConnectionPanel.getCreateTitle(), namespace, baseConnectionPanel);
            if (sessionInfo != null) {
                try {
                    cConnections.addConnection(sessionInfo.getName(), sessionInfo);
                    string = sessionInfo.getName();
                }
                catch (SessionException sessionException) {
                    ExceptionHandler.handleException((Throwable)sessionException);
                }
            }
        }
        return string;
    }

    public String editConnection(String string, SessionType sessionType) {
        String string2 = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(sessionType);
        if (baseConnectionPanel != null) {
            CConnections cConnections = CConnections.getInstance(sessionType);
            if (this.isConnectionOpen(cConnections, string)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CloudBrowserResources.format("EDIT_CONN_OPEN_CONN", string), (String)CloudBrowserResources.getString("EDIT_CONN_TITLE"), null);
                return null;
            }
            SessionInfo sessionInfo = cConnections.getConnectionInfo(string);
            Namespace namespace = baseConnectionPanel.createNamespace(sessionInfo, cConnections.listConnections());
            SessionInfo sessionInfo2 = this.runDialog(baseConnectionPanel.getEditTitle(), namespace, baseConnectionPanel);
            if (sessionInfo2 != null && ModelUtil.areDifferent((Object)sessionInfo, (Object)sessionInfo2)) {
                try {
                    string2 = sessionInfo2.getName();
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        cConnections.removeConnection(string);
                        cConnections.addConnection(string2, sessionInfo2);
                    } else {
                        cConnections.modifyConnection(string, sessionInfo2);
                    }
                }
                catch (SessionException sessionException) {
                    ExceptionHandler.handleException((Throwable)sessionException);
                    string2 = null;
                }
            }
        }
        return string2;
    }

    private boolean isConnectionOpen(SessionManager sessionManager, String string) {
        try {
            Session session = sessionManager.getConnection(string, false);
            return session != null && session.isOpen();
        }
        catch (SessionException sessionException) {
            Logger.warn(ConnectionEditor.class, (Throwable)sessionException);
            return false;
        }
    }

    private BaseConnectionPanel createPanel(SessionType sessionType) {
        ConnectionPanelFactory connectionPanelFactory;
        BaseConnectionPanel baseConnectionPanel = null;
        Iterator<ConnectionPanelFactory> iterator = sPanelFactories.iterator();
        while (iterator.hasNext() && (baseConnectionPanel = (connectionPanelFactory = iterator.next()).createConnectionEditorPanel(sessionType)) == null) {
        }
        return baseConnectionPanel;
    }

    private SessionInfo runDialog(String string, Namespace namespace, BaseConnectionPanel baseConnectionPanel) {
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)new TP(baseConnectionPanel), namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog().setInitialFocus(baseConnectionPanel.getInitialFocusComponent());
        tDialogLauncher.initDialog().getAccessibleContext().setAccessibleName(string);
        SessionInfo sessionInfo = null;
        if (tDialogLauncher.showDialog()) {
            sessionInfo = baseConnectionPanel.createConnectionInfo(namespace);
        }
        return sessionInfo;
    }

    static {
        sPanelFactories = new ArrayList<ConnectionPanelFactory>();
    }

    private static final class TP
    implements Traversable {
        private JPanel m_panel;
        private Traversable m_wrapped;

        TP(Traversable traversable) {
            this.m_wrapped = traversable;
        }

        public void onEntry(TraversableContext traversableContext) {
            this.m_wrapped.onEntry(traversableContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getComponent() {
            TP tP = this;
            synchronized (tP) {
                if (this.m_panel == null) {
                    this.m_panel = LayoutControl.GBC.createDialogMainPanel(this.m_wrapped.getComponent());
                }
            }
            return this.m_panel;
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            this.m_wrapped.onExit(traversableContext);
        }

        public Object getExitTransition() {
            return this.m_wrapped.getExitTransition();
        }

        public String getHelpID() {
            return this.m_wrapped.getHelpID();
        }
    }
}

