/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.cloud.connection.ui.PrivateHostPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public abstract class CustomConnectionPanel
extends BaseConnectionPanel {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private PrivateHostPanel m_host;
    protected JTextField m_user = new JTextField();

    protected CustomConnectionPanel() {
    }

    private PrivateHostPanel getHost() {
        if (this.m_host == null) {
            this.m_host = this.createHostPanel();
        }
        return this.m_host;
    }

    protected PrivateHostPanel createHostPanel() {
        return new PrivateHostPanel();
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        String string = this.m_user.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_USERNAME"));
        }
        traversableContext.put("Cloud.Username", (Object)string);
        this.getHost().onExit(traversableContext);
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        String string = (String)traversableContext.get("Cloud.Username");
        if (string != null) {
            this.m_user.setText(string);
        }
        this.getHost().onEntry(traversableContext);
    }

    @Override
    protected final Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(Math.max(dimension.width, 300), dimension.height);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            }
        };
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_name, (String)CloudBrowserResources.getString("NEW_CONN_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_name, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_user, (String)CloudBrowserResources.getString("NEW_CONN_USERNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_user, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.getHost().createComponent(jPanel, 2);
        return jPanel;
    }

    public String getHelpID() {
        return null;
    }

    @Override
    public String getCreateTitle() {
        return null;
    }

    @Override
    public String getEditTitle() {
        return null;
    }

    @Override
    protected Namespace createNamespace(SessionInfo sessionInfo, String[] stringArray) {
        Namespace namespace = super.createNamespace(sessionInfo, stringArray);
        namespace.put("Cloud.DefaultHostname", (Object)DEFAULT_HOSTNAME);
        return namespace;
    }
}

