/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.net.URI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.connection.ConnectionInfoReferenceable;
import oracle.dbtools.raptor.utils.persistence.PersistenceFactory;

public class CConnectionInfoFactory
extends PersistenceFactory<ConnectionInfoReferenceable> {
    static final String NAME = "CONNECTION_NAME";
    static final String USERNAME = "USERNAME";
    static final String AUTHENTICATION = "AUTHENTICATION";
    static final String ROOT = "ROOT_URI";
    static final String SERVICE_URI = "SERVICE_URI";
    static final String SFTP_USERNAME = "SFTP_USERNAME";
    static final String SFTP_AUTHENTICATION = "SFTP_AUTHENTICATION";
    static final String SFTP_HOST = "SFTP_HOST";
    static final String SFTP_PORT = "SFTP_PORT";
    static final String OSS_ENABLED = "OSS_ENABLED";
    static final String OSS_SERVICE_NAME = "OSS_SERVICE_NAME";
    static final String OSS_IDENTITY_DOMAIN = "OSS_IDENTITY_DOMAIN";
    static final String OSS_USERNAME = "OSS_USERNAME";
    static final String OSS_AUTHENTICATION = "OSS_AUTHENICATION";
    static final String OSS_SERVICE_URL = "OSS_SERVICE_URL";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        SessionInfo sessionInfo = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (name != null && name.size() > 0) {
                Object object2;
                String string = CConnectionInfoFactory.extractConnectionNameIgnoreType(name.toString());
                URI uRI = CConnectionInfoFactory.getURIValue(reference, ROOT);
                URI uRI2 = CConnectionInfoFactory.getURIValue(reference, SERVICE_URI);
                String string2 = CConnectionInfoFactory.getStringValue(reference, USERNAME);
                char[] cArray = CConnectionInfoFactory.getSecureValue(reference, AUTHENTICATION, string);
                SessionInfo.SftpInfo sftpInfo = null;
                String string3 = CConnectionInfoFactory.getStringValue(reference, SFTP_HOST);
                if (ModelUtil.hasLength((String)string3)) {
                    int n = CConnectionInfoFactory.getIntValue(reference, SFTP_PORT);
                    object2 = CConnectionInfoFactory.getStringValue(reference, SFTP_USERNAME);
                    char[] cArray2 = CConnectionInfoFactory.getSecureValue(reference, SFTP_AUTHENTICATION, string);
                    sftpInfo = new SessionInfo.SftpInfo((String)object2, cArray2, string3, n);
                }
                SessionInfo.OssInfo ossInfo = null;
                object2 = CConnectionInfoFactory.getBooleanValue(reference, OSS_ENABLED);
                if (object2 != null) {
                    boolean bl = (Boolean)object2;
                    String string4 = CConnectionInfoFactory.getStringValue(reference, OSS_SERVICE_NAME);
                    String string5 = CConnectionInfoFactory.getStringValue(reference, OSS_IDENTITY_DOMAIN);
                    String string6 = CConnectionInfoFactory.getStringValue(reference, OSS_USERNAME);
                    char[] cArray3 = CConnectionInfoFactory.getSecureValue(reference, OSS_AUTHENTICATION, string);
                    String string7 = CConnectionInfoFactory.getStringValue(reference, OSS_SERVICE_URL);
                    ossInfo = new SessionInfo.OssInfo(bl, string4, string5, string6, cArray3, string7);
                }
                sessionInfo = new SessionInfo(string, uRI, uRI2, string2, cArray, sftpInfo, ossInfo);
            }
        }
        return sessionInfo != null ? new ConnectionInfoReferenceable(sessionInfo) : null;
    }
}

