/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.ProcArg;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class IdentifiersDb {
    public static final IdentifiersDb instance = new IdentifiersDb();
    public final int adt_field = SqlEarley.getInstance().getSymbol("adt_field");
    public final int aggr = SqlEarley.getInstance().getSymbol("paren_aggr");
    public final int aliased_dml_table_expression_clause = SqlEarley.getInstance().getSymbol("aliased_dml_table_expression_clause");
    public final int alt_ty_attrs = SqlEarley.getInstance().getSymbol("alt_ty_attrs");
    public final int assignment_stmt = SqlEarley.getInstance().getSymbol("assignment_stmt");
    public final int basic_decl_item_list = SqlEarley.getInstance().getSymbol("basic_decl_item_list");
    public final int bind_var = SqlEarley.getInstance().getSymbol("bind_var");
    public final int block_stmt = SqlEarley.getInstance().getSymbol("block_stmt");
    public final int boolean_primary = SqlEarley.getInstance().getSymbol("boolean_primary");
    public final int cartesian_product = SqlEarley.getInstance().getSymbol("cartesian_product");
    public final int column_name = SqlEarley.getInstance().getSymbol("link_expanded_n");
    public final int designator = SqlEarley.getInstance().getSymbol("designator");
    public final int DECLARE_decls_opt = SqlEarley.getInstance().getSymbol("DECLARE_decls_opt");
    public final int decl_id = SqlEarley.getInstance().getSymbol("decl_id");
    public final int dml_table_expression_clause = SqlEarley.getInstance().getSymbol("dml_table_expression_clause");
    public final int dotted_name = SqlEarley.getInstance().getSymbol("dotted_name");
    public final int expr = SqlEarley.getInstance().getSymbol("expr");
    public final int fml_part = SqlEarley.getInstance().getSymbol("fml_part");
    public final int function = SqlEarley.getInstance().getSymbol("function");
    public final int func_return_prm_spec_unconstrained_type = SqlEarley.getInstance().getSymbol("func_return_prm_spec_unconstrained_type");
    public final int iteration_scheme = SqlEarley.getInstance().getSymbol("iteration_scheme");
    public final int identifier = SqlEarley.getInstance().getSymbol("identifier");
    public final int insert_into_clause = SqlEarley.getInstance().getSymbol("insert_into_clause");
    public final int loop_stmt = SqlEarley.getInstance().getSymbol("loop_stmt");
    public final int name = SqlEarley.getInstance().getSymbol("name");
    public final int name_wo_function_call = SqlEarley.getInstance().getSymbol("name_wo_function_call");
    public final int object_d = SqlEarley.getInstance().getSymbol("object_d");
    public final int object_d_rhs = SqlEarley.getInstance().getSymbol("object_d_rhs");
    public final int pkg_body = SqlEarley.getInstance().getSymbol("pkg_body");
    public final int pkg_spec = SqlEarley.getInstance().getSymbol("pkg_spec");
    public final int pls_expr = SqlEarley.getInstance().getSymbol("pls_expr");
    public final int prm_spec = SqlEarley.getInstance().getSymbol("prm_spec");
    public final int procedure_call = SqlEarley.getInstance().getSymbol("procedure_call");
    public final int query_table_expression = SqlEarley.getInstance().getSymbol("query_table_expression");
    public final int subquery = SqlEarley.getInstance().getSymbol("subquery");
    public final int select_list = SqlEarley.getInstance().getSymbol("select_list");
    public final int select_term = SqlEarley.getInstance().getSymbol("select_term");
    public final int column = SqlEarley.getInstance().getSymbol("column");
    public final int seq_of_stmts = SqlEarley.getInstance().getSymbol("seq_of_stmts");
    public final int sim_expr = SqlEarley.getInstance().getSymbol("sim_expr");
    public final int simple_expression = SqlEarley.getInstance().getSymbol("simple_expression");
    public final int sql_query_or_dml_stmt = SqlEarley.getInstance().getSymbol("sql_query_or_dml_stmt");
    public final int sql_statements = SqlEarley.getInstance().getSymbol("sql_statements");
    public final int stmt = SqlEarley.getInstance().getSymbol("stmt");
    public final int subprg_body = SqlEarley.getInstance().getSymbol("subprg_body");
    public final int subprg_spec = SqlEarley.getInstance().getSymbol("subprg_spec");
    public final int table_reference = SqlEarley.getInstance().getSymbol("table_reference");
    public final int unconstrained_type_wo_datetime = SqlEarley.getInstance().getSymbol("unconstrained_type_wo_datetime");
    public final int unconstrained_type = SqlEarley.getInstance().getSymbol("unconstrained_type");
    public final int where_clause = SqlEarley.getInstance().getSymbol("where_clause");

    public Map<ParseNode, Pair<Integer, Integer>> collectIdentifiers(ParseNode parseNode) {
        return this.collectIdentifiers(parseNode, false);
    }

    public Map<ParseNode, Pair<Integer, Integer>> collectIdentifiers(ParseNode parseNode, boolean bl) {
        TreeMap<ParseNode, Pair<Integer, Integer>> treeMap = new TreeMap<ParseNode, Pair<Integer, Integer>>();
        if (parseNode == null) {
            return treeMap;
        }
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (parseNode2.contains(this.loop_stmt)) {
                for (Object object : parseNode2.children()) {
                    if (!object.contains(this.iteration_scheme)) continue;
                    for (ParseNode parseNode3 : object.children()) {
                        if (!parseNode3.contains(this.identifier)) continue;
                        treeMap.put(parseNode3, (Pair<Integer, Integer>)new Pair((Object)(parseNode2.from + 1), (Object)parseNode2.to));
                    }
                }
                continue;
            }
            if (parseNode2.contains(this.block_stmt)) {
                for (Object object : parseNode2.children()) {
                    if (!object.contains(this.DECLARE_decls_opt)) continue;
                    for (ParseNode parseNode3 : object.descendants()) {
                        if (!parseNode3.contains(this.object_d)) continue;
                        for (ParseNode parseNode4 : parseNode3.children()) {
                            if (!parseNode4.contains(this.decl_id)) continue;
                            treeMap.put(parseNode4, (Pair<Integer, Integer>)new Pair((Object)(parseNode2.from + 1), (Object)parseNode2.to));
                        }
                    }
                }
                continue;
            }
            if (!bl && (parseNode2.contains(this.sql_query_or_dml_stmt) || parseNode2.contains(this.subquery))) {
                for (Object object : parseNode2.descendants()) {
                    if (!object.contains(this.table_reference) && !object.contains(this.aliased_dml_table_expression_clause)) continue;
                    treeMap.put((ParseNode)object, (Pair<Integer, Integer>)new Pair((Object)(parseNode2.from + 1), (Object)parseNode2.to));
                }
                continue;
            }
            if (!bl && parseNode2.contains(this.insert_into_clause)) {
                Object object;
                ParseNode parseNode5 = parseNode2.ancestor(this.sql_query_or_dml_stmt);
                if (parseNode5 != null) continue;
                object = parseNode2.descendants().iterator();
                while (object.hasNext()) {
                    ParseNode parseNode6 = (ParseNode)object.next();
                    if (!parseNode6.contains(this.aliased_dml_table_expression_clause)) continue;
                    treeMap.put(parseNode6, (Pair<Integer, Integer>)new Pair((Object)(parseNode2.from + 1), (Object)parseNode.to));
                }
                continue;
            }
            if (!parseNode2.contains(this.subprg_body) && !parseNode2.contains(this.pkg_body) || parseNode2.to - parseNode2.from < 2 || parseNode2.contains(this.DECLARE_decls_opt)) continue;
            for (Object object : parseNode2.children()) {
                if (!object.contains(this.subprg_spec) && !object.contains(this.basic_decl_item_list)) continue;
                for (ParseNode parseNode3 : object.descendants()) {
                    if (!parseNode3.contains(this.decl_id) || treeMap.get(parseNode3) != null) continue;
                    treeMap.put(parseNode3, (Pair<Integer, Integer>)new Pair((Object)(parseNode2.from + 1), (Object)parseNode2.to));
                }
            }
        }
        return treeMap;
    }

    public static ParseNode getIdentifierDefinition(String string, int n, List<LexerToken> list, Map<ParseNode, Pair<Integer, Integer>> map) {
        ParseNode parseNode = null;
        Integer n2 = null;
        Integer n3 = null;
        for (ParseNode parseNode2 : map.keySet()) {
            int n4 = (Integer)map.get(parseNode2).first();
            int n5 = (Integer)map.get(parseNode2).second();
            if (!parseNode2.content(list).equalsIgnoreCase(string) && (parseNode2.from > n || n + 1 > parseNode2.to) || n4 > n || n5 < n + 1 || parseNode != null && (n4 < n2 || n5 > n3)) continue;
            n2 = n4;
            n3 = n5;
            parseNode = parseNode2;
        }
        return parseNode;
    }

    public static List<ParseNode> getIdentifierDefs(int n, int n2, ParseNode parseNode) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        Map<ParseNode, Pair<Integer, Integer>> map = null;
        map = parseNode instanceof LazyNode ? IdentifiersDb.collectIdentifiers(n, n2, (LazyNode)parseNode) : instance.collectIdentifiers(parseNode);
        for (ParseNode parseNode2 : map.keySet()) {
            int n3 = (Integer)map.get(parseNode2).first();
            int n4 = (Integer)map.get(parseNode2).second();
            if (n3 > n || n2 > n4 && !IdentifiersDb.isOpenEndedSyntax(parseNode, parseNode2, n3, n4)) continue;
            arrayList.add(0, parseNode2);
        }
        return arrayList;
    }

    public static boolean isOpenEndedSyntax(ParseNode parseNode, ParseNode parseNode2, int n, int n2) {
        ParseNode parseNode3 = parseNode.descendant(n, n2 - 1, IdentifiersDb.instance.sql_statements);
        return parseNode2.contains(IdentifiersDb.instance.table_reference) && parseNode3 == null;
    }

    public static Map<ParseNode, Pair<Integer, Integer>> collectIdentifiers(LazyNode lazyNode) {
        return IdentifiersDb.collectIdentifiers(lazyNode.from, lazyNode.to, lazyNode);
    }

    public static Map<ParseNode, Pair<Integer, Integer>> collectIdentifiers(int n, int n2, LazyNode lazyNode) {
        TreeMap<ParseNode, Pair<Integer, Integer>> treeMap = new TreeMap<ParseNode, Pair<Integer, Integer>>();
        HashSet<Long> hashSet = new HashSet<Long>();
        for (LazyNode lazyNode2 : lazyNode.shallowDescendants()) {
            if (lazyNode2.to <= n || n2 <= lazyNode2.from || IdentifiersDb.covers(hashSet, lazyNode2) || !lazyNode2.isStmt(lazyNode)) continue;
            lazyNode2.expand();
            treeMap.putAll(instance.collectIdentifiers(lazyNode2.getBranch()));
            hashSet.add(Service.lPair((int)lazyNode2.from, (int)lazyNode2.to));
        }
        return treeMap;
    }

    private static boolean covers(Set<Long> set, LazyNode lazyNode) {
        for (long l : set) {
            if (Service.lX((long)l) > lazyNode.from || lazyNode.to > Service.lY((long)l)) continue;
            return true;
        }
        return false;
    }

    public static String guessType(ParseNode parseNode, List<LexerToken> list, ParseNode parseNode2, Map<ParseNode, Pair<Integer, Integer>> map, List<ProcArg> list2) {
        block21: {
            boolean bl;
            ParseNode parseNode3;
            block20: {
                ParseNode parseNode4 = parseNode.parent();
                if (parseNode4.contains(IdentifiersDb.instance.assignment_stmt)) {
                    for (ParseNode parseNode5 : parseNode4.children()) {
                        Token token = list.get((int)parseNode5.from).type;
                        if (parseNode5 == parseNode || parseNode5.from + 1 != parseNode5.to || token == Token.OPERATION) continue;
                        return IdentifiersDb.getType(parseNode5, token, list, parseNode2, map);
                    }
                    return null;
                }
                if (parseNode4.contains(IdentifiersDb.instance.boolean_primary)) {
                    for (ParseNode parseNode6 : parseNode4.children()) {
                        if (parseNode6 == parseNode) continue;
                        for (ParseNode parseNode7 : parseNode6.children()) {
                            if (!parseNode7.contains(IdentifiersDb.instance.sim_expr)) continue;
                            Token token = list.get((int)parseNode7.from).type;
                            return IdentifiersDb.getType(parseNode7, token, list, parseNode2, map);
                        }
                    }
                    return null;
                }
                parseNode3 = parseNode.ancestor(IdentifiersDb.instance.procedure_call);
                ParseNode parseNode8 = parseNode.ancestor(IdentifiersDb.instance.sim_expr);
                bl = false;
                boolean bl2 = false;
                if (parseNode3 != null && parseNode8 != null) {
                    if (parseNode3.from < parseNode8.from && parseNode8.to < parseNode3.to) {
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                } else if (parseNode3 != null) {
                    bl = true;
                } else if (parseNode8 != null) {
                    bl2 = true;
                }
                if (!bl2) break block20;
                for (ParseNode parseNode9 : parseNode8.descendants()) {
                    Token token;
                    if (parseNode9.from + 1 != parseNode9.to || (token = list.get((int)parseNode9.from).type) == Token.OPERATION) continue;
                    return IdentifiersDb.getType(parseNode9, token, list, parseNode2, map);
                }
                break block21;
            }
            if (!bl) break block21;
            ParseNode parseNode10 = parseNode.parent();
            boolean bl3 = false;
            String string = null;
            int n = 1;
            if (bl3) {
                string = list.get((int)parseNode10.from).content.toUpperCase();
            } else {
                int n2 = 0;
                for (LexerToken object : list) {
                    if (parseNode3.from < n2 && ",".equals(object.content)) {
                        ++n;
                    }
                    if (parseNode.from <= n2) break;
                    ++n2;
                }
            }
            Iterator iterator = parseNode3.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode11 = (ParseNode)iterator.next();
                if (parseNode11.from + 3 == parseNode11.to) {
                    String string2 = parseNode11.content(list).toUpperCase();
                    int n2 = string2.indexOf(46);
                    for (ProcArg procArg : list2) {
                        if (!(procArg.procedure.equals(string2.substring(n2 + 1)) && procArg.pkg.equals(string2.substring(0, n2)) && bl3 ? procArg.argumentName.equals(string) : procArg.argumentPos == n)) continue;
                        return procArg.type;
                    }
                }
            }
        }
        return null;
    }

    private static String getType(ParseNode parseNode, Token token, List<LexerToken> list, ParseNode parseNode2, Map<ParseNode, Pair<Integer, Integer>> map) {
        if (token == Token.QUOTED_STRING) {
            return "VARCHAR2";
        }
        if (token == Token.DIGITS) {
            return "NUMBER";
        }
        if (token == Token.IDENTIFIER) {
            ParseNode parseNode3 = IdentifiersDb.getIdentifierDefinition(parseNode.content(list), parseNode.from, list, map);
            if (parseNode3 == null) {
                return null;
            }
            for (ParseNode parseNode4 : parseNode3.parent().children()) {
                if (!parseNode4.contains(IdentifiersDb.instance.object_d_rhs)) continue;
                return list.get((int)parseNode4.from).content;
            }
            return null;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(IdentifiersDb.class, (String)"test1.sql");
        List list = LexerToken.parse((String)string);
        LazyNode lazyNode = StackParser.getInstance().parse(list);
        lazyNode.printTree();
        Map<ParseNode, Pair<Integer, Integer>> map = IdentifiersDb.collectIdentifiers(lazyNode);
        for (ParseNode parseNode : map.keySet()) {
            System.out.println(parseNode);
            System.out.println("-------------------> " + map.get(parseNode));
        }
    }
}

