/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;

public class OLAPDMLLexerToken
extends LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public OLAPDMLLexerToken(CharSequence charSequence, int n, int n2, Token token) {
        super(charSequence, n, n2, token);
        this.content = charSequence.toString().intern();
        this.begin = n;
        this.end = n2;
        this.type = token;
    }

    private static LinkedList<OLAPDMLLexerToken> tokenize(String string, boolean bl) {
        LinkedList<OLAPDMLLexerToken> linkedList = new LinkedList<OLAPDMLLexerToken>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", true);
        int n = 0;
        Object var6_5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().intern();
            n += string2.length();
            OLAPDMLLexerToken oLAPDMLLexerToken = null;
            if (linkedList.size() > 0) {
                oLAPDMLLexerToken = linkedList.getLast();
            }
            if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.LINE_COMMENT && !"\n".equals(string2)) {
                oLAPDMLLexerToken.content = oLAPDMLLexerToken.content + string2;
                continue;
            }
            if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.LINE_COMMENT && "\n".equals(string2)) {
                oLAPDMLLexerToken.end = n - string2.length();
                oLAPDMLLexerToken.end = oLAPDMLLexerToken.begin + oLAPDMLLexerToken.content.length();
            }
            if (!(oLAPDMLLexerToken == null || oLAPDMLLexerToken.type != Token.QUOTED_STRING || "'".equals(string2) || oLAPDMLLexerToken.content.endsWith("'") && oLAPDMLLexerToken.content.length() > 1)) {
                oLAPDMLLexerToken.content = oLAPDMLLexerToken.content.length() < 100 ? oLAPDMLLexerToken.content + string2 : "dumMy" + string2;
                oLAPDMLLexerToken.end = oLAPDMLLexerToken.begin + oLAPDMLLexerToken.content.length();
                continue;
            }
            if (!(oLAPDMLLexerToken == null || oLAPDMLLexerToken.type != Token.QUOTED_STRING || !"'".equals(string2) || var6_5 != null && !oLAPDMLLexerToken.content.endsWith(OLAPDMLLexerToken.quoteDelimiter(var6_5)) || oLAPDMLLexerToken.content.endsWith("'") && oLAPDMLLexerToken.content.length() > 1)) {
                var6_5 = null;
                oLAPDMLLexerToken.end = n;
                oLAPDMLLexerToken.content = string.substring(oLAPDMLLexerToken.begin, oLAPDMLLexerToken.end).intern();
                continue;
            }
            if ("\"".equals(string2) && oLAPDMLLexerToken != null) {
                oLAPDMLLexerToken.content = string2;
                oLAPDMLLexerToken.type = Token.LINE_COMMENT;
                continue;
            }
            if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.IDENTIFIER && oLAPDMLLexerToken.end == -11 && oLAPDMLLexerToken.content.startsWith("@") && !"\n".equals(string2) && !"\r".equals(string2)) {
                oLAPDMLLexerToken.content = oLAPDMLLexerToken.content + string2;
                continue;
            }
            if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.IDENTIFIER && oLAPDMLLexerToken.end == -11 && oLAPDMLLexerToken.content.startsWith("@") && ("\n".equals(string2) || "\r".equals(string2))) {
                oLAPDMLLexerToken.end = n - 1;
                linkedList.add(new OLAPDMLLexerToken(string2, n - 1, n, Token.WS));
                continue;
            }
            if (bl && "'".equals(string2)) {
                linkedList.add(new OLAPDMLLexerToken(string2, n - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if (" \n\r\t".contains(string2)) {
                linkedList.add(new OLAPDMLLexerToken(string2, n - 1, n, Token.WS));
                continue;
            }
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                if (OLAPDMLLexerToken.fixedExponent(string2, linkedList, n - string2.length())) continue;
                linkedList.add(new OLAPDMLLexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new OLAPDMLLexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return linkedList;
    }

    private static boolean fixedExponent(String string, LinkedList<OLAPDMLLexerToken> linkedList, int n) {
        if (!(string.contains("e") || string.contains("f") || string.contains("d"))) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "efd", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n += string2.length();
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                linkedList.add(new OLAPDMLLexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new OLAPDMLLexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String string) {
        return OLAPDMLLexerToken.parse(string, false, true);
    }

    public static List<LexerToken> parse(String string, boolean bl) {
        return OLAPDMLLexerToken.parse(string, bl, true);
    }

    public static List<LexerToken> parse(String string, boolean bl, boolean bl2) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        OLAPDMLLexerToken.parse(string, bl, bl2, arrayList);
        return arrayList;
    }

    private static void parse(String string, boolean bl, boolean bl2, List<LexerToken> list) {
        OLAPDMLLexerToken oLAPDMLLexerToken = null;
        for (OLAPDMLLexerToken oLAPDMLLexerToken2 : OLAPDMLLexerToken.tokenize(string, bl2)) {
            if (oLAPDMLLexerToken2.type == Token.QUOTED_STRING) {
                if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.QUOTED_STRING) {
                    oLAPDMLLexerToken.content = oLAPDMLLexerToken.content + oLAPDMLLexerToken2.content;
                    oLAPDMLLexerToken.end = oLAPDMLLexerToken2.end;
                    continue;
                }
                if (oLAPDMLLexerToken != null && oLAPDMLLexerToken.type == Token.IDENTIFIER && "n".equalsIgnoreCase(oLAPDMLLexerToken.content) && oLAPDMLLexerToken.end == oLAPDMLLexerToken2.begin) {
                    oLAPDMLLexerToken.begin = oLAPDMLLexerToken2.begin;
                    oLAPDMLLexerToken.end = oLAPDMLLexerToken2.end;
                    oLAPDMLLexerToken.type = oLAPDMLLexerToken2.type;
                    oLAPDMLLexerToken.content = oLAPDMLLexerToken2.content;
                    continue;
                }
            }
            if (oLAPDMLLexerToken2.content.startsWith("@")) {
                oLAPDMLLexerToken2.end = oLAPDMLLexerToken2.begin + oLAPDMLLexerToken2.content.length();
            }
            if (bl || oLAPDMLLexerToken2.type != Token.WS && oLAPDMLLexerToken2.type != Token.COMMENT && oLAPDMLLexerToken2.type != Token.LINE_COMMENT) {
                list.add(oLAPDMLLexerToken2);
            }
            oLAPDMLLexerToken = oLAPDMLLexerToken2;
        }
    }

    private static String quoteDelimiter(String string) {
        if ("<".equals(string)) {
            return ">";
        }
        if ("[".equals(string)) {
            return "]";
        }
        if ("{".equals(string)) {
            return "}";
        }
        if ("(".equals(string)) {
            return ")";
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "for MP_INT_PTILE_PREV_PT_COMP\ndo\n        v_temp_Log = joinchars('<BR> Period: ' periods ' Track: '  tracks)\n        v_Log = joinlines( v_Log, v_temp_Log )\n        v_period_id = periods\n        v_track_id  = tracks\n        tempstat periods\n        do\n           tempstat tracks\n           do\n                v_temp_Log = MP_INTL_PTILES(v_period_id,v_track_id)\n            doend\n        doend\n        v_Log = joinlines( v_Log, v_temp_Log,'<BR>')\ndoend";
        System.gc();
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l2 - l3));
        List<LexerToken> list = OLAPDMLLexerToken.parse(string, false, false);
        long l4 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (l4 - l));
        System.gc();
        l2 = Runtime.getRuntime().totalMemory();
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("mem1=" + (l2 - l3));
        System.out.println("#Tokens=" + list.size());
        OLAPDMLLexerToken.print(list);
    }
}

