/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import oracle.javatools.db.Column;
import oracle.olap.OLAPArb;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.panels.CubeDimensionInitializer;
import oracle.olap.cubedimension.panels.CubeDimensionLevelEditorPanel;
import oracle.olap.db.view.ChildListEditorPanel2;

public class CubeDimensionLevelPanel
extends ChildListEditorPanel2<CubeDimensionLevel, CubeDimension> {
    private boolean m_initialized;

    public CubeDimensionLevelPanel() {
        super(new CubeDimensionLevelEditorPanel(), "levels", true);
        this.setDbObjectInitializer(new CubeDimensionInitializer());
    }

    protected String getChildProperty() {
        return "levels";
    }

    protected Class getChildClass() {
        return CubeDimensionLevel.class;
    }

    protected String getListLabel() {
        return OLAPArb.getString("CUBE_DIMENSION_LEVELS");
    }

    protected CubeDimensionLevel newChild() {
        CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)super.newChild();
        ((CubeDimension)this.getUpdatedObject()).addLevel(cubeDimensionLevel);
        cubeDimensionLevel.setDataType("VARCHAR2(60)");
        cubeDimensionLevel.generateDescriptions();
        this.enableDescriptions(true);
        return cubeDimensionLevel;
    }

    @Override
    public String processColumName(String string) {
        if (string.endsWith("_ID")) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }

    @Override
    public void addRelationalColumnToList(Column column, String string, String string2) {
        CubeDimensionLevel cubeDimensionLevel = new CubeDimensionLevel(string);
        cubeDimensionLevel.generateDescriptions();
        String string3 = column.getName();
        String string4 = column.getRelation().getName();
        CubeDimensionMap cubeDimensionMap = new CubeDimensionMap(cubeDimensionLevel.getCubeDimension());
        cubeDimensionMap.setKeyExpression(string4 + "." + string3);
        cubeDimensionMap.setMapQuery(string4);
        cubeDimensionLevel.setMap(cubeDimensionMap);
        ((CubeDimension)this.getUpdatedObject()).addLevel(cubeDimensionLevel);
    }

    @Override
    protected boolean createDefaultChild() {
        return false;
    }

    public void enableDescriptions(boolean bl) {
        CubeDimensionLevelEditorPanel cubeDimensionLevelEditorPanel = (CubeDimensionLevelEditorPanel)this.createChildPanel();
        cubeDimensionLevelEditorPanel.enableDescriptions(bl);
    }
}

