/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.io.Reader;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperFactory;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.spec.FilterIterator;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class OLAPAggregationSpec
extends OLAPSpec {
    private static final String CONTEXT = "cube";
    private Properties props;
    private FetchIcon fetchIcon;

    public OLAPAggregationSpec(Properties properties, Reader reader, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, ErrorDisplay errorDisplay, Resources resources, FetchIcon fetchIcon, Connection connection) {
        super(properties, reader, syntaxParser, templateHelperFactory, errorDisplay, resources, fetchIcon, connection);
        this.props = properties;
        this.fetchIcon = fetchIcon;
    }

    @Override
    protected void processTemplates(SpecTreeNode specTreeNode, List<Template> list, TemplateGroup templateGroup) {
        if (templateGroup != null && templateGroup.getContext() != null && templateGroup.getContext().equalsIgnoreCase(CONTEXT) && templateGroup.isContainer()) {
            TemplateHelperFactoryImpl templateHelperFactoryImpl = (TemplateHelperFactoryImpl)this.getTemplateHelperFactory();
            Schema schema = templateHelperFactoryImpl.getSchema();
            String string = this.props.getProperty("CUBE");
            Cube cube = schema.findCube(string);
            for (Dimension dimension : cube.getDimensions()) {
                for (Template template : new FilterIterator<Template>(list, this.getTemplateFilter())) {
                    String string2 = template.getMenu().replace("{dimension}", dimension.getName());
                    SpecTreeNode specTreeNode2 = new SpecTreeNode(string2, template.getExpression(), template.getType(), true, template.getDoc(), this.fetchIcon.getIcon(template.getIcon()));
                    if (this.getTemplateHelperFactory() != null) {
                        this.props.setProperty("DIMENSION", dimension.getName());
                        TemplateHelper templateHelper = this.getTemplateHelperFactory().getInstance("DIMENSION", template, templateGroup);
                        if (templateHelper != null) {
                            specTreeNode2.setTemplateHelper(templateHelper);
                            this.addHelper(specTreeNode2);
                        }
                    }
                    specTreeNode.add(specTreeNode2);
                    if (template.isButton()) {
                        this.getButtonNodes().add(specTreeNode2);
                    }
                    if (!template.isDefault()) continue;
                    this.setDefaultSelection(specTreeNode2);
                }
            }
        } else {
            super.processTemplates(specTreeNode, list, templateGroup);
        }
    }

    @Override
    public SpecTreeNode findMatchingNode(ParseNode parseNode) {
        this.setCheckNameTrue(parseNode);
        return super.findMatchingNode(parseNode);
    }

    private void setCheckNameTrue(ParseNode parseNode) {
        if (parseNode.getChildren().isEmpty()) {
            String string = parseNode.getType();
            if (string.equalsIgnoreCase("dimension")) {
                parseNode.setCheckName(true);
            }
        } else {
            List<ParseNode> list = parseNode.getChildren();
            for (ParseNode parseNode2 : list) {
                this.setCheckNameTrue(parseNode2);
            }
        }
    }
}

