/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.model;

import java.util.HashMap;
import java.util.Map;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.model.ColumnAttributes;
import oracle.olap.app.tree.model.ColumnData;
import oracle.olap.app.tree.model.ColumnList;
import oracle.olap.app.tree.model.Tree;

@ColumnList(columns={@ColumnAttributes(name="Key"), @ColumnAttributes(name="Parent"), @ColumnAttributes(name="Level Name")})
public class HierarchyNodeData
implements ColumnData {
    public String dimKey;
    public String parent;
    public String desc;
    public Map<String, Object> properties;
    public Tree tree;

    public HierarchyNodeData(Tree tree) {
        this.tree = tree;
    }

    public String getName() {
        return this.dimKey;
    }

    @Override
    public Object getData(int n) {
        switch (n) {
            case 0: {
                return this.desc;
            }
            case 1: {
                return this.parent;
            }
        }
        return null;
    }

    @Override
    public void setData(int n, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            switch (n) {
                case 0: {
                    this.dimKey = string;
                    break;
                }
                case 1: {
                    this.desc = string;
                    break;
                }
                case 2: {
                    this.parent = string;
                }
            }
        }
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        Object object = null;
        if (this.properties != null) {
            object = this.properties.get(object);
        }
        return object;
    }

    public String toString() {
        String string = this.dimKey;
        if (this.desc != null && this.desc.length() > 0) {
            string = this.dimKey + " (" + this.desc + ")";
        }
        return string;
    }

    @Override
    public boolean matches(String string, Object object, SearchOptions searchOptions) {
        boolean bl = false;
        if (string.equals("KEY")) {
            bl = this.dimKey.equals(object);
            if (searchOptions != null && object instanceof String) {
                bl = searchOptions.match(this.dimKey, (String)object);
            }
        }
        if (string.equals("DESC") && this.desc != null) {
            bl = this.desc.equals(object);
            if (searchOptions != null && object instanceof String) {
                bl = searchOptions.match(this.desc, (String)object);
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            boolean bl = this.dimKey.equals(object);
            return bl;
        }
        return false;
    }
}

