/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamLevel
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamLevel.class.getName());
    private Dimension dimension;
    private static final ParseNode pattern = new ParseNode("level", Type.STRING.toString(), ParseNode.PatternType.NONE);

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode) {
            String string = ((ParseNode)object).getValue();
            if (string.charAt(0) == '\'') {
                string = string.substring(1, string.length() - 1);
            }
            IdentifierElement identifierElement = new IdentifierElement(string);
            String string2 = identifierElement.get(identifierElement.getCount() - 1);
            for (int i = 0; i < this.getComboBoxModel().getSize(); ++i) {
                DimensionLevel dimensionLevel = (DimensionLevel)this.getComboBoxModel().getElementAt(i);
                if (!dimensionLevel.getName().equals(string2)) continue;
                return this.setValue(dimensionLevel);
            }
        }
        return super.setValue(object);
    }

    public TemplateHyperParamLevel() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamLevel.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    protected String uiValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return ((DimensionLevel)object).getName();
    }

    @Override
    public int getPixelSize(int n) {
        return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getValue()));
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Dimension) {
            this.setDimension((Dimension)object);
        }
    }

    private void setDimension(Dimension dimension) {
        this.removeAllElements();
        this.dimension = dimension;
        boolean bl = this.isValid();
        if (dimension != null) {
            List<DimensionLevel> list = dimension.getLevels();
            if (list.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            for (DimensionLevel dimensionLevel : list) {
                this.addElement(dimensionLevel);
            }
        }
        if (bl != this.isValid()) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid()));
        }
    }

    @Override
    public Object getValue() {
        return this.getSelectedElement();
    }

    @Override
    public String getExpression() {
        Object object = this.getSelectedElement();
        if (object instanceof String) {
            return "";
        }
        DimensionLevel dimensionLevel = (DimensionLevel)object;
        return String.format("%s.%s", dimensionLevel.getDimension().getName(), dimensionLevel.getName());
    }
}

