/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.hyper;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import oracle.olap.app.hyper.HyperLinkCombo;
import oracle.olap.app.hyper.OperatorDisplay;

public class HyperComboRenderer
extends DefaultListCellRenderer {
    private boolean m_blnUnderlined;
    private JSeparator m_separator = new JSeparator();
    private HyperLinkCombo m_hyperLinkCombo;

    public HyperComboRenderer(HyperLinkCombo hyperLinkCombo) {
        this.m_hyperLinkCombo = hyperLinkCombo;
    }

    public HyperLinkCombo getHyperCombo() {
        return this.m_hyperLinkCombo;
    }

    public void setUnderlined(boolean bl) {
        this.m_blnUnderlined = bl;
    }

    public boolean isUnderlined() {
        return this.m_blnUnderlined;
    }

    @Override
    public void paint(Graphics graphics) {
        String string = this.getText();
        if (string != null && this.isUnderlined()) {
            Color color = graphics.getColor();
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = n / 2 - fontMetrics.stringWidth(string) / 2;
            int n4 = fontMetrics.getAscent();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n3, n4 - 1);
            graphics.drawLine(n3, n4, n - n3, n4);
            graphics.setColor(color);
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        this.setUnderlined(n == -1 && this.m_hyperLinkCombo.isHyperLink());
        if (object != null && object.equals("|")) {
            return this.m_separator;
        }
        if (this.m_hyperLinkCombo.isHyperLink() && object instanceof OperatorDisplay) {
            object2 = (OperatorDisplay)object;
            if (n == -1) {
                ((OperatorDisplay)object2).setDisplayJustSymbol(true);
            } else {
                ((OperatorDisplay)object2).setDisplayJustSymbol(false);
            }
        }
        object2 = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        ((Component)object2).setEnabled(!this.m_hyperLinkCombo.getDisabledItems().contains(this.m_hyperLinkCombo.getModel().getElementAt(n)));
        return object2;
    }
}

