/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.security.AccessController;
import javax.management.MBeanServer;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.Application;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.ApplicationImpl;
import oracle.jrf.wls.WlsPortConfig;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.PartitionTable;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.PartitionMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WlsServerPlatformSupport
extends AbstractServerPlatformSupport {
    @Override
    public String getPlatformName() {
        return "weblogic";
    }

    @Override
    public boolean isWebLogic() {
        return true;
    }

    @Override
    public String getServerConfigDirectory(String domainHome, String serverName) throws PortabilityLayerException {
        return JrfUtils.getServersConfigDir(domainHome) + File.separator + serverName;
    }

    @Override
    public String getDomainName() throws PortabilityLayerException {
        if (this.domainName == null) {
            this.domainName = ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomainName();
        }
        return this.domainName;
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        if (this.serverName == null) {
            this.serverName = System.getProperty("weblogic.Name");
        }
        return this.serverName;
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        if (this.adminServerName == null) {
            return ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getAdminServerName();
        }
        return this.adminServerName;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            this.serverLogPath = JrfUtils.getDomainHome() + File.separator + "servers" + File.separator + this.getServerName() + File.separator + "logs";
        }
        return new File(this.serverLogPath).getAbsolutePath();
    }

    String removePartitionFromApplicationName(String applicationName, String partitionName) {
        int i;
        if (applicationName != null && partitionName != null && (i = applicationName.lastIndexOf(partitionName)) > 0 && applicationName.charAt(i - 1) == '$') {
            return applicationName.substring(0, i - 1);
        }
        return applicationName;
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier appIdentifier = null;
        try {
            ComponentInvocationContext cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext();
            String globalPartitionName = PartitionTable.getInstance().getGlobalPartitionName();
            String partitionName = cic.getPartitionName();
            ClassLoader threadCl = Thread.currentThread().getContextClassLoader();
            ApplicationAccess access = ApplicationAccess.getApplicationAccess();
            String applicationName = this.removePartitionFromApplicationName(access.getApplicationName(threadCl), partitionName);
            String version = this.removePartitionFromApplicationName(access.getApplicationVersion(threadCl), partitionName);
            boolean globalPartition = partitionName != null && globalPartitionName != null && partitionName.equals(globalPartitionName);
            appIdentifier = new ApplicationIdentifier(applicationName, version, globalPartition ? null : partitionName, globalPartition);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{e.getMessage()}), e);
        }
        return appIdentifier;
    }

    @Override
    public Application getApplication() throws PortabilityLayerException {
        ApplicationImpl application = null;
        try {
            String depName;
            AppDeploymentMBean depMbean;
            ComponentInvocationContext cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext();
            String applicationName = cic.getApplicationName();
            String version = cic.getApplicationVersion();
            String partitionName = cic.getPartitionName();
            if (applicationName == null) {
                ClassLoader threadCl = Thread.currentThread().getContextClassLoader();
                ApplicationAccess access = ApplicationAccess.getApplicationAccess();
                applicationName = this.removePartitionFromApplicationName(access.getApplicationName(threadCl), partitionName);
                version = this.removePartitionFromApplicationName(access.getApplicationVersion(threadCl), partitionName);
            }
            String globalPartitionName = PartitionTable.getInstance().getGlobalPartitionName();
            boolean globalPartition = partitionName != null && globalPartitionName != null && partitionName.equals(globalPartitionName);
            boolean isNonMSID = true;
            application = new ApplicationImpl(applicationName, version, globalPartition ? null : partitionName);
            ApplicationAccess access = ApplicationAccess.getApplicationAccess();
            ApplicationContextInternal appCtx = access.getApplicationContext(((Application)application).getDeploymentName());
            if (appCtx != null && (depMbean = appCtx.getAppDeploymentMBean()) != null && (depName = depMbean.getConfiguredApplicationIdentifier()) != null) {
                isNonMSID = false;
                application = new ApplicationImpl(applicationName, version, globalPartition ? null : partitionName, depName);
            }
            if (isNonMSID) {
                application = new ApplicationImpl(applicationName, version, globalPartition ? null : partitionName);
            }
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{e.getMessage()}), e);
        }
        return application;
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        ClusterMBean cluster = WlsServerPlatformSupport.getLocalServerMBean().getCluster();
        if (cluster != null) {
            return cluster.getName();
        }
        return null;
    }

    @Override
    public PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new WlsPortConfig();
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    protected static ServerMBean getLocalServerMBean() {
        return ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getServer();
    }

    protected static ServerMBean getServerMBean(String serverName) throws PortabilityLayerException {
        ServerMBean serverMBean = null;
        for (ServerMBean server : ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomain().getServers()) {
            if (!server.getName().equals(serverName)) continue;
            serverMBean = server;
        }
        if (serverMBean == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{serverName}));
        }
        return serverMBean;
    }

    private MBeanServer getRuntimeMBeanServer() {
        return ManagementService.getRuntimeMBeanServer((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity());
    }

    private static AuthenticatedSubject getKernelIdentity() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    @Override
    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        if (this.getServerName().equals(serverId)) {
            return this.getPortConfig();
        }
        try {
            return new WlsPortConfig(serverId);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    @Override
    public boolean isExalogicOptimizationsEnabled() {
        if (this.isExalogicOptimizationsEnabled == null) {
            this.isExalogicOptimizationsEnabled = ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomain().isExalogicOptimizationsEnabled();
        }
        return this.isExalogicOptimizationsEnabled;
    }

    @Override
    public String getPartitionName() {
        String partitionName = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext().getPartitionName();
        String globalPartitionName = PartitionTable.getInstance().getGlobalPartitionName();
        boolean globalPartition = partitionName != null && globalPartitionName != null && partitionName.equals(globalPartitionName);
        return globalPartition ? null : partitionName;
    }

    static PartitionMBean getPartitionMBean(String partitionName) {
        if (partitionName != null) {
            return ManagementService.getRuntimeAccess((AuthenticatedSubject)WlsServerPlatformSupport.getKernelIdentity()).getDomain().lookupPartition(partitionName);
        }
        return null;
    }
}

