/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical.graphbase;

import ilog.views.graphlayout.hierarchical.graphbase.HTBaseGraphMember;
import ilog.views.graphlayout.hierarchical.graphbase.HTBaseNode;

public class HTBaseEdge
extends HTBaseGraphMember {
    protected HTBaseNode _source = null;
    protected HTBaseNode _target = null;
    protected HTBaseEdge _prevInEdge = null;
    protected HTBaseEdge _nextInEdge = null;
    protected HTBaseEdge _prevOutEdge = null;
    protected HTBaseEdge _nextOutEdge = null;

    public final HTBaseNode getHTSource() {
        return this._source;
    }

    public final HTBaseNode getHTTarget() {
        return this._target;
    }

    public final void insertBeforeInEdge(HTBaseNode hTBaseNode, HTBaseEdge hTBaseEdge) {
        this._target = hTBaseNode;
        this._nextInEdge = hTBaseEdge;
        if (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._prevInEdge;
            hTBaseEdge._prevInEdge = this;
            if (hTBaseEdge2 != null) {
                hTBaseEdge2._nextInEdge = this;
                this._prevInEdge = hTBaseEdge2;
            }
        }
    }

    public final void insertBeforeOutEdge(HTBaseNode hTBaseNode, HTBaseEdge hTBaseEdge) {
        this._source = hTBaseNode;
        this._nextOutEdge = hTBaseEdge;
        if (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._prevOutEdge;
            hTBaseEdge._prevOutEdge = this;
            if (hTBaseEdge2 != null) {
                hTBaseEdge2._nextOutEdge = this;
                this._prevOutEdge = hTBaseEdge2;
            }
        }
    }

    public final void insertAfterInEdge(HTBaseNode hTBaseNode, HTBaseEdge hTBaseEdge) {
        this._target = hTBaseNode;
        this._prevInEdge = hTBaseEdge;
        if (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._nextInEdge;
            hTBaseEdge._nextInEdge = this;
            if (hTBaseEdge2 != null) {
                hTBaseEdge2._prevInEdge = this;
                this._nextInEdge = hTBaseEdge2;
            }
        }
    }

    public final void insertAfterOutEdge(HTBaseNode hTBaseNode, HTBaseEdge hTBaseEdge) {
        this._source = hTBaseNode;
        this._prevOutEdge = hTBaseEdge;
        if (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._nextOutEdge;
            hTBaseEdge._nextOutEdge = this;
            if (hTBaseEdge2 != null) {
                hTBaseEdge2._prevOutEdge = this;
                this._nextOutEdge = hTBaseEdge2;
            }
        }
    }

    public final HTBaseEdge removeInEdge() {
        HTBaseEdge hTBaseEdge = this._nextInEdge;
        if (this._prevInEdge != null) {
            this._prevInEdge._nextInEdge = this._nextInEdge;
        }
        if (this._nextInEdge != null) {
            this._nextInEdge._prevInEdge = this._prevInEdge;
        }
        this._prevInEdge = null;
        this._nextInEdge = null;
        return hTBaseEdge;
    }

    public final HTBaseEdge removeOutEdge() {
        HTBaseEdge hTBaseEdge = this._nextOutEdge;
        if (this._prevOutEdge != null) {
            this._prevOutEdge._nextOutEdge = this._nextOutEdge;
        }
        if (this._nextOutEdge != null) {
            this._nextOutEdge._prevOutEdge = this._prevOutEdge;
        }
        this._prevOutEdge = null;
        this._nextOutEdge = null;
        return hTBaseEdge;
    }

    public final HTBaseEdge getPrevInEdge() {
        return this._prevInEdge;
    }

    public final HTBaseEdge getPrevOutEdge() {
        return this._prevOutEdge;
    }

    public final boolean isContainedInIncoming(HTBaseEdge hTBaseEdge) {
        while (hTBaseEdge != null) {
            if (hTBaseEdge == this) {
                return true;
            }
            hTBaseEdge = hTBaseEdge._nextInEdge;
        }
        return false;
    }

    public final boolean isContainedInOutgoing(HTBaseEdge hTBaseEdge) {
        while (hTBaseEdge != null) {
            if (hTBaseEdge == this) {
                return true;
            }
            hTBaseEdge = hTBaseEdge._nextOutEdge;
        }
        return false;
    }

    public final boolean isSelfLoop() {
        return this._source == this._target;
    }

    public void reverse() {
        if (this._source == this._target) {
            return;
        }
        if (this.getOwner() != null) {
            HTBaseNode hTBaseNode = this._source;
            HTBaseNode hTBaseNode2 = this._target;
            hTBaseNode.removeOutEdge(this);
            hTBaseNode2.removeInEdge(this);
            hTBaseNode.addInEdge(this);
            hTBaseNode2.addOutEdge(this);
        } else {
            this.reverseTemporarily();
        }
    }

    public final void reverseTemporarily() {
        HTBaseNode hTBaseNode = this._source;
        this._source = this._target;
        this._target = hTBaseNode;
    }

    public boolean isIntergraphEdge() {
        if (this._source == null || this._target == null) {
            return false;
        }
        return this._source.getOwner() != this._target.getOwner();
    }

    public HTBaseNode getOppositeBaseNode(HTBaseNode hTBaseNode) {
        return hTBaseNode == this._source ? this._target : this._source;
    }
}

