/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.ide.help.HelpSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

abstract class AnalyzeAction
extends RaptorTask<Void> {
    protected WorksheetContext ctx;
    int cursorPosition = 0;
    int cursorStart = 0;
    int cursorEnd = 0;
    protected Connection conn;
    protected AutotracePanel autoTracePanel = null;
    static final SqlEarley earley = SqlEarley.getInstance();

    public AnalyzeAction(String string, String string2, WorksheetContext worksheetContext) {
        super(string, true, IRaptorTaskRunMode.TASKVIEWER);
        this.ctx = worksheetContext;
        this.setPausable(false);
        this.setCancellable(true);
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public AutotracePanel getAutoTracePanel() {
        return this.autoTracePanel;
    }

    public void setAutoTracePanel(AutotracePanel autotracePanel) {
        this.autoTracePanel = autotracePanel;
        this.autoTracePanel.setContext(this.ctx);
    }

    public String extractSql(String string) {
        this.cursorPosition = this.ctx.getEditor().getCaretPosition();
        this.cursorStart = this.ctx.getEditor().getSelectionStart();
        this.cursorEnd = this.ctx.getEditor().getSelectionEnd();
        String string2 = this.ctx.getParser().text;
        return AnalyzeAction.extractSql(this.cursorPosition, string2, string);
    }

    public static String extractSql(int n, String string, String string2) {
        List list = LexerToken.parse((String)string);
        int n2 = LexerToken.scanner2parserOffset((List)list, (int)n);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(list, matrix);
        long l = AnalyzeAction.getStatement(list, matrix, n2);
        if (l != -1L) {
            string = string.substring(((LexerToken)list.get((int)Service.lX((long)l))).begin, ((LexerToken)list.get((int)(Service.lY((long)l) - 1))).end);
        } else {
            Logger.getLogger(AutotraceAction.class.getName()).log(Level.WARNING, "AutotraceAction.getStatement() failed");
            int n3 = 0;
            int n4 = string.length();
            for (LexerToken lexerToken : list) {
                if (!";".equals(lexerToken.content)) continue;
                if (lexerToken.begin < n) {
                    n3 = lexerToken.end;
                }
                if (n >= lexerToken.end) continue;
                n4 = lexerToken.begin;
                break;
            }
            string = string.substring(n3, n4);
        }
        string = string.trim();
        if (string.endsWith("/") && !string.endsWith("*/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null) {
            string = "/*" + string2 + "*/ " + string;
        }
        return string;
    }

    private static long getStatement(List<LexerToken> list, Matrix matrix, int n) {
        int n2 = SqlEarley.getInstance().getSymbol("sql_statement");
        int n3 = SqlEarley.getInstance().getSymbol("sql_stmt");
        int n4 = 0;
        int n5 = matrix.lastY();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                long[] lArray;
                Cell cell;
                int n6 = n4 + j;
                int n7 = n5 + j - i;
                if (n < n6 || n7 <= n || (cell = matrix.get(n6, n7)) == null) continue;
                for (long l : lArray = cell.getContent()) {
                    int n8 = Earley.ruleFromEarleyCell((long)l);
                    Earley.Tuple tuple = SqlEarley.getInstance().rules[n8];
                    if (tuple.head != n2 && tuple.head != n3) continue;
                    return Service.lPair((int)n6, (int)n7);
                }
            }
        }
        return -1L;
    }

    public int[] getSelectionLineColumn() {
        int n = this.ctx.getEditor().getSelectionStart();
        BasicDocument basicDocument = (BasicDocument)this.ctx.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        int n3 = lineMap.getLineStartOffset(n2 - 1);
        int n4 = n - n3 + 1;
        int[] nArray = new int[]{n2, n4};
        return nArray;
    }

    protected boolean init() {
        try {
            this.conn = Connections.getInstance().getConnection(this.ctx.getConnectionName());
        }
        catch (DBException dBException) {
            return false;
        }
        return true;
    }

    protected void showResultPanel() {
        if (this.ctx != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.autoTracePanel, "f1_explainplan_html");
            this.ctx.getCallback().showResultPanel(this.autoTracePanel);
            this.autoTracePanel.open();
        }
    }

    void resetCursor() {
        BasicEditorPane basicEditorPane = this.ctx.getEditor();
        SwingUtilities.invokeLater(new CursorUI(this.cursorPosition, this.cursorStart != this.cursorEnd, this.cursorStart, this.cursorEnd, basicEditorPane));
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile((String)"/EclipseWorkspace/common/common/src/oracle/dbtools/parser/plsql/test.sql");
        List list = LexerToken.parse((String)string);
        int n = 2;
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(list, matrix);
        long l = AnalyzeAction.getStatement(list, matrix, n);
        if (l > -1L) {
            System.out.println(string.substring(((LexerToken)list.get((int)Service.lX((long)l))).begin, ((LexerToken)list.get((int)(Service.lY((long)l) - 1))).end));
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        n = 46;
        for (LexerToken lexerToken : list) {
            if (!";".equals(lexerToken.content)) continue;
            if (lexerToken.begin < n) {
                n2 = lexerToken.end;
            }
            if (n >= lexerToken.end) continue;
            n3 = lexerToken.begin;
            break;
        }
        System.out.println(string.substring(n2, n3));
    }
}

