/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import oracle.ide.Addin;
import oracle.ide.util.Assert;
import oracle.ideimpl.memwatch.LowMemoryHandler;

public final class LowMemoryDetector
implements Addin {
    private static final long K = 0x100000L;
    private static final long PERM_GEN_WARN_ON_MAX_DELTA = 0xF00000L;
    private static final long HEAP_MEM_WARN_ON_MAX_DELTA = 0x1E00000L;
    private static final boolean DEBUG = false;
    private MemoryPoolMXBean m_PermGenMemoryPoolMXBean;

    @Override
    public void initialize() {
        this.m_PermGenMemoryPoolMXBean = LowMemoryDetector.getPermGenMemoryPoolMXBean();
        if (this.m_PermGenMemoryPoolMXBean == null) {
            Assert.println((String)"Low Memory Detector Disabled: The feature doesn't support Concurrent Mark & Sweep GC. PermGenMemoryPoolMXBean could not be found.");
        } else {
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
            notificationEmitter.addNotificationListener(new NotificationListenerImpl(), null, null);
            this.m_PermGenMemoryPoolMXBean.setCollectionUsageThreshold(this.m_PermGenMemoryPoolMXBean.getUsage().getMax() - 0xF00000L);
            LowMemoryDetector.setHeapMemoryPoolMXBeanUsageThreshold(true);
        }
    }

    private static MemoryPoolMXBean getPermGenMemoryPoolMXBean() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            String poolName = memoryPoolMXBean.getName();
            if (!poolName.equals("Perm Gen") && !poolName.equals("PS Perm Gen")) continue;
            return memoryPoolMXBean;
        }
        return null;
    }

    private static void setHeapMemoryPoolMXBeanUsageThreshold(boolean activate) {
        long halfWarningSize = 0xF00000L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            long usageThreshhold;
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isCollectionUsageThresholdSupported()) continue;
            if (!activate) {
                usageThreshhold = 0L;
            } else {
                long max = memoryPoolMXBean.getUsage().getMax();
                if (max <= 0x1E00000L) continue;
                usageThreshhold = max - 0xF00000L;
            }
            memoryPoolMXBean.setCollectionUsageThreshold(usageThreshhold);
        }
    }

    private final class NotificationListenerImpl
    implements NotificationListener {
        private NotificationListenerImpl() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.collection.threshold.exceeded")) {
                MemoryNotificationInfo memoryNotificationInfo = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                if (memoryNotificationInfo.getPoolName().equals(LowMemoryDetector.this.m_PermGenMemoryPoolMXBean.getName())) {
                    LowMemoryDetector.this.m_PermGenMemoryPoolMXBean.setCollectionUsageThreshold(0L);
                    MemoryUsage memoryUsage = LowMemoryDetector.this.m_PermGenMemoryPoolMXBean.getUsage();
                    LowMemoryHandler.handleLowMemory(1, memoryUsage.getUsed() / 0x100000L, memoryUsage.getMax() / 0x100000L);
                } else {
                    MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                    if (memoryUsage.getMax() - memoryUsage.getUsed() <= 0x1E00000L) {
                        LowMemoryDetector.setHeapMemoryPoolMXBeanUsageThreshold(false);
                        LowMemoryHandler.handleLowMemory(0, memoryUsage.getUsed() / 0x100000L, memoryUsage.getMax() / 0x100000L);
                    }
                }
            }
        }
    }
}

