/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.help.AboutBoxPage;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public abstract class AboutTablePage
extends AboutBoxPage {
    private static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(4, 6, 6, 6);
    private GenericTable _table;
    private JScrollPane _scrollPane;
    private Component _component;
    private BlockingComponent _blockingComponent;
    private String _filterText = "";
    private TableRowSorter _sorter;

    protected abstract TableModel buildTableModel();

    protected boolean isTableModelAvailable() {
        return true;
    }

    @Override
    public final Component getComponent() {
        if (this._component == null) {
            JPanel component = new JPanel(new BorderLayout(0, 4));
            component.setBorder(PANEL_BORDER);
            this._table = new KeyNavigableNiceTable(){

                protected void createDefaultRenderers() {
                    super.createDefaultRenderers();
                    AboutTablePage.this.configureTableRenderers(this);
                }
            };
            this._table.setAutoResizeMode(0);
            this._scrollPane = new JScrollPane((Component)this._table);
            SearchField searchField = new SearchField(SearchField.Style.FILTER);
            searchField.getTextField().setColumns(16);
            searchField.setAlignmentX(0.0f);
            AccessibleContext ac = searchField.getTextField().getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(IdeImplArb.getString(84));
            }
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)searchField, "Before");
            searchField.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    AboutTablePage.this._filterText = se.getSearchText().toLowerCase();
                    AboutTablePage.this._sorter.sort();
                }

                public void searchCategoryChanged(SearchEvent se) {
                }
            });
            component.add((Component)northPanel, "North");
            component.add((Component)this._scrollPane, "Center");
            this.setInitialFocus((Component)this._table);
            this._blockingComponent = new BlockingComponent((JComponent)component);
            this._component = this._blockingComponent.getBlockingComponent();
        }
        return this._component;
    }

    protected void configureTable(GenericTable table) {
    }

    protected void configureTableRenderers(GenericTable table) {
    }

    @Override
    public final void populate() {
        if (!this.isTableModelAvailable()) {
            this._blockingComponent.setMessage(BlockingComponent.Message.LOADING);
            this._blockingComponent.setState(BlockingComponent.State.BLOCKED);
        }
        TableModel model = this.buildTableModel();
        this.setDataModel(model);
    }

    private void setDataModel(TableModel dataModel) {
        assert (SwingUtilities.isEventDispatchThread()) : "Atempting to set the table model off the EDT!";
        this._table.setModel(dataModel);
        this._table.setSortColumn(0, true);
        this.configureTable(this._table);
        this._table.autoSizeColumnsToFit();
        this._sorter = (TableRowSorter)this._table.getRowSorter();
        RowFilter filter = new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                if (AboutTablePage.this._filterText.equals("")) {
                    return true;
                }
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!AboutTablePage.this.isColumnFilterable(i) || !entry.getStringValue(i).toLowerCase().contains(AboutTablePage.this._filterText)) continue;
                    return true;
                }
                return false;
            }
        };
        this._sorter.setRowFilter(filter);
    }

    protected boolean isColumnFilterable(int i) {
        return true;
    }

    protected final void dataModelComputed(final TableModel dataModel) {
        this._blockingComponent.setMessage(BlockingComponent.Message.NO_MESSAGE);
        this._blockingComponent.setState(BlockingComponent.State.UNBLOCKED);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDataModel(dataModel);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutTablePage.this.setDataModel(dataModel);
                }
            });
        }
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        TableModel model = this._table.getModel();
        StringBuilder headers = new StringBuilder();
        StringBuilder underlines = new StringBuilder();
        for (int c = 0; c < model.getColumnCount(); ++c) {
            String colName = model.getColumnName(c);
            String title = colName == null ? "" : colName;
            headers.append(String.valueOf(title));
            if (c < model.getColumnCount() - 1) {
                headers.append('\t');
            }
            int titleLength = Math.max(1, title.length());
            for (int i = 0; i < titleLength; ++i) {
                underlines.append('=');
            }
            if (c >= model.getColumnCount() - 1) continue;
            underlines.append('\t');
        }
        sb.append((CharSequence)headers);
        sb.append('\n');
        sb.append((CharSequence)underlines);
        sb.append('\n');
        for (int r = 0; r < model.getRowCount(); ++r) {
            for (int c = 0; c < model.getColumnCount(); ++c) {
                Object modelValue;
                TableCellRenderer renderer = this._table.getCellRenderer(r, c);
                Component rc = renderer.getTableCellRendererComponent((JTable)this._table, modelValue = model.getValueAt(r, c), false, false, r, c);
                if (rc instanceof JLabel) {
                    sb.append(((JLabel)rc).getText());
                } else if (modelValue == null) {
                    sb.append("");
                } else {
                    sb.append(String.valueOf(modelValue));
                }
                if (c >= model.getColumnCount() - 1) continue;
                sb.append('\t');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class KeyNavigableNiceTable
    extends GenericTable {
        private final KeyNavigationManager _knm = new KeyNavigationManager();

        public KeyNavigableNiceTable() {
            this._knm.setKeyComponentAdapter(new KeyNavigationManager.TableKeyAdapter((JTable)((Object)this)));
        }

        protected void processKeyEvent(KeyEvent e) {
            if (this._knm != null) {
                this._knm.preProcessKeyEvent(e);
            }
            super.processKeyEvent(e);
            if (this._knm != null) {
                this._knm.postProcessKeyEvent(e);
            }
        }
    }
}

