/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.ide.extension.Extension;
import net.jcip.annotations.Immutable;
import oracle.ide.extension.ExtensionQueue;
import oracle.ideimpl.extension.IDEExtension;

@Immutable
public class DefaultExtensionQueue
implements ExtensionQueue {
    private LinkedHashSet<Extension> _queue;
    private int _cachedSize = -1;

    private DefaultExtensionQueue(LinkedHashSet<Extension> queue) {
        this._queue = queue;
    }

    @Override
    public Iterator iterator() {
        return this._queue.iterator();
    }

    @Override
    public int size() {
        if (this._cachedSize == -1) {
            this._cachedSize = this._queue.size();
        }
        return this._cachedSize;
    }

    @Override
    public boolean contains(Extension extension) {
        return this._queue.contains(extension);
    }

    public static ExtensionQueue.Builder createBuilder() {
        return new DefaultBuilder();
    }

    public String toString() {
        if (this._queue == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Extension e : this._queue) {
            sb.append("{").append(e.toString()).append(" -> ").append(e instanceof IDEExtension ? ((IDEExtension)e).getState() : " <state unavailable>").append("}\n");
        }
        return sb.toString();
    }

    private static class DefaultBuilder
    implements ExtensionQueue.Builder {
        private LinkedHashSet<Extension> _sortedExtensionSet = new LinkedHashSet();

        @Override
        public void add(Extension extension) {
            this._sortedExtensionSet.add(extension);
        }

        @Override
        public ExtensionQueue build() {
            LinkedHashSet<Extension> copy = new LinkedHashSet<Extension>();
            copy.addAll(this._sortedExtensionSet);
            return new DefaultExtensionQueue(copy);
        }
    }
}

