/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibilityLayout;

abstract class AbstractDockPanelHost
implements DockPanelHost {
    AbstractDockPanelHost() {
    }

    @Override
    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        DockPanel dockPanel = this.getDockPanel();
        switch (criteria.getSearchFor()) {
            case 4: {
                if (dockPanel != criteria.getCriteria()) break;
                path.setDockPanel(dockPanel);
                return true;
            }
        }
        if (dockPanel.getDockablePath(path, criteria)) {
            path.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    @Override
    public DockInsertionPoint getClosestDockInsertionPoint(Point pt, Dimension moveBy, TitledPanel excludeTitledPanel) {
        DockPanel dockPanel = this.getDockPanel();
        return dockPanel.getClosestDockInsertionPoint(pt, moveBy, excludeTitledPanel);
    }

    @Override
    public void getDockablePaths(List<DockablePath> dockablePaths) {
        DockPanel dockPanel = this.getDockPanel();
        int sizeBefore = dockablePaths.size();
        dockPanel.getDockablePaths(dockablePaths);
        for (int i = sizeBefore; i < dockablePaths.size(); ++i) {
            DockablePath dockablePath = dockablePaths.get(i);
            dockablePath.setDockPanelHost(this);
        }
    }

    @Override
    public void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        dockPanel.setDockableVisible(dockablePath, bVisible, flags);
    }

    @Override
    public boolean activateDockable(DockablePath dockablePath) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        return dockPanel.activateDockable(dockablePath);
    }

    @Override
    public boolean getActiveDockablePath(DockablePath dockablePath) {
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel.getActiveDockablePath(dockablePath)) {
            dockablePath.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    @Override
    public void loadVisibilityLayout(VisibilityLayout currentVisibilityLayout, boolean isStartup, int flags) {
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.loadVisibilityLayout(currentVisibilityLayout, isStartup, flags);
    }

    @Override
    public void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        this.getDockPanel().saveVisibilityLayout(visibilityLayout);
    }

    @Override
    public void dumpAllDockables() {
        DockPanel dockPanel = this.getDockPanel();
        int titledPanelCount = dockPanel.getTitledPanelCount();
        for (int titledPanelPos = 0; titledPanelPos < titledPanelCount; ++titledPanelPos) {
            TitledPanel titledPanel = dockPanel.getTitledPanel(titledPanelPos);
            int clientCount = titledPanel.getClientCount();
            for (int clientPos = 0; clientPos < clientCount; ++clientPos) {
                Dockable dockable = titledPanel.getClient(clientPos);
                System.out.println(dockable.getClass().getName() + " -> " + dockable.getUniqueName());
            }
        }
    }

    public void dock(TitledPanel tp, DockLayoutConstraint dlc) {
        this.getDockPanel().dock(tp, dlc);
    }
}

