/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.PlatformUtils;

public final class FileAssociationsImpl {
    public static final String ENABLED_PROPERTY = "ide.shell.enableFileTypeAssociation";
    private static String exePathName;
    private static final String APPLICATION_NAME = "OracleIde";
    private static Set<String> associated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAssociated(String ext) {
        boolean result;
        block27: {
            if (PlatformUtils.isAtLeastWindowsVista()) {
                return FileAssociationsImpl.isAssociatedOnVista(ext);
            }
            String value = null;
            RegistryKey hiveKey = null;
            RegistryKey regKey = null;
            result = false;
            try {
                Registry reg;
                try {
                    reg = NativeHandler.getRegistry();
                    hiveKey = reg.getCurrentUserKey();
                }
                catch (RegistryException rEx) {
                    boolean bl = result;
                    try {
                        if (regKey != null) {
                            regKey.close();
                        }
                        if (hiveKey != null) {
                            hiveKey.close();
                        }
                    }
                    catch (RegistryException registryException) {
                        // empty catch block
                    }
                    return bl;
                }
                String exePathName = FileAssociationsImpl.getExePathName();
                String relExePath = exePathName.substring(Ide.getOracleHomeDirectory().length());
                String productName = FileAssociationsImpl.getProductName();
                String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
                try {
                    regKey = hiveKey.openKey(key, 1L);
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                if (regKey != null) {
                    try {
                        String exeName = new File(exePathName).getName();
                        value = regKey.getStringValue("Application");
                        if (!value.equalsIgnoreCase(exeName)) break block27;
                        regKey.close();
                        regKey = null;
                        hiveKey.close();
                        hiveKey = null;
                        hiveKey = reg.getClassesRootKey();
                        key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
                        regKey = hiveKey.openKey(key, 131097L);
                        value = regKey.getStringValue(null);
                        if (value.indexOf(relExePath) >= 0) {
                            result = true;
                        }
                        break block27;
                    }
                    catch (RegistryException registryException) {}
                    break block27;
                }
                try {
                    hiveKey.close();
                    hiveKey = null;
                    hiveKey = reg.getClassesRootKey();
                    regKey = hiveKey.openKey(ext, 131097L);
                    if (regKey != null && (value = regKey.getStringValue(null)).equalsIgnoreCase(productName + ext + "File")) {
                        regKey.close();
                        regKey = null;
                        key = productName + ext + "File\\Shell\\Open\\Command";
                        regKey = hiveKey.openKey(key, 131097L);
                        value = regKey.getStringValue(null);
                        if (value.indexOf(relExePath) >= 0) {
                            result = true;
                        }
                    }
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (regKey != null) {
                        regKey.close();
                    }
                    if (hiveKey != null) {
                        hiveKey.close();
                    }
                }
                catch (RegistryException registryException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isAssociatedOnVista(String ext) {
        if (associated == null) {
            associated = new HashSet<String>();
            String productName = ProductInformation.getProductInformation().getShortName();
            try {
                Process proc = Runtime.getRuntime().exec("cmd /c assoc");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    String line = reader.readLine();
                    while (line != null) {
                        int equals = line.indexOf(61);
                        if (equals != -1) {
                            String lineExt = line.substring(0, equals);
                            String keyName = productName + lineExt + "File";
                            if (line.endsWith(keyName)) {
                                associated.add(lineExt);
                            }
                        }
                        line = reader.readLine();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return associated.contains(ext);
    }

    public static void setAssociated(String ext, boolean associated) {
        if (associated) {
            FileAssociationsImpl.addAssociation(ext);
        } else {
            FileAssociationsImpl.removeAssociation(ext);
        }
    }

    public static void setAssociations(Map<String, Boolean> associations) {
        if (PlatformUtils.isAtLeastWindowsVista()) {
            FileAssociationsImpl.setAssociationsOnVista(associations);
        } else {
            for (Map.Entry<String, Boolean> entry : associations.entrySet()) {
                String ext = entry.getKey();
                boolean toAssociate = entry.getValue();
                FileAssociationsImpl.setAssociated(ext, toAssociate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setAssociationsOnVista(Map<String, Boolean> associations) {
        BufferedWriter out = null;
        try {
            String productName = ProductInformation.getProductInformation().getShortName();
            File batch = File.createTempFile("batch", ".bat");
            batch.deleteOnExit();
            out = new BufferedWriter(new FileWriter(batch));
            Set<Map.Entry<String, Boolean>> entries = associations.entrySet();
            for (Map.Entry<String, Boolean> entry : entries) {
                String ext = entry.getKey();
                String productKey = productName + ext + "File";
                boolean toAssociate = entry.getValue();
                if (toAssociate) {
                    out.write("assoc " + ext + "=" + productKey + "\n");
                    String exePathName = FileAssociationsImpl.getExePathName();
                    out.write("ftype " + productKey + "=\"" + exePathName + "\" \"%%1\" %%*\n");
                    continue;
                }
                out.write("assoc " + ext + "=\n");
                out.write("ftype " + productKey + "=\n");
            }
            out.close();
            if (entries != null && entries.size() > 0) {
                NativeHandler.runAsAdmin("cmd.exe", "/c " + batch.getCanonicalPath());
            }
            Class<FileAssociationsImpl> clazz = FileAssociationsImpl.class;
            synchronized (FileAssociationsImpl.class) {
                if (associated != null) {
                    for (Map.Entry<String, Boolean> entry : associations.entrySet()) {
                        if (entry.getValue().booleanValue()) {
                            associated.add(entry.getKey());
                            continue;
                        }
                        associated.remove(entry.getKey());
                    }
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IdeUtil.close(out);
            }
        }
        {
            IdeUtil.close(out);
            return;
        }
    }

    public static String getExePathName() {
        return exePathName;
    }

    private static String getProductName() {
        ProductInformation productInfo = ProductInformation.getProductInformation();
        return productInfo.getShortName();
    }

    public static boolean shouldMigrate(String ext) {
        Registry reg;
        if (PlatformUtils.isAtLeastWindowsVista()) {
            return FileAssociationsImpl.isAssociatedOnVista(ext);
        }
        String value = null;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        boolean result = false;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getCurrentUserKey();
        }
        catch (RegistryException rEx) {
            return result;
        }
        String exePathName = FileAssociationsImpl.getExePathName();
        String exeName = new File(exePathName).getName();
        String productName = FileAssociationsImpl.getProductName();
        String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
        try {
            regKey = hiveKey.openKey(key, 131097L);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (regKey != null) {
            try {
                value = regKey.getStringValue("Application");
                if (value.equalsIgnoreCase(exeName)) {
                    result = true;
                }
            }
            catch (RegistryException registryException) {}
        } else {
            try {
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getClassesRootKey();
                regKey = hiveKey.openKey(ext, 131097L);
                value = regKey.getStringValue(null);
                if (value.equalsIgnoreCase(productName + ext + "File")) {
                    result = true;
                }
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return result;
    }

    public static void setProxyPath() {
        if (PlatformUtils.isAtLeastWindowsVista()) {
            return;
        }
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            Registry reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
            String exePathName = FileAssociationsImpl.getExePathName();
            String exeName = new File(exePathName).getName();
            String productName = FileAssociationsImpl.getProductName();
            String key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
            String value = "\"" + exePathName + "\"";
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec";
            value = "Open(\"%1\")";
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec\\Application";
            value = APPLICATION_NAME;
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            regKey = null;
            key = "Applications\\" + exeName + "\\Shell\\Open";
            regKey = hiveKey.openKey(key, 131078L);
            regKey.setStringValue("FriendlyAppName", productName);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public static void setExtensionPath(String ext) {
        if (PlatformUtils.isAtLeastWindowsVista()) {
            FileAssociationsImpl.setAssociationsOnVista(Collections.singletonMap(ext, true));
            return;
        }
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            Registry reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String exePathName = FileAssociationsImpl.getExePathName();
        String productName = FileAssociationsImpl.getProductName();
        try {
            regKey = hiveKey.openKey(productName + ext + "File", 2L);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (regKey != null) {
            try {
                String key = productName + ext + "File\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public static void addAssociation(String ext) {
        Registry reg;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String exePathName = FileAssociationsImpl.getExePathName();
        String productName = FileAssociationsImpl.getProductName();
        try {
            regKey = hiveKey.openKey(ext, 2L);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (regKey == null) {
            try {
                String key = productName + ext + "File\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                regKey = null;
                regKey = hiveKey.createKey(ext, false, 131078L);
                regKey.setStringValue(null, productName + ext + "File");
            }
            catch (RegistryException rEx) {
                rEx.printStackTrace();
            }
        } else {
            try {
                String exeName = new File(exePathName).getName();
                String key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                regKey = null;
                key = "Applications\\" + exeName + "\\Shell\\Open";
                regKey = hiveKey.openKey(key, 131078L);
                regKey.setStringValue("FriendlyAppName", productName);
                regKey.close();
                regKey = null;
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getCurrentUserKey();
                key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setStringValue("Application", exeName);
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public static void removeAssociation(String ext) {
        Registry reg;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getCurrentUserKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
        try {
            regKey = hiveKey.openKey(key, 2L);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (regKey != null) {
            try {
                regKey.setStringValue("Application", "");
            }
            catch (RegistryException registryException) {}
        } else {
            try {
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getClassesRootKey();
                try {
                    regKey = hiveKey.openKey(ext, 2L);
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                hiveKey.deleteKey(ext);
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    static {
        String fnameW;
        int fnameLen;
        exePathName = System.getProperty(ENABLED_PROPERTY);
        if (exePathName != null && (fnameLen = exePathName.length()) >= 5 && exePathName.charAt(fnameLen - 5) != 'w' && exePathName.charAt(fnameLen - 5) != 'W' && new File(fnameW = exePathName.substring(0, fnameLen - 4) + "W.exe").exists()) {
            exePathName = fnameW;
        }
    }
}

