/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLNodeComparator;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.controls.WashedIcon;

final class URLNode
implements TreeNode,
Comparable {
    private final URLChooser _urlChooser;
    static final int DIRS_ALWAYS_EXCLUDED = 0;
    static final int DIRS_FILTERED = 1;
    static final int DIRS_ALWAYS_INCLUDED = 2;
    static final int DIRS_ONLY = 3;
    private final URL _url;
    private final boolean _isLeaf;
    private final List<URLNode> _children = new ArrayList<URLNode>();
    private TreeNode _parent;
    private Object _userObject;
    private String _name;
    private Icon _icon;
    private Icon _washedIcon;
    private boolean _expanded;
    private boolean _extra;
    private boolean calculated;
    private final transient Comparator<URLNode> _urlNodeComparator;
    private URLNode[] ALREADY_UPDATED = new URLNode[0];

    URLNode(URLChooser urlChooser) {
        this(urlChooser, (URL)null);
    }

    URLNode(URLChooser urlChooser, URLFileSystem.FileInfo info) {
        this(urlChooser, info.getURL());
        this.setUserObject(info);
    }

    URLNode(URLChooser urlChooser, URL url) {
        this._urlChooser = urlChooser;
        this._url = url;
        this._urlNodeComparator = new URLNodeComparator(true, this._urlChooser.isCaseSensitive());
        this._isLeaf = url != null && !URLFileSystem.isRoot((URL)url) && !URLFileSystem.isDirectoryPath((URL)url);
    }

    public Enumeration<URLNode> children() {
        return new Vector<URLNode>(this._children).elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this._children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this._children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this._children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    @Override
    public boolean isLeaf() {
        return this._isLeaf;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object userObject) {
        this._userObject = userObject;
    }

    public void add(URLNode node) {
        URLNode child;
        int result;
        int i;
        int n = this.getChildCount();
        for (i = 0; i < n && (result = this._urlNodeComparator.compare(node, child = (URLNode)this.getChildAt(i))) >= 0; ++i) {
        }
        this._children.add(i, node);
        node._parent = this;
    }

    public void removeAllChildren() {
        this.setExpanded(false);
        this._children.clear();
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public int compareTo(Object o) {
        return this._urlNodeComparator.compare(this, (URLNode)o);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof URLNode && URLFileSystem.equals((URL)this._url, (URL)((URLNode)o)._url);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        if (this._name == null) {
            this._name = this._url != null ? (URLFileSystem.isRoot((URL)this._url) ? URLFileSystem.getSystemDisplayName((URL)this._url) : URLFileSystem.getFileName((URL)this._url)) : "";
        }
        return this._name;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = this._url != null ? URLFileSystem.getDefaultIcon((URL)this._url) : IdeIcons.getIcon((int)23);
        }
        return this._icon;
    }

    public Icon getWashedIcon() {
        Icon icon;
        if (this._washedIcon == null && (icon = this.getIcon()) != null) {
            this._washedIcon = new WashedIcon(icon);
        }
        return this._washedIcon;
    }

    public boolean exists() {
        if (this.getFileInfo() != null || this.isExtra()) {
            return true;
        }
        return this._url != null ? URLFileSystem.exists((URL)this._url) : false;
    }

    public boolean isRoot() {
        return this._url != null && URLFileSystem.isRoot((URL)this._url);
    }

    public boolean isHidden() {
        URLFileSystem.FileInfo info = this.getFileInfo();
        return info != null ? info.isHidden() : URLFileSystem.isHidden((URL)this._url) && !this.isRoot();
    }

    public long lastModified() {
        URLFileSystem.FileInfo info = this.getFileInfo();
        return info != null ? info.lastModified() : URLFileSystem.lastModified((URL)this._url);
    }

    public long length() {
        URLFileSystem.FileInfo info = this.getFileInfo();
        return info != null ? info.length() : URLFileSystem.getLength((URL)this._url);
    }

    URL getURL() {
        return this._url;
    }

    boolean isExpanded() {
        return this._expanded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExpanded(boolean expanded) {
        if (!expanded) {
            URLNode uRLNode = this;
            synchronized (uRLNode) {
                this.calculated = false;
            }
        }
        this._expanded = expanded;
    }

    boolean isExtra() {
        return this._extra;
    }

    void setExtra(boolean extra) {
        this._extra = extra;
    }

    void rebuildChildren(boolean mustBeSynchronous, boolean firePostUpdateTreeSelection) {
        this.removeAllChildren();
        this.buildChildren(mustBeSynchronous, firePostUpdateTreeSelection);
    }

    void buildChildren(boolean mustBeSynchronous, boolean firePostUpdateTreeSelection) {
        this.buildChildren(mustBeSynchronous, firePostUpdateTreeSelection, false);
    }

    void buildChildren(boolean mustBeSynchronous, final boolean firePostUpdateTreeSelection, final boolean nowait) {
        if (this._url == null) {
            return;
        }
        if (mustBeSynchronous) {
            URLNode[] children = this.getChildURLNodes(true);
            this.processChildURLNodes(children, firePostUpdateTreeSelection, nowait);
        } else {
            this._urlChooser.setKeyboardEnabled(false);
            final ProgressBar progress = new ProgressBar((Component)((Object)this._urlChooser), IdeArb.getString(527), null, true);
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    URLNode uRLNode = URLNode.this;
                    synchronized (uRLNode) {
                        final URLNode[] children = URLNode.this.getChildURLNodes(false);
                        progress.setDoneStatus();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (progress.hasUserCancelled()) {
                                    if (children != null) {
                                        URLNode.this.updateChildren(children);
                                    }
                                } else {
                                    URLNode.this.processChildURLNodes(children, firePostUpdateTreeSelection, nowait);
                                }
                            }
                        });
                    }
                }
            };
            progress.setRunnable(task);
            String msg = IdeArb.format(528, this);
            progress.start(msg, null, 400);
        }
    }

    void insertDir(URL dirURL) {
        if (!this._expanded) {
            this.buildChildren(true, false);
        }
        URLNode dirNode = new URLNode(this._urlChooser, dirURL);
        this.add(dirNode);
        if (!this._urlChooser.isForceUseList() && this._urlChooser.getSelectionScope() == 1) {
            this._urlChooser.nodeChanged(this);
        } else {
            this._urlChooser.runNow(19);
        }
        this._urlChooser.setSelectedNode(dirNode);
        this._urlChooser.runNow(10);
    }

    Vector<URLNode> getFiles(URLFilter filter, int dirMode) {
        if (filter == null) {
            filter = URLChooser.ALL_FILES_FILTER;
        }
        Vector<URLNode> files = new Vector<URLNode>();
        block4: for (URLNode child : this._children) {
            URL url = child.getURL();
            if (!child.isLeaf()) {
                switch (dirMode) {
                    case 2: {
                        files.add(child);
                        continue block4;
                    }
                    case 0: {
                        continue block4;
                    }
                }
            } else if (dirMode == 3) continue;
            if (!filter.accept(url)) continue;
            files.add(child);
        }
        return files;
    }

    private synchronized URLNode[] getChildURLNodes(boolean forceCalculation) {
        URL[] extraURLs;
        if (!forceCalculation && this.calculated) {
            return this.ALREADY_UPDATED;
        }
        Object[] children = FileNativeHelper.getInstance().isLoaded() ? URLFileSystem.ls((URL)this._url) : URLFileSystem.list((URL)this._url);
        int n = children != null ? children.length : 2;
        TreeSet<URLNode> urlNodes = new TreeSet<URLNode>(this._urlNodeComparator);
        if (children != null) {
            for (int i = 0; i < n; ++i) {
                URL childURL;
                String lowerSpec;
                String parentProtocol;
                URLNode child = children instanceof URLFileSystem.FileInfo[] ? new URLNode(this._urlChooser, children[i]) : new URLNode(this._urlChooser, (URL)children[i]);
                if (this._urlChooser.getURLFolderFilter() != null && !child.isLeaf() & !this._urlChooser.getURLFolderFilter().accept(child.getURL())) continue;
                if (this._urlChooser.getSelectionScope() != 1 || !child.isLeaf()) {
                    urlNodes.add(child);
                }
                if (!this._urlChooser.isShowJarsAsDirs() || !child.isLeaf() || (parentProtocol = this._url.getProtocol()).equals("jar") || !(lowerSpec = URLFileSystem.getFileName((URL)(childURL = child.getURL())).toLowerCase()).endsWith(".jar") && !lowerSpec.endsWith(".zip") && !lowerSpec.endsWith(".war") && !lowerSpec.endsWith(".ear")) continue;
                URLNode jarNode = new URLNode(this._urlChooser, URLFactory.newJarURL((URL)childURL, (String)""));
                urlNodes.add(jarNode);
            }
        }
        if ((extraURLs = this._urlChooser.getExtraURLs()) != null) {
            for (URL url : extraURLs) {
                if (!URLFileSystem.isBaseURLFor((URL)this._url, (URL)url) || !URLFileSystem.equals((URL)this._url, (URL)URLFileSystem.getParent((URL)url))) continue;
                URLNode child = new URLNode(this._urlChooser, url);
                child.setExtra(true);
                urlNodes.add(child);
            }
        }
        if (!urlNodes.isEmpty() || children != null) {
            this.calculated = true;
            return urlNodes.toArray(new URLNode[urlNodes.size()]);
        }
        return null;
    }

    private void updateChildren(URLNode[] children) {
        if (children == this.ALREADY_UPDATED) {
            return;
        }
        this._children.clear();
        for (int i = 0; i < children.length; ++i) {
            URLNode child = children[i];
            child._parent = this;
            this._children.add(child);
        }
        this.setExpanded(true);
    }

    private void processChildURLNodes(URLNode[] children, boolean firePostUpdateTreeSelection, boolean nowait) {
        if (children != null) {
            this.updateChildren(children);
            if (!this._urlChooser.isForceUseList() && this._urlChooser.getSelectionScope() == 1) {
                this._urlChooser.nodeChanged(this);
            }
            if (firePostUpdateTreeSelection) {
                this._urlChooser.runNow(12);
            }
        } else {
            this._children.clear();
            this.setExpanded(false);
            if (!this._urlChooser.isForceUseList() && this._urlChooser.getSelectionScope() == 1) {
                Object[] nodePath = this.getPath();
                TreePath tp = new TreePath(nodePath);
                this._urlChooser.collapsePath(tp);
                this._urlChooser.nodeChanged(this);
            }
        }
        this._urlChooser.setKeyboardEnabled(true);
        if (children == null && !nowait) {
            try {
                URLFileSystem.findHelper((URL)this._url).verifyList(this._url);
            }
            catch (IOException e) {
                String error = e.getMessage();
                if (error != null) {
                    this._urlChooser.showSpecificError(this._url, error);
                } else {
                    this._urlChooser.showNotFoundError(this._url);
                }
                return;
            }
            if (!URLFileSystem.canRead((URL)this._url)) {
                this.setExpanded(true);
                return;
            }
            this._urlChooser.showNotFoundError(this._url);
        }
    }

    private URLFileSystem.FileInfo getFileInfo() {
        Object userObject = this.getUserObject();
        return userObject instanceof URLFileSystem.FileInfo ? (URLFileSystem.FileInfo)userObject : null;
    }
}

