/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import net.jcip.annotations.Immutable;
import oracle.ide.natives.NativeHandler;
import oracle.javatools.util.PlatformUtils;

@Immutable
public final class WindowsInternetOptions {
    private final String _proxyHost;
    private final String _proxyPort;
    private final String _nonProxyHosts;

    public WindowsInternetOptions() {
        if (!PlatformUtils.isWindows()) {
            throw new UnsupportedOperationException("May only be used on Windows.");
        }
        if (!NativeHandler.isLoaded()) {
            throw new UnsupportedOperationException("Native support is not available.");
        }
        String[] results = new String[3];
        try {
            this.readProxyOptions(results);
            this._proxyHost = results[0];
            this._proxyPort = results[1];
            this._nonProxyHosts = results[2];
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native support is not available, because you have an old version of idenative.dll");
        }
    }

    private native void readProxyOptions(String[] var1);

    public String proxyHost() {
        return this._proxyHost;
    }

    public String proxyPort() {
        return this._proxyPort;
    }

    public String nonProxyHosts() {
        return this._nonProxyHosts;
    }
}

