/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.panels.OnDemandTraversable;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;

class ContentSetProviderNavigable
extends Navigable {
    private final ContentSetProviderReference contentSetProvider;
    private static final Logger LOGGER = Logger.getLogger(ContentSetProviderNavigable.class.getName());
    private static final ProjectSettingsTraversablePanel ERROR_PANEL = new ErrorPanel();

    ContentSetProviderNavigable(ContentSetProviderReference contentSetProvider) {
        this.contentSetProvider = contentSetProvider;
    }

    public String getShortLabel() {
        return this.contentSetProvider.navigableLabel();
    }

    public Traversable newTraversable(ApplyNotifier applyNotifier) {
        Traversable traversable;
        String extensionId;
        ExtensionRegistry registry;
        if (!this.contentSetProvider.isAlreadyInitialized() && !(registry = ExtensionRegistry.getExtensionRegistry()).isFullyLoaded(extensionId = this.contentSetProvider.extensionId())) {
            return new OnDemandTraversable(this.contentSetProvider, applyNotifier);
        }
        ContentSetProvider provider = this.contentSetProvider.contentSetProvider();
        Navigable navigable = provider.getNavigable();
        try {
            traversable = navigable.newTraversable(applyNotifier);
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, provider.getKey() + " ContentSetProvider returned a null Navigable.", e);
            return ERROR_PANEL;
        }
        return traversable;
    }

    public boolean includeInDefault() {
        return this.contentSetProvider.isShowInDefaultProject();
    }

    private static class ErrorPanel
    extends ProjectSettingsTraversablePanel {
        private ErrorPanel() {
        }

        @Override
        public void onProjectPanelEntry(TraversableContext traversableContext) {
        }

        @Override
        public String getDataKey() {
            return null;
        }

        @Override
        public String[] getPropertyKeys() {
            return new String[0];
        }
    }
}

