/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.log.LogManager;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.HSAdapterDelegateMediator;
import oracle.ide.model.Project;
import oracle.ide.resource.IdeArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.ModelUtil;

public class DependencyConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = DependencyConfiguration.class.getName();
    private static final String MODULE_PATH_DEPENDENCIES_LIST = "modulePathDependencies";
    private static final Logger _extensionLogger = Logger.getLogger(DATA_KEY);
    private final Project _project;
    public static final String DEPENDENCY_LIST = "dependencyList";

    private DependencyConfiguration(HashStructure hash, Project project) {
        super(hash);
        this._project = project;
    }

    public static DependencyConfiguration getInstance(Project project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static DependencyConfiguration getInstance(PropertyStorage project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), null);
    }

    private ListStructure getDependenciesListStructure() {
        return this._hash.getListStructure(DEPENDENCY_LIST);
    }

    public void attachDependencyChangeListener(StructureChangeListener listener) {
        this._hash.getOrCreateListStructure(DEPENDENCY_LIST).addStructureChangeListener(listener);
        this._hash.getOrCreateListStructure(MODULE_PATH_DEPENDENCIES_LIST).addStructureChangeListener(listener);
    }

    public void detachDependencyChangeListener(StructureChangeListener listener) {
        if (this.getDependenciesListStructure() != null) {
            this.getDependenciesListStructure().removeStructureChangeListener(listener);
        }
        if (this.getModulePathDependencyListStructure() != null) {
            this.getModulePathDependencyListStructure().removeStructureChangeListener(listener);
        }
    }

    public List getDependencyList() {
        return this.getDependencyList(this.getDependenciesListStructure());
    }

    public List<Dependable> getClassPathDependencyList() {
        List dependencies = this.getDependencyList();
        List<Dependable> modulePathDependencies = this.getModulePathDependencyList();
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            if (!modulePathDependencies.contains(iter.next())) continue;
            iter.remove();
        }
        return dependencies;
    }

    public List<Dependable> getModulePathDependencyList() {
        return this.getDependencyList(this.getModulePathDependencyListStructure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependable> getDependencyList(ListStructure depList) {
        ArrayList<Dependable> dependencies = new ArrayList<Dependable>();
        if (depList != null) {
            Object object = depList.iteratorLock();
            synchronized (object) {
                for (HashStructure hash : depList) {
                    try {
                        Dependable dependable = DependableFactory.getInstance().toDependable(hash, this._project);
                        if (dependable != null && dependable.getSource() != null && dependable.getSource() != this._project) {
                            dependencies.add(dependable);
                            continue;
                        }
                        String msg = IdeArb.format(498, this._project != null ? this._project.getShortLabel() : null);
                        LogManager lgm = LogManager.getLogManager();
                        if (lgm != null) {
                            lgm.getMsgPage().log(msg);
                            continue;
                        }
                        Logger l = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                        l.log(Level.WARNING, msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return dependencies;
    }

    public void setDependencyList(List dependencies) {
        this.setDependencyList(dependencies, this.getDependencyListStructure());
    }

    public void setModulePathDependencyList(List<Dependable> dependencies) {
        this.setDependencyList(dependencies, this.getModulePathDependencyListStructure());
    }

    private void setDependencyList(List<Dependable> dependencies, ListStructure dependencyListStructure) {
        ArrayList<HashStructure> depList = new ArrayList<HashStructure>();
        if (dependencies != null) {
            for (Dependable dep : dependencies) {
                try {
                    HashStructure depHash = DependableFactory.getInstance().toHashStructure(dep, this._project);
                    if (depHash == null) continue;
                    depList.add(depHash);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        dependencyListStructure.mirror(depList);
    }

    private ListStructure getDependencyListStructure() {
        return this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    private ListStructure getModulePathDependencyListStructure() {
        return this._hash.getOrCreateListStructure(MODULE_PATH_DEPENDENCIES_LIST);
    }

    public void addDependency(Dependable dependable) throws IllegalStateException {
        this.addDependency(dependable, false);
    }

    public void addDependency(Dependable dependable, boolean isModulePathDependency) {
        if (dependable != null) {
            ListStructure list = this.getDependencyListStructure();
            ListStructure modulePathList = isModulePathDependency ? this.getModulePathDependencyListStructure() : null;
            try {
                HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                if (!list.contains((Object)hash)) {
                    this.checkExistingMutuallyExclusiveDependency(dependable);
                    list.add((Object)hash);
                    if (isModulePathDependency) {
                        modulePathList.add((Object)hash);
                    }
                    if (this._project != null && HSAdapterDelegateMediator.getMediator().needsDelegation(this._project, this._project.getProperties())) {
                        HashStructure hs = HashStructure.newInstance();
                        this._hash.remove("_equals_breaker_");
                        this._hash.copyTo(hs);
                        hs.putHashStructure("_equals_breaker_", HashStructure.newInstance());
                        this._project.getProperties()._putObject(DATA_KEY, (Object)hs);
                    }
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeDependency(Dependable dependable) {
        this.removeDependency(dependable, this.getDependencyListStructure());
        this.removeDependency(dependable, this.getModulePathDependencyListStructure());
    }

    private void removeDependency(Dependable dependable, ListStructure dependencyList) {
        if (dependable != null && dependencyList != null) {
            try {
                HashStructure hash = DependableFactory.getInstance().toHashStructure(dependable, this._project);
                Iterator iter = dependencyList.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next == null || !next.equals(hash)) continue;
                    iter.remove();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final Logger getLogger() {
        return _extensionLogger;
    }

    public Iterator getDependencies() {
        return this.getDependencyList().iterator();
    }

    public List getAllDependenciesList() {
        return this.getAllDependenciesList(this.getDependencies());
    }

    public List<Dependable> getAllClassPathDependenciesList() {
        return this.getAllDependenciesList(this.getClassPathDependencyList().iterator());
    }

    public List<Dependable> getAllModulePathDependenciesList() {
        return this.getAllDependenciesList(this.getModulePathDependencyList().iterator());
    }

    private List<Dependable> getAllDependenciesList(Iterator<Dependable> dependencies) {
        ArrayList<Dependable> allDependables = new ArrayList<Dependable>();
        ArrayList<Element> seenSources = new ArrayList<Element>();
        if (this._project != null) {
            seenSources.add(this._project);
        } else {
            new Exception("*** Warning: Project not specified to DependencyConfiguration.  Cycles will not be detected properly.").printStackTrace();
        }
        this.collectDependencies(dependencies, allDependables, seenSources);
        return allDependables;
    }

    private void collectDependencies(Iterator<Dependable> deps, List<Dependable> output, List<Element> seenSources) {
        while (deps.hasNext()) {
            Dependable dependable = deps.next();
            if (DependencyConfiguration.wasSourceSeen(dependable.getSource(), seenSources)) continue;
            seenSources.add(dependable.getSource());
            this.collectDependencies(dependable.getDependencies(), output, seenSources);
            output.add(dependable);
        }
    }

    private static boolean wasSourceSeen(Element element, List<Element> seenSources) {
        for (int i = 0; i < seenSources.size(); ++i) {
            Element source = seenSources.get(i);
            if (source != element) continue;
            return true;
        }
        return false;
    }

    private void checkExistingMutuallyExclusiveDependency(Dependable dependable) throws IllegalStateException {
        URL sourceUrl;
        boolean isOutputPathDependency = false;
        if (dependable.getSource() instanceof Project) {
            sourceUrl = ((Project)dependable.getSource()).getURL();
            isOutputPathDependency = true;
        } else if (dependable.getSourceOwner() instanceof Project) {
            sourceUrl = ((Project)dependable.getSourceOwner()).getURL();
        } else {
            return;
        }
        Iterator deps = this.getDependencies();
        while (deps.hasNext()) {
            URL depURL = null;
            Dependable next = (Dependable)deps.next();
            if (isOutputPathDependency) {
                if (next.getSourceOwner() instanceof Project) {
                    depURL = ((Project)next.getSourceOwner()).getURL();
                }
            } else if (next.getSource() instanceof Project) {
                depURL = ((Project)next.getSource()).getURL();
            }
            if (!ModelUtil.areEqual((Object)sourceUrl, depURL)) continue;
            throw new IllegalStateException(IdeArb.format(514, dependable.toString(), next.toString()));
        }
    }
}

