/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.config.DTCache;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuCustomizationsHelper;
import oracle.ide.keyboard.ActionElement;
import oracle.ide.keyboard.ActionElementRenderer;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeField;
import oracle.ide.keyboard.KeyStrokeImporterExporter;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokeTableModel;
import oracle.ide.keyboard.KeyStrokeTableRowFilter;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyStrokesConstraintFactory;
import oracle.ide.keyboard.PresetsPanel;
import oracle.ide.keyboard.ShortcutElement;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithHint;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.StringUtil;

public final class KeyStrokePanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener,
KeyStrokesConstraint,
ListSelectionListener,
SearchListener {
    private KeyStrokeOptions _kso;
    private GenericTable _jtActions;
    private KeyStrokeTableModel _tableModel;
    private String _lastSearch;
    private KeyStrokeField _jksNewShortcut;
    private ExtendedTextField _jlblCurrentAssign;
    private JButton _jbAdd;
    private JButton _jbRemove;
    private JButton _jbPresets;
    private JButton _jbCopy;
    private JButton _jbImport;
    private JButton _jbExport;
    private JCheckBox _jchkHideUnmapped;
    private static final String HIDE_UNMAPPED_COMMANDS = "hide-unmapped-commands";
    private SearchField searchField;
    private boolean _searchFieldFocused = false;

    public KeyStrokePanel() {
        this.setHelpID("f1_idedidesetshortcuts_html");
        this._lastSearch = "";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public void onEntry(TraversableContext tc) {
        if (this._kso == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            IdeSettings ideSettings = (IdeSettings)tc.find("ide-options");
            this._kso = ideSettings.getKeyStrokeOptions();
            ActionEvent event = new ActionEvent(this, 1001, "showing");
            this._kso.getKeyboardPanelEventDispatcher().actionPerformed(event);
            this.fillActions();
            DTCache cache = Ide.getDTCache();
            boolean hide = cache.getBoolean(HIDE_UNMAPPED_COMMANDS, false);
            if (hide) {
                this._jchkHideUnmapped.setSelected(hide);
            }
        }
    }

    public void onExit(TraversableContext tc) {
        DTCache cache = Ide.getDTCache();
        cache.putBoolean(HIDE_UNMAPPED_COMMANDS, this._jchkHideUnmapped.isSelected());
    }

    @Override
    public boolean isAcceptableKey(KeyStrokes kss, KeyStroke ksNew) {
        KeyStrokesConstraint kscon = KeyStrokesConstraintFactory.getConstraint(0);
        return kscon == null ? true : kscon.isAcceptableKey(kss, ksNew);
    }

    private void jbInit() throws Exception {
        this._tableModel = new KeyStrokeTableModel();
        this._jtActions = new GenericTable((TableModel)this._tableModel);
        this._jtActions.setRowHeight(20);
        this._jtActions.setShowGrid(true);
        this._jtActions.setDragEnabled(false);
        this._jtActions.setShowHorizontalLines(true);
        this._jtActions.setColumnSelectionAllowed(false);
        this._jtActions.setSelectionMode(2);
        this._jtActions.getColumnModel().getColumn(1).setCellRenderer(new ActionElementRenderer());
        TableColumnModel colModel = this._jtActions.getColumnModel();
        if (Version.DEBUG_BUILD != 1) {
            this._jtActions.setColumnSelectorAvailable(false);
            TableColumn idColumn = colModel.getColumn(3);
            TableColumn nameColumn = colModel.getColumn(4);
            colModel.removeColumn(idColumn);
            colModel.removeColumn(nameColumn);
        } else {
            this._jtActions.setColumnSelectorAvailable(true);
            this._jtActions.setHiddenColumns(new int[]{3});
            this._jtActions.setHiddenColumns(new int[]{4});
        }
        JScrollPane jspActions = new JScrollPane((Component)this._jtActions);
        jspActions.setOpaque(false);
        this._jlblCurrentAssign = new ExtendedTextField();
        this._jksNewShortcut = new KeyStrokeField(this._jlblCurrentAssign.getForeground());
        this._jbCopy = new JButton();
        this._jbRemove = new JButton();
        this._jbAdd = new JButton();
        this._jbPresets = new JButton();
        this._jbImport = new JButton();
        this._jbExport = new JButton();
        this._jchkHideUnmapped = new JCheckBox();
        JLabel lblNewShortcut = new JLabel();
        JLabel lblCurrent = new JLabel();
        ComponentWithHint conflictWithHint = new ComponentWithHint((Component)this._jlblCurrentAssign, KeyStrokeArb.getString(7));
        this._jbCopy.setIcon(OracleIcons.getIcon((String)"copy.png"));
        this._jbCopy.setToolTipText(KeyStrokeArb.getString(10));
        this._jbRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._jbRemove.setToolTipText(KeyStrokeArb.getString(11));
        this._jbImport.setIcon(OracleIcons.getIcon((String)"import.png"));
        this._jbImport.setToolTipText(KeyStrokeArb.getString(13));
        this._jbExport.setIcon(OracleIcons.getIcon((String)"export.png"));
        this._jbExport.setToolTipText(KeyStrokeArb.getString(14));
        this._jbPresets.setIcon(OracleIcons.getIcon((String)"open.png"));
        this._jbPresets.setToolTipText(KeyStrokeArb.getString(15));
        ResourceUtils.resButton((AbstractButton)this._jbAdd, (String)KeyStrokeArb.getString(12));
        ResourceUtils.resLabel((JLabel)lblNewShortcut, (Component)this._jksNewShortcut, (String)KeyStrokeArb.getString(5));
        ResourceUtils.resLabel((JLabel)lblCurrent, (Component)this._jlblCurrentAssign, (String)KeyStrokeArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this._jchkHideUnmapped, (String)KeyStrokeArb.getString(9));
        this._jbAdd.setEnabled(false);
        this._jbCopy.setEnabled(false);
        this._jbRemove.setEnabled(false);
        this._jksNewShortcut.setEnabled(false);
        this._jksNewShortcut.setMinimumSize(new Dimension(4, 21));
        this._jlblCurrentAssign.setFocusable(false);
        this._jbAdd.addActionListener(this);
        this._jbRemove.addActionListener(this);
        this._jbPresets.addActionListener(this);
        this._jbCopy.addActionListener(this);
        this._jbImport.addActionListener(this);
        this._jbExport.addActionListener(this);
        this._jchkHideUnmapped.addItemListener(this);
        this._jtActions.addKeyListener((KeyListener)new DeleteKeyListener());
        this._jtActions.getSelectionModel().addListSelectionListener(this);
        this._jksNewShortcut.getModel().addActionListener(this);
        this._jksNewShortcut.setConstraint(this);
        this.searchField = new SearchField();
        this.searchField.setPrompt(KeyStrokeArb.getString(4));
        this.searchField.setKeyEventTargetComponent((Component)this._jtActions);
        this.searchField.setStyle(SearchField.Style.FILTER);
        this.searchField.addSearchListener((SearchListener)this);
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyStrokePanel.this._searchFieldFocused = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyStrokePanel.this._searchFieldFocused = false;
            }
        });
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jbCopy);
        controlBar.add((Component)this._jbRemove);
        controlBar.add((Component)this._jbImport);
        controlBar.add((Component)this._jbExport);
        controlBar.add((Component)this._jbPresets);
        JLabel tableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)tableLabel, (Component)jspActions, (String)KeyStrokeArb.getString(3));
        ComponentWithTitlebar titledTable = new ComponentWithTitlebar((JComponent)jspActions, tableLabel, controlBar);
        int Y = -1;
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridBagLayout());
        searchPanel.add((Component)this.searchField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 23), 0, 0));
        searchPanel.add((Component)this._jchkHideUnmapped, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(searchPanel, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)titledTable, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 17, 1, new Insets(8, 0, 8, 0), 0, 0));
        this.add(lblNewShortcut, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 6, 6), 0, 0));
        this.add(this._jksNewShortcut, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 0, 0));
        this.add(this._jbAdd, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 6, 0), 0, 0));
        this.add(lblCurrent, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)conflictWithHint, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    static Set<ActionElement> getAllActions() {
        Stream globals = KeyStrokePanel.allContextsStream().map(ksc -> KeyStrokePanel.getActionElements(ksc, true)).flatMap(set -> set.stream());
        Stream locals = KeyStrokePanel.allContextsStream().map(ksc -> KeyStrokePanel.getActionElements(ksc, false)).flatMap(set -> set.stream());
        Set<ActionElement> actions = Stream.concat(globals, locals).collect(Collectors.toSet());
        return actions;
    }

    private void fillActions() {
        KeyStrokePanel.fillActions(this._jtActions, this._tableModel, this._kso, true);
        TableRowSorter<KeyStrokeTableModel> rowSorter = new TableRowSorter<KeyStrokeTableModel>(this._tableModel);
        rowSorter.setComparator(2, ShortcutElement.COMPARATOR);
        rowSorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object val = model.getValueAt(row, column);
                return val == null ? "" : val.toString().toLowerCase();
            }
        });
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        keys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        keys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        rowSorter.setSortKeys(keys);
        rowSorter.setSortsOnUpdates(true);
        rowSorter.addRowSorterListener(event -> {
            int row = this._jtActions.getSelectionModel().getMinSelectionIndex();
            Rectangle cellRect = this._jtActions.getCellRect(row, 0, true);
            this._jtActions.scrollRectToVisible(new Rectangle(cellRect));
        });
        this._jtActions.setRowSorter(rowSorter);
        this._jtActions.autoSizeColumnsToFit();
        if (this._jchkHideUnmapped.isSelected()) {
            this.filterTable(new KeyStrokeTableRowFilter(true, null));
        }
        if (this._jtActions.getRowCount() > 0) {
            this._jtActions.getSelectionModel().setSelectionInterval(0, 0);
            this._jtActions.scrollToSelection();
        }
    }

    static void fillActions(GenericTable table, KeyStrokeTableModel tableModel, KeyStrokeOptions kso, boolean includeDuplicates) {
        Set<ActionElement> actions = KeyStrokePanel.getAllActions();
        table.clearSelection();
        tableModel.clear();
        block0: for (ActionElement nextAction : actions) {
            Set<ShortcutElement> shortcuts;
            String category = KeyStrokePanel.getCategory(nextAction._act);
            if (ModelUtil.hasLength((String)category)) {
                category = StringUtil.stripMnemonic((String)category);
            }
            if ((shortcuts = KeyStrokePanel.getShortcuts(nextAction, kso)).size() == 0) {
                tableModel.addRow(category, nextAction, null);
                continue;
            }
            for (ShortcutElement shortcut : shortcuts) {
                tableModel.addRow(category, nextAction, shortcut);
                if (includeDuplicates) continue;
                continue block0;
            }
        }
    }

    private static Set<ActionElement> getActionElements(KeyStrokeContext ksc, boolean bGlobal) {
        return KeyStrokePanel.getAllActions(ksc, bGlobal).stream().filter(act -> !MenuCustomizationsHelper.isHidden(Ide.findCmdName(act.getCommandId()))).map(action -> new ActionElement(ksc, (IdeAction)action, bGlobal)).collect(Collectors.toSet());
    }

    private static Set<ShortcutElement> getShortcuts(ActionElement actionElement, KeyStrokeOptions kso) {
        TreeSet<ShortcutElement> shortcuts = new TreeSet<ShortcutElement>(ShortcutElement.COMPARATOR);
        if (actionElement != null) {
            IdeAction action = actionElement._act;
            KeyStrokeMap ksm = kso.getGlobalKeyMap();
            KeyStrokePanel.fillShortcuts(ksm, action, shortcuts);
            Iterator keyContextIter = KeyStrokePanel.allContextsStream().iterator();
            while (keyContextIter.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)keyContextIter.next();
                ksm = kso.getLocalKeyMap(ksc);
                KeyStrokePanel.fillShortcuts(ksm, action, shortcuts);
            }
        }
        return shortcuts;
    }

    private static void fillShortcuts(KeyStrokeMap ksm, IdeAction action, Set<ShortcutElement> shortcuts) {
        if (ksm != null) {
            List<KeyStrokes> oStrokes = ksm.getKeyStrokesFor((Integer)action.getCommandId());
            for (KeyStrokes kss : oStrokes) {
                shortcuts.add(new ShortcutElement(ksm, kss));
            }
        }
    }

    private void fillCurrentAssign(KeyStrokes kss) {
        StringBuffer buffer = new StringBuffer();
        if (!kss.isEmpty()) {
            KeyStrokeMap ksm = this._kso.getGlobalKeyMap();
            this.getCurrentAssign(ksm, kss, buffer);
            Iterator iKsc = KeyStrokePanel.allContextsStream().iterator();
            while (iKsc.hasNext()) {
                KeyStrokeContext ksc = (KeyStrokeContext)iKsc.next();
                ksm = this._kso.getLocalKeyMap(ksc);
                this.getCurrentAssign(ksm, kss, buffer);
            }
            this._jlblCurrentAssign.setText(buffer.toString());
        }
    }

    private void getCurrentAssign(KeyStrokeMap ksm, KeyStrokes kss, StringBuffer sBuffer) {
        String delim;
        String string = delim = sBuffer.length() == 0 ? "" : ", ";
        if (ksm != null) {
            List<KeyStrokes> lAssigned = ksm.getKeyStrokesStartingWith(kss);
            for (int i = 0; i < lAssigned.size(); ++i) {
                KeyStrokes kssAssigned = lAssigned.get(i);
                Integer binding = ksm.getBindingFor(kssAssigned);
                IdeAction action = this.findAction(binding);
                if (action == null) continue;
                sBuffer.append(delim);
                String category = KeyStrokePanel.getCategory(action);
                if (category != null) {
                    sBuffer.append(category).append(".");
                }
                sBuffer.append(KeyStrokePanel.getName(action));
            }
        }
    }

    private IdeAction findAction(int nID) {
        Optional<IdeAction> any = Stream.concat(KeyStrokePanel.allContextsStream().flatMap(ksc -> KeyStrokePanel.getAllActions(ksc, true).stream()), KeyStrokePanel.allContextsStream().flatMap(ksc -> KeyStrokePanel.getAllActions(ksc, false).stream())).filter(act -> act.getCommandId() == nID).findAny();
        return any.isPresent() ? any.get() : null;
    }

    private void loadPreset(String sPreset) {
        this._kso.loadPreset(Ide.getKeyStrokeContextRegistry(), sPreset);
        this.fillActions();
        this._jksNewShortcut.clear();
    }

    private void whenPreset() {
        String sCurrentPreset = this._kso.getPresetName();
        Frame parentFrame = this.getParentFrame();
        XMLKeystrokeContextDefs defs = XMLKeystrokeContextDefs.getInstance();
        String sNewPreset = PresetsPanel.run(parentFrame, sCurrentPreset);
        if (sNewPreset != null) {
            boolean bOk = true;
            if (this._kso.isModifiedPreset()) {
                bOk = this.confirm(parentFrame);
            }
            if (bOk) {
                this.loadPreset(sNewPreset);
                String text = this.searchField.getText();
                if (text.length() > 0) {
                    this.internalSearch(this.searchField.getText());
                }
            }
        }
        defs.unload();
    }

    private Frame getParentFrame() {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
    }

    private boolean confirm(Frame parentFrame) {
        String title = KeyStrokeArb.getString(19);
        String message = KeyStrokeArb.getString(20);
        String ok = KeyStrokeArb.getString(21);
        String cancel = KeyStrokeArb.getString(22);
        return MessageDialog.confirm((Component)parentFrame, (Object)message, (String)title, (String)"f1_idedloadpreset_html", (boolean)true, (String)ok, (String)cancel);
    }

    private void whenTableSelectionChange() {
        int row = this.getTableModelRowIndex();
        if (row == -1) {
            this._jksNewShortcut.setEnabled(false);
            this._jbAdd.setEnabled(false);
            this._jbRemove.setEnabled(false);
            this._jbCopy.setEnabled(false);
            return;
        }
        ActionElement actE = this._tableModel.getActionElement(row);
        this._jksNewShortcut.setEnabled(actE != null);
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        this._jbAdd.setEnabled(!kss.isEmpty());
        ShortcutElement shortcut = this._tableModel.getShortcutElement(row);
        boolean hasShortcut = shortcut != null || KeyStrokePanel.getShortcuts(actE, this._kso).size() > 0;
        this._jbRemove.setEnabled(hasShortcut);
        this._jbCopy.setEnabled(hasShortcut);
    }

    private void whenShortcutFieldChange() {
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        this.fillCurrentAssign(kss);
        this._jbAdd.setEnabled(!kss.isEmpty());
    }

    private void whenRemove() {
        ActionElement actionElement;
        Set<ShortcutElement> shortcuts;
        int modelRowIndex = this.getTableModelRowIndex();
        ShortcutElement se = this._tableModel.getShortcutElement(modelRowIndex);
        if (se != null) {
            se._map.remove(se._kss);
            this._kso.setModifiedPreset(true);
            this._tableModel.shortcutRemoved(modelRowIndex);
            this._jtActions.repaint();
        }
        if (!(shortcuts = KeyStrokePanel.getShortcuts(actionElement = this._tableModel.getActionElement(modelRowIndex), this._kso)).isEmpty()) {
            this._tableModel.removeRow(modelRowIndex);
        } else {
            this._jbRemove.setEnabled(false);
        }
        this.maybeRestoreSelectedRow(modelRowIndex);
    }

    private void whenAdd() {
        ShortcutElement element;
        KeyStrokes kss = this._jksNewShortcut.getModel().getKeyStrokes();
        Assert.check((kss != null ? 1 : 0) != 0, (String)"No keystroke to assign");
        int modelRowIndex = this.getTableModelRowIndex();
        Assert.check((modelRowIndex != -1 ? 1 : 0) != 0, (String)"No selection in actions table");
        ActionElement actionElement = this._tableModel.getActionElement(modelRowIndex);
        Assert.check((actionElement != null ? 1 : 0) != 0, (String)"ActionElement is null");
        if (kss.isRegularKey()) {
            String title = KeyStrokeArb.getString(37);
            String message = KeyStrokeArb.getString(36);
            if (!MessageDialog.confirm((Component)this.getParentFrame(), (Object)message, (String)title, null)) {
                this._jksNewShortcut.requestFocusInWindow();
                return;
            }
        }
        boolean bGlobal = actionElement._bGlobal;
        KeyStrokeContext ksc = actionElement._ksc;
        Iterator i = KeyStrokePanel.allContextsStream().iterator();
        while (i.hasNext()) {
            KeyStrokeContext kscI = (KeyStrokeContext)i.next();
            this.removeShortcutsStartingWith(kscI, kss, true);
            if (!bGlobal && kscI != ksc) continue;
            this.removeShortcutsStartingWith(kscI, kss, false);
        }
        KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
        IdeAction action = actionElement._act;
        Integer cmdId = action.getCommandId();
        if (ksm.values().contains(cmdId) && (element = this._tableModel.getShortcutElement(modelRowIndex)) != null && element._kss != null) {
            ksm.remove(element._kss);
        }
        ksm.put(kss, cmdId);
        this._jlblCurrentAssign.setText("");
        this._jksNewShortcut.clear();
        this._kso.setModifiedPreset(true);
        this._jbRemove.setEnabled(true);
        this._jbCopy.setEnabled(true);
        this._tableModel.removeShortcutsStartingWith(kss);
        this._tableModel.shortcutAdded(modelRowIndex, new ShortcutElement(ksm, kss));
        this._jtActions.repaint();
    }

    private void whenCopy() {
        int modelRowIndex = this.getTableModelRowIndex();
        int newModelRow = this._tableModel.duplicateRow(modelRowIndex);
        int newViewRow = this._jtActions.convertRowIndexToView(newModelRow);
        this.maybeRestoreSelectedRow(newViewRow == -1 ? modelRowIndex : newModelRow);
    }

    private void filterTable(RowFilter filter) {
        int row = this._jtActions.getSelectedRow();
        int modelRowIndex = row == -1 ? -1 : this._jtActions.convertRowIndexToModel(row);
        ((DefaultRowSorter)this._jtActions.getRowSorter()).setRowFilter(filter);
        this.maybeRestoreSelectedRow(modelRowIndex);
    }

    private void maybeRestoreSelectedRow(int modelRowIndex) {
        if (modelRowIndex >= 0) {
            int restore = this._jtActions.convertRowIndexToView(modelRowIndex);
            ListSelectionModel selectionModel = this._jtActions.getSelectionModel();
            if (restore >= 0) {
                selectionModel.setSelectionInterval(restore, restore);
            } else if (this._jtActions.getRowCount() > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
        } else if (this._jtActions.getRowCount() > 0) {
            this._jtActions.getSelectionModel().setSelectionInterval(0, 0);
        }
        this._jtActions.scrollToSelection();
    }

    private void whenHideUnmappedCommands() {
        boolean hide = this._jchkHideUnmapped.isSelected();
        this.filterTable(new KeyStrokeTableRowFilter(hide, this._lastSearch));
    }

    private int getTableModelRowIndex() {
        if (this._jtActions.getSelectedRowCount() == 1) {
            int row = this._jtActions.getSelectedRow();
            return this._jtActions.convertRowIndexToModel(row);
        }
        return -1;
    }

    private void whenImport() {
        if (KeyStrokeImporterExporter.importShortcuts(this._kso)) {
            this._kso.setModifiedPreset(true);
            this._jtActions.clearSelection();
            this._tableModel.clear();
            this.fillActions();
            this._jksNewShortcut.clear();
        }
    }

    private void whenExport() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeImporterExporter.exportCurrentShortcuts(kscr, this._kso);
    }

    private void removeShortcutsStartingWith(KeyStrokeContext ksc, KeyStrokes kss, boolean bGlobal) {
        KeyStrokeMap ksm = bGlobal ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(ksc);
        KeyStrokePanel.removeShortcutsStartingWith(ksm, kss);
    }

    private static void removeShortcutsStartingWith(KeyStrokeMap ksm, KeyStrokes kss) {
        if (ksm != null) {
            List<KeyStrokes> lKeys = ksm.getKeyStrokesStartingWith(kss);
            for (KeyStrokes key : lKeys) {
                ksm.remove(key);
            }
        }
    }

    private static String getName(IdeAction act) {
        return (String)act.getValue("Name");
    }

    private static String getCategory(IdeAction act) {
        String sCategory = (String)act.getValue("Category");
        if (sCategory == null) {
            sCategory = KeyStrokeArb.getString(8);
        }
        return sCategory;
    }

    private static Stream<KeyStrokeContext> allContextsStream() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        return kscr.getAllContextsStream();
    }

    private static Set<IdeAction> getAllActions(KeyStrokeContext ksc, boolean global) {
        Set allActions = ksc.getAllActions(global);
        if (allActions != null) {
            if (allActions.remove(null)) {
                Assert.println((String)(ksc.getClass().getName() + " returned a null Action from getAllActions(boolean)"));
            }
            return allActions;
        }
        return Collections.emptySet();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (!e.getValueIsAdjusting() && src == this._jtActions.getSelectionModel()) {
            this.whenTableSelectionChange();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._jbRemove) {
            this.whenRemove();
        } else if (src == this._jbAdd) {
            this.whenAdd();
        } else if (src == this._jbCopy) {
            this.whenCopy();
        } else if (src == this._jbPresets) {
            this.whenPreset();
        } else if (src == this._jbImport) {
            this.whenImport();
        } else if (src == this._jbExport) {
            this.whenExport();
        } else if (src == this._jksNewShortcut.getModel()) {
            this.whenShortcutFieldChange();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._jchkHideUnmapped) {
            this.whenHideUnmappedCommands();
        }
    }

    public void searchPerformed(SearchEvent se) {
        String searchStr = se.getSearchText().toLowerCase();
        if (searchStr.equals(this._lastSearch)) {
            return;
        }
        this.internalSearch(searchStr);
    }

    private void internalSearch(String text) {
        this._lastSearch = text;
        String pattern = this._lastSearch.length() == 0 ? null : this._lastSearch;
        this.filterTable(new KeyStrokeTableRowFilter(this._jchkHideUnmapped.isSelected(), pattern));
    }

    public void searchCategoryChanged(SearchEvent se) {
    }

    private class DeleteKeyListener
    implements KeyListener {
        private DeleteKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 8: 
                case 127: {
                    if (!KeyStrokePanel.this._searchFieldFocused || !KeyStrokePanel.this._jbRemove.isEnabled()) break;
                    KeyStrokePanel.this.whenRemove();
                }
            }
        }
    }
}

