/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageUtil;
import oracle.javatools.ui.Colors;

public class SelectFilesPanel
extends JPanel
implements CheckBoxListItemStateListener {
    private JScrollPane jScrollPane1;
    private JMultiLineLabel descriptionLabel;
    private JLabel listLabel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private CheckBoxList fileCheckBoxList;
    private GridBagConstraints gbc;
    private boolean listIsUpdating;
    private boolean checkedList;
    private String _prompt;
    private String description;
    static final String DEFAULT_HELP_TOPIC = "f1_idedsavefiles_html";
    public static final int SAVE_PROMPT = 216;
    public static final int ERASE_PROMPT = 217;
    public static final int RELOAD_PROMPT = 218;
    public static final int CANNOT_SAVE_PROMPT = 305;
    public static final int CANNOT_SAVE_ON_CLOSE_PROMPT = 286;
    public static final int CANNOT_SAVE_ON_EXIT_PROMPT = 292;
    public static final int YES_BUTTON = 0;
    public static final int OK_BUTTON = 0;
    public static final int NO_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    public static final int CLOSED_BUTTON = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_OPTION = -1;
    public static final int DLG_MAX_WIDTH = 800;
    public static final int DLG_MAX_HEIGHT = 600;
    public static final int DLG_MIN_WIDTH = 400;
    public static final int DLG_MIN_HEIGHT = 300;

    public SelectFilesPanel(CheckBoxListModel listModel, boolean checkedList) {
        this(listModel, checkedList, "");
    }

    protected SelectFilesPanel(CheckBoxListModel listModel, boolean checkedList, String prompt) {
        this(listModel, checkedList, prompt, null);
    }

    protected SelectFilesPanel(CheckBoxListModel listModel, boolean checkedList, String prompt, String description) {
        this._prompt = prompt;
        this.description = description;
        this.checkedList = checkedList;
        this.fileCheckBoxList = new CheckBoxList(listModel);
        listModel.sort();
        if (listModel.getSize() > 0) {
            this.fileCheckBoxList.setSelectedIndex(0);
            listModel.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final int showDialog(String title, CheckBoxListModel listModel) {
        return SelectFilesPanel.showDialog(title, listModel, 1);
    }

    public static final int showDialog(String title, CheckBoxListModel listModel, int option) {
        return SelectFilesPanel.showDialog(title, listModel, option, true);
    }

    public static final int showDialog(String title, CheckBoxListModel listModel, int option, boolean checkedList) {
        return SelectFilesPanel.showDialog(title, listModel, option, checkedList, null, null);
    }

    public static final int showDialog(String title, CheckBoxListModel listModel, int option, boolean checkedList, Object[] options, Object initialValue) {
        return SelectFilesPanel.showDialog((Component)((Object)Ide.getMainWindow()), title, listModel, option, checkedList, options, initialValue);
    }

    public static final int showDialog(Component parent, String title, CheckBoxListModel listModel, int option, boolean checkedList, Object[] options, Object initialValue) {
        return SelectFilesPanel.showDialog(parent, title, title, title, listModel, checkedList, 1, DEFAULT_HELP_TOPIC);
    }

    public static final int showDialog(String title, String filePrompt, String listPrompt, CheckBoxListModel listModel, boolean checkedList) {
        return SelectFilesPanel.showDialog(title, filePrompt, listPrompt, listModel, checkedList, 1);
    }

    public static final int showDialog(String title, String filePrompt, String listPrompt, CheckBoxListModel listModel, boolean checkedList, int buttons) {
        return SelectFilesPanel.showDialog((Component)((Object)Ide.getMainWindow()), title, filePrompt, listPrompt, listModel, checkedList, buttons, DEFAULT_HELP_TOPIC);
    }

    public static final int showDialog(String title, String filePrompt, String listPrompt, CheckBoxListModel listModel, boolean checkedList, int buttons, String helpTopic) {
        return SelectFilesPanel.showDialog((Component)((Object)Ide.getMainWindow()), title, filePrompt, listPrompt, listModel, checkedList, buttons, helpTopic);
    }

    public static final int showDialog(String title, String filePrompt, String listPrompt, CheckBoxListModel listModel, boolean checkedList, int buttons, String helpTopic, String description) {
        SelectFilesConfiguration configuration = new SelectFilesConfiguration((Component)((Object)Ide.getMainWindow()), title, filePrompt, listPrompt, listModel, checkedList, buttons, helpTopic);
        configuration.setDescription(description);
        return SelectFilesPanel.showDialog(configuration);
    }

    public static final int showDialog(Component parent, String title, String filePrompt, String listPrompt, CheckBoxListModel listModel, boolean checkedList, int buttons, String helpTopic) {
        SelectFilesConfiguration configuration = new SelectFilesConfiguration(parent, title, filePrompt, listPrompt, listModel, checkedList, buttons, helpTopic);
        return SelectFilesPanel.showDialog(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int showDialog(SelectFilesConfiguration configuration) {
        Component parent = configuration.getParent();
        String title = configuration.getTitle();
        String filePrompt = configuration.getFilePrompt();
        String listPrompt = configuration.getListPrompt();
        CheckBoxListModel listModel = configuration.getListModel();
        boolean checkedList = configuration.isCheckedList();
        int buttons = configuration.getButtons();
        String helpTopic = configuration.getHelpTopic();
        if (helpTopic == null || helpTopic.trim().length() == 0) {
            helpTopic = DEFAULT_HELP_TOPIC;
        }
        String optionalId = configuration.getOptionalId();
        String description = configuration.getDescription();
        if (optionalId != null && MessageDialog.getPersistence().isHidden(optionalId)) {
            listModel.selectAll();
            return 0;
        }
        JCheckBox optionalCheckBox = optionalId != null ? new JCheckBox() : null;
        int result = 2;
        try {
            int displayButtons;
            int size = listModel.getSize();
            if (size == 1) {
                String message = optionalCheckBox != null ? MessageUtil.createOptionalMessage((Object)filePrompt, (JCheckBox)optionalCheckBox) : filePrompt;
                int n = result = SelectFilesPanel.showPrompt(title, message, buttons, helpTopic);
                return n;
            }
            int n = displayButtons = buttons == 0 || buttons == -1 ? 1 : 3;
            if (helpTopic == null) {
                helpTopic = DEFAULT_HELP_TOPIC;
            }
            SelectFilesPanel pnl = new SelectFilesPanel(listModel, checkedList, listPrompt, description);
            HelpSystem.getHelpSystem().registerTopic(pnl, helpTopic);
            SelectFilesPanel message = optionalCheckBox != null ? MessageUtil.createOptionalMessage((Object)pnl, (JCheckBox)optionalCheckBox) : pnl;
            JEWTDialog dialog = SelectFilesPanel.newDialog(parent, title, message, displayButtons);
            dialog.setDefaultButton(1);
            result = dialog.runDialog() ? 0 : 2;
            dialog.dispose();
            int n2 = result;
            return n2;
        }
        finally {
            if (result == 0 && optionalCheckBox != null && optionalCheckBox.isSelected() && (!checkedList || listModel.getSelectionList() != null)) {
                MessageDialog.getPersistence().setHidden(optionalId, true);
            }
        }
    }

    private static final int showPrompt(String title, Object prompt, int buttons, String helpTopic) {
        switch (buttons) {
            case -1: {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)prompt, (String)title, (String)helpTopic);
                return 0;
            }
            case 1: {
                int response = MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)prompt, (String)title);
                if (response == 1) {
                    return 0;
                }
                if (response == 0) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)prompt, (String)title, (String)helpTopic, (boolean)false, (String)UIManager.getString("OptionPane.okButtonText"), (String)UIManager.getString("OptionPane.cancelButtonText")) ? 0 : 2;
            }
        }
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)prompt, (String)title, (String)helpTopic) ? 0 : 2;
    }

    private static JEWTDialog newDialog(Component parent, String title, Component panel, int buttons) {
        JEWTDialog dlg = JEWTDialog.createDialog((Component)parent, (String)title, (int)(buttons + 4));
        dlg.setMinimumSize(400, 300);
        dlg.setMaximumInitialSize(800, 600);
        dlg.setContent(panel);
        dlg.setResizable(true);
        return dlg;
    }

    private void jbInit() throws Exception {
        if (this.checkedList) {
            this.selectAllButton = new JButton();
            this.selectNoneButton = new JButton();
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectFilesPanel.this.listIsUpdating = true;
                    Object source = e.getSource();
                    if (source == SelectFilesPanel.this.selectAllButton) {
                        SelectFilesPanel.this.selectAllButton_actionPerformed(e);
                    } else if (source == SelectFilesPanel.this.selectNoneButton) {
                        SelectFilesPanel.this.selectNoneButton_actionPerformed(e);
                    }
                    SelectFilesPanel.this.listIsUpdating = false;
                }
            };
            ResourceUtils.resButton((AbstractButton)this.selectAllButton, (String)IdeArb.getString(212));
            this.selectAllButton.setDefaultCapable(false);
            this.selectAllButton.addActionListener(listener);
            this.selectAllButton.setEnabled(false);
            ListModel cbl = this.fileCheckBoxList.getModel();
            for (int i = 0; i < cbl.getSize(); ++i) {
                CheckBoxListCellData cblcd = (CheckBoxListCellData)cbl.getElementAt(i);
                if (!cblcd.getHasCheckBox() || cblcd.getCheckBoxState().booleanValue()) continue;
                this.selectAllButton.setEnabled(true);
                break;
            }
            ResourceUtils.resButton((AbstractButton)this.selectNoneButton, (String)IdeArb.getString(214));
            this.selectNoneButton.setDefaultCapable(false);
            this.selectNoneButton.addActionListener(listener);
            this.selectNoneButton.setEnabled(this.selectNoneEnabled());
        }
        this.fileCheckBoxList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1 = new JScrollPane((Component)this.fileCheckBoxList);
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        if (this.description != null && this.description.length() > 0) {
            this.descriptionLabel = new JMultiLineLabel(this.description);
            this.descriptionLabel.setForeground(Colors.HINT_TEXT);
            this.descriptionLabel.setVisible(true);
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.add((Component)((Object)this.descriptionLabel), this.gbc);
        }
        if (this._prompt != null && this._prompt.length() != 0) {
            this.listLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this.listLabel, (Component)this.fileCheckBoxList, (String)this._prompt);
            this.add((Component)this.listLabel, this.gbc);
        }
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jScrollPane1, this.gbc);
        if (this.checkedList) {
            this.updateButtonSizes();
            this.gbc.gridwidth = 1;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.0;
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.insets = new Insets(10, 8, 0, 0);
            this.add((Component)this.selectAllButton, this.gbc);
            this.gbc.weightx = 0.0;
            this.gbc.gridx = 1;
            this.add((Component)this.selectNoneButton, this.gbc);
        } else {
            CheckBoxListModel listModel = (CheckBoxListModel)this.fileCheckBoxList.getModel();
            listModel.setCheckBoxVisible(false, false);
        }
    }

    private boolean selectNoneEnabled() {
        CheckBoxListModel listModel = (CheckBoxListModel)this.fileCheckBoxList.getModel();
        return listModel.elementsWithCheckBoxCount() > 0;
    }

    void selectNoneButton_actionPerformed(ActionEvent e) {
        CheckBoxListModel listModel = (CheckBoxListModel)this.fileCheckBoxList.getModel();
        this.selectNoneButton.setEnabled(false);
        this.selectAllButton.setEnabled(true);
        listModel.deselectAll();
    }

    void selectAllButton_actionPerformed(ActionEvent e) {
        CheckBoxListModel listModel = (CheckBoxListModel)this.fileCheckBoxList.getModel();
        this.selectAllButton.setEnabled(false);
        this.selectNoneButton.setEnabled(true);
        listModel.selectAll();
    }

    private void updateButtonSizes() {
        Dimension d = this.selectAllButton.getPreferredSize();
        d.width = Math.max(d.width, this.selectNoneButton.getPreferredSize().width);
        this.selectAllButton.setPreferredSize(d);
        this.selectNoneButton.setPreferredSize(d);
    }

    public void stateChanged(Object source) {
        if (this.selectAllButton == null || this.selectNoneButton == null) {
            return;
        }
        if (!this.listIsUpdating) {
            CheckBoxListModel model = this.fileCheckBoxList.getCheckBoxListModel();
            this.updatedOtherElementsInSameGroup(source, model);
            List list = model.getSelectionList();
            int length = model.getSize();
            int selectedItems = list != null ? list.size() : 0;
            this.selectAllButton.setEnabled(selectedItems < length);
            this.selectNoneButton.setEnabled(selectedItems > 0);
        }
    }

    private void updatedOtherElementsInSameGroup(Object source, CheckBoxListModel model) {
        if (!(source instanceof CheckBoxListCellData)) {
            return;
        }
        int length = model.getSize();
        CheckBoxListCellData data = (CheckBoxListCellData)source;
        Object groupId = data.getGroupId();
        if (groupId != null) {
            TriStateBoolean state = data.getCheckBoxState();
            for (int i = 0; i < length; ++i) {
                CheckBoxListCellData d = (CheckBoxListCellData)model.getElementAt(i);
                if (d == data || !groupId.equals(d.getGroupId())) continue;
                d.setCheckBoxStateWithoutFiring(state);
            }
        }
    }
}

