/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.util.HashMap;
import oracle.ide.model.Element;

public class Handler {
    public void storeExpansionState(HashMap expansionStore, Element[] hierarchy) {
        String absolutePath = this.getAbsolutePath(hierarchy);
        expansionStore.put(absolutePath, true);
    }

    public boolean isExpanded(HashMap expansionStore, Element[] hierarchy) {
        String absolutePath = this.getAbsolutePath(hierarchy);
        return expansionStore.get(absolutePath) == Boolean.TRUE;
    }

    private String getAbsolutePath(Element[] expandedNodePath) {
        StringBuilder sb = new StringBuilder();
        for (Element element : expandedNodePath) {
            sb.append('/');
            String shortLabel = element.getShortLabel();
            String escapedLabel = shortLabel != null ? shortLabel.replace("/", "\\/") : "";
            sb.append(escapedLabel);
        }
        String absolutePath = sb.toString();
        return absolutePath;
    }
}

