/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;

public class AutoRepeatButtonModel
extends DefaultButtonModel
implements ActionListener {
    private final int _initDelay;
    private final int _repeatDelay;
    private Timer _timer;
    private ActionEvent _event;
    private Window _focusedWindow;

    public AutoRepeatButtonModel() {
        this(750, 50);
    }

    public AutoRepeatButtonModel(int initDelay, int repeatDelay) {
        this._initDelay = initDelay;
        this._repeatDelay = repeatDelay;
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() != b && this.isEnabled()) {
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this._event = new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers);
                this.launchTimer();
                this.fireActionPerformed(this._event);
            } else {
                this.stopTimer();
            }
            this.fireStateChanged();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b) {
            this.stopTimer();
        }
        super.setEnabled(b);
    }

    public void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
            this._focusedWindow = null;
        }
    }

    private void launchTimer() {
        if (this._timer == null) {
            this._timer = new Timer(this._repeatDelay, this);
            this._timer.setInitialDelay(this._initDelay);
            this._timer.setRepeats(true);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._focusedWindow = focusManager.getFocusedWindow();
            this._timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window focusedWindow = focusManager.getFocusedWindow();
        if (focusedWindow == this._focusedWindow) {
            this.fireActionPerformed(this._event);
        } else {
            this.stopTimer();
        }
    }
}

