/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.AnnotatedController;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.resource.ProgressTrackerArb;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class AsynchronousController
implements Controller {
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("AsynchronousIdeActionHandler", Integer.MAX_VALUE);
    private static final RequestProcessor REQUEST_PROCESSOR_TI = new RequestProcessor("AsynchronousIdeActionHandler_TI", Integer.MAX_VALUE, true);
    private AnnotatedController ac;

    protected AsynchronousController() {
        this(true);
    }

    protected AsynchronousController(boolean useAnnotations) {
        if (useAnnotations) {
            this.ac = new AnnotatedController(this);
        }
    }

    protected final boolean handleAsynchronously(IdeAction action, Context context) {
        return this.handleAsynchronously(action, context, false);
    }

    protected final boolean handleAsynchronously(IdeAction action, Context context, boolean useThreadInterrupt) {
        new AcRunnable(this, action, context, new TaskInfo(useThreadInterrupt)).submit();
        return true;
    }

    protected void handleEvent(IdeAction action, Context context, TaskInfo taskInfo) {
        if (this.ac != null) {
            this.ac.handleEvent(action, context, taskInfo);
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (this.ac != null) {
            return this.ac.handleEvent(action, context);
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        if (this.ac != null) {
            return this.ac.update(action, context);
        }
        return false;
    }

    private static class UIUtils {
        private UIUtils() {
        }

        private static JEWTDialog createModalProgressDialog(String title, boolean cancelable, JComponent progressBar, JLabel mainLabel, JLabel detailLabel) {
            assert (EventQueue.isDispatchThread());
            JPanel panel = new JPanel(new GridBagLayout());
            JPanel contentPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 21;
            Font f = mainLabel.getFont();
            if (f != null) {
                mainLabel.setFont(f.deriveFont(1));
            }
            contentPanel.add((Component)mainLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            contentPanel.add((Component)progressBar, gridBagConstraints);
            if (detailLabel != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 21;
                contentPanel.add((Component)detailLabel, gridBagConstraints);
            }
            JPanel emptyPanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = detailLabel != null ? 3 : 2;
            gridBagConstraints.weighty = 2.0;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.fill = 2;
            contentPanel.add((Component)emptyPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            panel.add((Component)contentPanel, gridBagConstraints);
            JEWTDialog result = JEWTDialog.createDialog((Component)((Object)Ide.getMainWindow()), (String)title, (int)(cancelable ? 2 : 0));
            result.setDefaultCloseOperation(0);
            result.setMinimumSize(400, 150);
            result.setSize(400, 150);
            result.setContent((Component)panel);
            result.setLocationRelativeTo((Component)((Object)Ide.getMainWindow()));
            result.pack();
            result.setResizable(true);
            result.setModal(true);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean waitTimeInterval(boolean waitCursor, int timeout, CountDownLatch l) {
            Component glassPane = Ide.getMainWindow().getGlassPane();
            Cursor original = glassPane.getCursor();
            try {
                if (waitCursor) {
                    Cursor wait = Cursor.getPredefinedCursor(3);
                    glassPane.setCursor(wait);
                }
                glassPane.setVisible(true);
                try {
                    boolean wait = l.await(timeout, TimeUnit.MILLISECONDS);
                    return wait;
                }
                catch (InterruptedException ex) {
                    boolean bl = true;
                    glassPane.setVisible(false);
                    glassPane.setCursor(original);
                    return bl;
                }
            }
            finally {
                glassPane.setVisible(false);
                glassPane.setCursor(original);
            }
        }
    }

    private static class AcRunnable
    implements Runnable {
        private AsynchronousController controller;
        private IdeAction action;
        private Context context;
        private TaskInfo taskInfo;
        private boolean didRun;

        private AcRunnable(AsynchronousController controller, IdeAction action, Context context, TaskInfo taskInfo) {
            this.controller = controller;
            this.action = action;
            this.context = context;
            this.taskInfo = taskInfo;
        }

        private void submit() {
            this.taskInfo.latch = new CountDownLatch(1);
            if (this.taskInfo.useInterrupt) {
                this.taskInfo.task = REQUEST_PROCESSOR_TI.post((Runnable)this);
            } else {
                this.taskInfo.task = REQUEST_PROCESSOR.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.didRun) {
                return;
            }
            this.didRun = true;
            try {
                this.controller.handleEvent(this.action, this.context, this.taskInfo);
            }
            finally {
                if (this.taskInfo.latch != null) {
                    this.taskInfo.latch.countDown();
                }
                this.taskInfo.finished();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Updater {
        public String[] names() default {};

        public int[] ids() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handler {
        public String[] names() default {};

        public int[] ids() default {};

        public boolean useThreadInterrupt() default true;
    }

    public static final class TaskInfo
    implements Cancellable {
        private AtomicBoolean cancel = new AtomicBoolean();
        private ProgressHandle ph;
        private JEWTDialog dlg;
        private WaitCursor waitCursor;
        private boolean useInterrupt;
        private RequestProcessor.Task task;
        private CountDownLatch latch;

        private TaskInfo(boolean useInterrupt) {
            this.useInterrupt = useInterrupt;
        }

        public final boolean isCancelled() {
            return this.cancel.get();
        }

        public final boolean cancel() {
            if (this.useInterrupt && this.task != null) {
                this.task.cancel();
            }
            this.cancel.set(true);
            return true;
        }

        public final void waitFinished() {
            if (!this.task.isFinished()) {
                this.task.waitFinished();
            }
        }

        public final WaitCursor showWaitCursor() {
            this.waitCursor = new WaitCursor((Component)((Object)Ide.getMainWindow()));
            this.waitCursor.show();
            return this.waitCursor;
        }

        public final synchronized ProgressHandle createHandle(String displayName, boolean cancelable, boolean modal) {
            if (this.ph == null) {
                if (modal) {
                    this.ph = ProgressHandle.createHandle((String)displayName);
                    JComponent phc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.ph);
                    SwingUtilities.invokeLater(new DialogRunner(cancelable, phc));
                } else {
                    this.ph = cancelable ? ProgressHandle.createHandle((String)displayName, (Cancellable)this) : ProgressHandle.createHandle((String)displayName);
                }
            }
            return this.ph;
        }

        public final synchronized ProgressHandle createHandle(String displayName, boolean cancelable, int waitCursorAfter, int dialogAfter) {
            if (this.ph == null) {
                this.ph = ProgressHandle.createHandle((String)displayName, (Cancellable)(cancelable ? this : null));
                JComponent progressBar = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.ph);
                JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)this.ph);
                JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)this.ph);
                if (waitCursorAfter < 0) {
                    waitCursorAfter = 1000;
                }
                if (dialogAfter < 0) {
                    dialogAfter = 2000;
                }
                SwingUtilities.invokeLater(new DialogRunner2(displayName, cancelable, waitCursorAfter, dialogAfter, progressBar, mainLabel, detailLabel));
            }
            return this.ph;
        }

        public final ProgressHandle getHandle() {
            return this.ph;
        }

        private void finished() {
            if (this.ph != null) {
                this.ph.finish();
            }
            if (this.dlg != null) {
                SwingUtilities.invokeLater(new DialogRunner());
            }
            if (this.waitCursor != null) {
                this.waitCursor.hide();
            }
        }

        private class DialogRunner2
        implements Runnable {
            private boolean start;
            private JComponent progressBar;
            private int dialogAfter;
            private boolean cancelable;
            private String dialogTitle;
            private int waitCursorAfter;
            private JLabel mainLabel;
            private JLabel detailLabel;

            private DialogRunner2(String dialogTitle, boolean cancelable, int waitCursorAfter, int dialogAfter, JComponent progressBar, JLabel mainLabel, JLabel detailLabel) {
                this.dialogTitle = dialogTitle;
                this.cancelable = cancelable;
                this.waitCursorAfter = waitCursorAfter;
                this.dialogAfter = dialogAfter;
                this.progressBar = progressBar;
                this.mainLabel = mainLabel;
                this.detailLabel = detailLabel;
                this.start = true;
            }

            @Override
            public void run() {
                if (this.start) {
                    if (UIUtils.waitTimeInterval(false, this.waitCursorAfter, TaskInfo.this.latch)) {
                        return;
                    }
                    if (UIUtils.waitTimeInterval(true, this.dialogAfter, TaskInfo.this.latch)) {
                        return;
                    }
                    TaskInfo.this.dlg = UIUtils.createModalProgressDialog(this.dialogTitle, this.cancelable, this.progressBar, this.mainLabel, this.detailLabel);
                    TaskInfo.this.dlg.addWindowListener((WindowListener)new CancelationListener());
                    WizardLauncher.runDialog((JDialog)TaskInfo.this.dlg);
                }
            }
        }

        private class DialogRunner
        implements Runnable {
            final boolean cancelable;
            final JComponent phc;
            final boolean start;

            DialogRunner(boolean cancelable, JComponent phc) {
                this.cancelable = cancelable;
                this.phc = phc;
                this.start = true;
            }

            DialogRunner() {
                this.phc = null;
                this.cancelable = false;
                this.start = false;
            }

            @Override
            public void run() {
                if (this.start) {
                    TaskInfo.this.dlg = JEWTDialog.createDialog((Component)((Object)Ide.getMainWindow()), (String)ProgressTrackerArb.getString(4), (int)(this.cancelable ? 2 : 0));
                    TaskInfo.this.dlg.setContent((Component)this.phc);
                    TaskInfo.this.dlg.setUndecorated(!this.cancelable);
                    TaskInfo.this.dlg.setDefaultCloseOperation(0);
                    TaskInfo.this.dlg.pack();
                    TaskInfo.this.dlg.setResizable(true);
                    TaskInfo.this.dlg.setModal(true);
                    TaskInfo.this.dlg.addWindowListener((WindowListener)new CancelationListener());
                    WizardLauncher.runDialog((JDialog)TaskInfo.this.dlg);
                } else if (TaskInfo.this.dlg != null) {
                    TaskInfo.this.dlg.dispose();
                }
            }
        }

        private class CancelationListener
        implements WindowListener {
            private CancelationListener() {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                TaskInfo.this.cancel();
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        }
    }
}

