/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.TabbedHandler;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class JDevTopComponent
extends CloneableTopComponent {
    protected final JPanel contentPanel = new JPanel(new BorderLayout());
    private ViewLookup viewLookup;

    protected JDevTopComponent() {
        this.setLayout(new BorderLayout());
        this.contentPanel.setBackground(Color.white);
        this.add(this.contentPanel, "Center");
        this.viewLookup = new ViewLookup();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this.getActionMap()), this.viewLookup}));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)JDevTopComponent.this));
                if (dialog == null) {
                    return;
                }
                dialog.setMinimumSize(new Dimension(100, 100));
                JDevTopComponent.this.removeComponentListener(this);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    void updateViewLookup(View view) {
        this.viewLookup.setLookupFromView(view);
    }

    protected void componentActivated() {
        this.viewLookup.watchSelection(true);
    }

    protected void componentDeactivated() {
        if (this.viewLookup != null) {
            this.viewLookup.watchSelection(false);
        }
    }

    protected final void cleanUp() {
        this.viewLookup.cleanUp();
    }

    void showWindowMenu() {
        Point p = this.getPosition();
        if (p == null) {
            return;
        }
        MouseEvent mouseEvent = new MouseEvent((Component)((Object)this), 0, 0L, 0, p.x, p.y, 0, true, 1);
        this.getRegistry().getActivated().getPopupLocation(mouseEvent);
        TabbedHandler.handlePopupMenuShowing((MouseEvent)mouseEvent, (int)this.getTabPosition());
    }

    private Point getPosition() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (!wm.getActiveMode().getOpenedTopComponents().contains((Object)this)) {
            return null;
        }
        Container component = this.getParent().getParent();
        if (!(component instanceof TabbedAdapter)) {
            Logger.getAnonymousLogger().warning("No TabAddapter for " + this.getDisplayName());
            return null;
        }
        TabbedAdapter tabbedAdapter = (TabbedAdapter)component;
        if (tabbedAdapter.getTabbed() == null) {
            return new Point(0, 0);
        }
        int width = 0;
        for (int i = 0; i < tabbedAdapter.getTabbed().getTabCount() && tabbedAdapter.getTabbed().getTopComponentAt(i) != this; ++i) {
            int lastWidth = tabbedAdapter.getTabbed().getTabBounds((int)i).width;
            width += lastWidth;
        }
        return new Point(width, 0);
    }

    public static final void activateTCWithoutFocusIfPossible(TopComponent tc) {
        if (tc == null) {
            return;
        }
        TopComponent currentTC = TopComponent.getRegistry().getActivated();
        Set modes = WindowManagerImpl.getInstance().getModes();
        for (ModeImpl mode : modes) {
            if (mode == null || !mode.containsTopComponent(tc)) continue;
            if (currentTC != null && mode.containsTopComponent(currentTC)) {
                tc.requestActive();
                return;
            }
            mode.setSelectedTopComponent(tc);
            return;
        }
    }

    private static class NodeListener
    implements LookupListener {
        private View view;

        NodeListener(View view) {
            this.view = view;
        }

        public void resultChanged(LookupEvent e) {
            try {
                Method m = View.class.getDeclaredMethod("fireViewSelectionChanged", ViewSelectionEvent.class);
                m.setAccessible(true);
                m.invoke((Object)this.view, new ViewSelectionEvent(this.view));
            }
            catch (Exception ex) {
                Logger.getLogger(JDevTopComponent.class.getName()).log(Level.INFO, "", ex);
            }
        }
    }

    private static class ViewLookup
    extends ProxyLookup {
        private View view;
        private Lookup viewLookup;
        private Lookup.Result<Node> nodeResult;
        private LookupListener nodeListener;

        private ViewLookup() {
        }

        void setLookupFromView(View view) {
            this.view = view;
            Object ctxLookup = view.getContext().getProperty(Lookup.class.getName());
            Lookup l = ctxLookup instanceof Lookup ? (Lookup)ctxLookup : (view instanceof Lookup.Provider && !(view instanceof NbView) ? ((Lookup.Provider)view).getLookup() : Lookup.EMPTY);
            if (l != this.viewLookup) {
                this.watchSelection(false);
                this.viewLookup = l;
                this.watchSelection(true);
                this.setLookups(new Lookup[]{l});
            }
        }

        void watchSelection(boolean watch) {
            if (watch && this.nodeResult == null && this.nodeListener == null && this.viewLookup != null && this.viewLookup != Lookup.EMPTY) {
                this.nodeResult = this.viewLookup.lookupResult(Node.class);
                this.nodeListener = new NodeListener(this.view);
                this.nodeResult.addLookupListener(this.nodeListener);
            } else if (!watch && this.nodeResult != null && this.nodeListener != null) {
                this.nodeResult.removeLookupListener(this.nodeListener);
                this.nodeResult = null;
                this.nodeListener = null;
            }
        }

        private void cleanUp() {
            this.view = null;
        }
    }
}

