/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.DockableOrientation;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ideimpl.layout.RoleLayoutShapingProvider;

class DockableLocation
implements Serializable {
    private String referenceId;
    private DockableOrientation orientation;
    private final int extent;
    private final DockableOrientation alternatOrientation;
    private final Rectangle floatingCoordinates;
    private boolean tabbedForced;
    private final boolean floating;
    private static final DockableLocation DEFAULT_LOCATION = new DockableLocation(null, DockableOrientation.West, 1, DockableOrientation.West, false, null, false);

    private DockableLocation(String referenceId, DockableOrientation orientation, int extent, DockableOrientation alternateOrientation, boolean floating, Rectangle floatingCoordinates, boolean tabbedForced) {
        this.referenceId = referenceId;
        this.orientation = orientation;
        this.extent = extent;
        this.alternatOrientation = alternateOrientation;
        this.floating = floating;
        this.floatingCoordinates = floatingCoordinates;
        this.tabbedForced = tabbedForced;
    }

    public static DockableLocation fromDockingParam(DockingParam dp, Dockable dockable) {
        if (null == dp) {
            return DEFAULT_LOCATION;
        }
        String referenceId = null;
        Dockable ref = dp.getReference();
        if (null != ref && !ref.equals(dockable)) {
            referenceId = NbDockStation.getId(ref);
        }
        RoleLayoutShapingProvider roleLayout = RoleLayoutShapingProvider.getInstance();
        boolean tabbedForced_ = roleLayout.isTabbed(dockable.getUniqueName());
        DockableOrientation orientation = DockableOrientation.fromInt(dp.getOrientation());
        int extent = dp.getExtents();
        DockableOrientation alternateOrientation = DockableOrientation.fromInt(dp.getAlternateOrientation());
        boolean floating = dp.isFloating();
        Rectangle floatingCoordinates = dp.getFloatingPosition();
        return new DockableLocation(referenceId, orientation, extent, alternateOrientation, floating, floatingCoordinates, tabbedForced_);
    }

    public DockableOrientation getAlternatOrientation() {
        return this.alternatOrientation;
    }

    public int getExtent() {
        return this.extent;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public DockableOrientation getOrientation() {
        return this.orientation;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Rectangle getFloatingCoordinates() {
        return this.floatingCoordinates;
    }

    public boolean isTabbedForced() {
        return this.tabbedForced;
    }

    public void setOrientation(DockableOrientation orientation) {
        this.orientation = orientation;
    }

    public void setReferencesId(String referenceId) {
        this.referenceId = referenceId;
    }
}

