/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.table.ReadOptions;

public class TableIteratorOptions
extends ReadOptions {
    private final Direction direction;
    private final int maxConcurrentRequests;
    private final int batchResultsSize;
    private int maxResultsBatches;

    public TableIteratorOptions(Direction direction, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        this(direction, consistency, timeout, timeoutUnit, 0, 0);
    }

    public TableIteratorOptions(Direction direction, Consistency consistency, long timeout, TimeUnit timeoutUnit, int maxConcurrentRequests, int batchResultsSize) {
        super(consistency, timeout, timeoutUnit);
        if (direction == null) {
            throw new IllegalArgumentException("direction must not be null");
        }
        if (maxConcurrentRequests < 0) {
            throw new IllegalArgumentException("maxConcurrentRequests must be >= 0");
        }
        if (batchResultsSize < 0) {
            throw new IllegalArgumentException("batchResultsSize must be >= 0");
        }
        this.direction = direction;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.batchResultsSize = batchResultsSize;
    }

    @Deprecated
    public TableIteratorOptions(Direction direction, Consistency consistency, long timeout, TimeUnit timeoutUnit, int maxConcurrentRequests, int batchResultsSize, int maxResultsBatches) {
        this(direction, consistency, timeout, timeoutUnit, maxConcurrentRequests, batchResultsSize);
        this.maxResultsBatches = maxResultsBatches;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public int getResultsBatchSize() {
        return this.batchResultsSize;
    }

    @Deprecated
    public int getMaxResultsBatches() {
        return this.maxResultsBatches;
    }
}

