/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.query;

import java.math.MathContext;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.TableIteratorOptions;

public class ExecuteOptions {
    private Consistency consistency;
    private Durability durability;
    private long timeout;
    private TimeUnit timeoutUnit;
    private int maxConcurrentRequests;
    private int resultsBatchSize;
    private byte traceLevel;
    private MathContext mathContext = MathContext.DECIMAL32;
    private String namespace;

    public ExecuteOptions setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public ExecuteOptions setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public ExecuteOptions setTimeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        if (timeout != 0L && timeoutUnit == null) {
            throw new IllegalArgumentException("A non-zero timeout requires a non-null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public ExecuteOptions setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    public int getResultsBatchSize() {
        return this.resultsBatchSize > 0 ? this.resultsBatchSize : KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE;
    }

    public ExecuteOptions setResultsBatchSize(int resultsBatchSize) {
        this.resultsBatchSize = resultsBatchSize;
        return this;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public ExecuteOptions setMathContext(MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public byte getTraceLevel() {
        return this.traceLevel;
    }

    public ExecuteOptions setTraceLevel(byte level) {
        this.traceLevel = level;
        return this;
    }

    public ExecuteOptions setNamespace(String namespace) {
        if (namespace != null) {
            TableImpl.validateNamespace(namespace);
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public TableIteratorOptions createTableIteratorOptions(Direction direction) {
        return new TableIteratorOptions(direction, this.consistency, this.timeout, this.timeoutUnit, this.maxConcurrentRequests, this.resultsBatchSize);
    }
}

