/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.SerializationUtil;

@Persistent
public class RepNode
extends Topology.Component<RepNodeId>
implements Comparable<RepNode> {
    private static final long serialVersionUID = 1L;
    private StorageNodeId storageNodeId;

    public RepNode(StorageNodeId storageNodeId) {
        this.storageNodeId = storageNodeId;
    }

    RepNode(Topology topology, RepNodeId rnId, DataInput in, short serialVersion) throws IOException {
        super(topology, rnId, in, serialVersion);
        if (in.readBoolean()) {
            ResourceId rId = ResourceId.readFastExternal(in, serialVersion);
            if (!(rId instanceof StorageNodeId)) {
                throw new IOException("Expected StorageNodeId: " + rId);
            }
            this.storageNodeId = (StorageNodeId)rId;
        } else {
            this.storageNodeId = null;
        }
    }

    private RepNode(RepNode repNode) {
        super(repNode);
        this.storageNodeId = repNode.storageNodeId.clone();
    }

    private RepNode() {
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.storageNodeId);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.REP_NODE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.storageNodeId == null ? 0 : this.storageNodeId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepNode other = (RepNode)obj;
        return this.propertiesEquals(other);
    }

    public boolean propertiesEquals(RepNode other) {
        return !(this.storageNodeId == null ? other.storageNodeId != null : !this.storageNodeId.equals(other.storageNodeId));
    }

    public RepGroupId getRepGroupId() {
        return new RepGroupId(((RepNodeId)this.getResourceId()).getGroupId());
    }

    @Override
    public StorageNodeId getStorageNodeId() {
        return this.storageNodeId;
    }

    @Override
    public RepNode clone() {
        return new RepNode(this);
    }

    @Override
    public boolean isMonitorEnabled() {
        return true;
    }

    public String toString() {
        return "[" + this.getResourceId() + "]" + " sn=" + this.storageNodeId;
    }

    @Override
    public int compareTo(RepNode other) {
        return ((RepNodeId)this.getResourceId()).compareTo((RepNodeId)other.getResourceId());
    }
}

