/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeComponentMap;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeComponentMap;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

@Persistent(version=1)
public class RepGroup
extends Topology.Component<RepGroupId> {
    private static final long serialVersionUID = 1L;
    private final ComponentMap<RepNodeId, RepNode> repNodeMap;
    private ComponentMap<ArbNodeId, ArbNode> arbNodeMap;

    public RepGroup() {
        this.repNodeMap = new RepNodeComponentMap(this, null);
        this.arbNodeMap = new ArbNodeComponentMap(this, null);
    }

    private RepGroup(RepGroup repGroup) {
        super(repGroup);
        this.repNodeMap = new RepNodeComponentMap(this, null);
        this.arbNodeMap = new ArbNodeComponentMap(this, null);
    }

    RepGroup(Topology topology, RepGroupId rgId, DataInput in, short serialVersion) throws IOException {
        super(topology, rgId, in, serialVersion);
        this.repNodeMap = new RepNodeComponentMap(this, topology, in, serialVersion);
        this.arbNodeMap = new ArbNodeComponentMap(this, topology, in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.repNodeMap.writeFastExternal(out, serialVersion);
        this.arbNodeMap.writeFastExternal(out, serialVersion);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.REP_GROUP;
    }

    public Collection<RepNode> getRepNodes() {
        return this.repNodeMap.getAll();
    }

    @Override
    public Topology.Component<?> clone() {
        return new RepGroup(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.repNodeMap == null ? 0 : this.repNodeMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepGroup other = (RepGroup)obj;
        if (this.repNodeMap == null) {
            if (other.repNodeMap != null) {
                return false;
            }
        } else {
            if (!this.repNodeMap.equals(other.repNodeMap)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
        }
        return true;
    }

    public RepNode get(RepNodeId repNodeId) {
        return this.repNodeMap.get(repNodeId);
    }

    public RepNode add(RepNode repNode) {
        return this.repNodeMap.add(repNode);
    }

    public RepNode update(RepNodeId resourceId, RepNode repNode) {
        return this.repNodeMap.update(resourceId, repNode);
    }

    public RepNode remove(RepNodeId repNodeId) {
        return this.repNodeMap.remove(repNodeId);
    }

    public void apply(TopologyChange change) {
        this.repNodeMap.apply(change);
    }

    public Collection<ArbNode> getArbNodes() {
        return this.arbNodeMap.getAll();
    }

    public ArbNode get(ArbNodeId arbNodeId) {
        return this.arbNodeMap.get(arbNodeId);
    }

    public ArbNode add(ArbNode arbNode) {
        return this.arbNodeMap.add(arbNode);
    }

    public ArbNode update(ArbNodeId resourceId, ArbNode arbNode) {
        return this.arbNodeMap.update(resourceId, arbNode);
    }

    public ArbNode remove(ArbNodeId arbNodeId) {
        return this.arbNodeMap.remove(arbNodeId);
    }

    public void applyArbChange(TopologyChange change) {
        this.arbNodeMap.apply(change);
    }

    @Override
    public void setTopology(Topology topology) {
        super.setTopology(topology);
        this.repNodeMap.setTopology(topology);
        this.arbNodeMap.setTopology(topology);
    }

    public String toString() {
        return "[" + this.getResourceId() + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.arbNodeMap == null) {
            this.arbNodeMap = new ArbNodeComponentMap(this, null);
        }
    }
}

