/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.types;

import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

public class ExprType
implements Cloneable {
    private final TypeCode theTypeCode;
    private Quantifier theQuantifier;
    private final FieldDefImpl theTypeDef;
    private final boolean theIsBuiltin;

    static boolean isBuiltin(TypeCode t) {
        switch (t) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case BINARY: 
            case ANY: 
            case JSON: 
            case ANY_JSON_ATOMIC: 
            case ANY_ATOMIC: 
            case ANY_RECORD: 
            case EMPTY: {
                return true;
            }
        }
        return false;
    }

    ExprType(FieldDefImpl type, boolean isBuiltin) {
        this(type, Quantifier.ONE, isBuiltin);
    }

    ExprType(FieldDefImpl t, Quantifier q, boolean isBuiltin) {
        this.theTypeCode = ExprType.getTypeCodeForDefCode(t.getType());
        this.theTypeDef = t;
        this.theQuantifier = q;
        this.theIsBuiltin = isBuiltin;
    }

    ExprType(ExprType other) {
        assert (!other.theIsBuiltin);
        this.theTypeCode = other.theTypeCode;
        this.theTypeDef = other.theTypeDef;
        this.theQuantifier = other.theQuantifier;
        this.theIsBuiltin = false;
    }

    public ExprType clone() {
        if (this.theIsBuiltin) {
            return this;
        }
        return new ExprType(this);
    }

    public TypeCode getCode() {
        return this.theTypeCode;
    }

    public Quantifier getQuantifier() {
        return this.theQuantifier;
    }

    void setQuant(Quantifier q) {
        this.theQuantifier = q;
    }

    boolean isMultiValued() {
        return this.theQuantifier == Quantifier.STAR || this.theQuantifier == Quantifier.PLUS;
    }

    public FieldDefImpl getDef() {
        return this.theTypeDef;
    }

    public boolean isBuiltin() {
        return this.theIsBuiltin;
    }

    public boolean isEmpty() {
        return this.theTypeCode == TypeCode.EMPTY;
    }

    public boolean isAny() {
        return this.theTypeCode == TypeCode.ANY;
    }

    public boolean isAnyJson() {
        return this.theTypeCode == TypeCode.JSON;
    }

    public boolean isAnyAtomic() {
        return this.theTypeCode == TypeCode.ANY_ATOMIC;
    }

    public boolean isAnyJsonAtomic() {
        return this.theTypeCode == TypeCode.ANY_JSON_ATOMIC;
    }

    public boolean isAnyRecord() {
        return this.theTypeCode == TypeCode.ANY_RECORD;
    }

    public boolean isComplex() {
        switch (this.theTypeCode) {
            case ANY: 
            case JSON: 
            case ANY_RECORD: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isRecord() {
        return this.theTypeCode == TypeCode.ANY_RECORD || this.theTypeCode == TypeCode.RECORD;
    }

    public boolean isArray() {
        return this.theTypeCode == TypeCode.ARRAY;
    }

    public boolean isMap() {
        return this.theTypeCode == TypeCode.MAP;
    }

    public boolean isPrecise() {
        return this.theTypeDef.isPrecise();
    }

    public boolean isAtomic() {
        return this.theTypeDef.isAtomic();
    }

    public boolean isNumeric() {
        return this.theTypeDef.isNumeric();
    }

    public ExprType getArrayElementType(Quantifier quant) {
        switch (this.theTypeCode) {
            case ARRAY: {
                assert (this.theTypeDef != null);
                ArrayDefImpl arrDef = (ArrayDefImpl)this.theTypeDef;
                FieldDefImpl elemDef = arrDef.getElement();
                return TypeManager.createType(elemDef, quant);
            }
            case ANY: {
                return TypeManager.createType(TypeManager.ANY_ONE(), quant);
            }
            case JSON: {
                return TypeManager.createType(TypeManager.JSON_ONE(), quant);
            }
            case EMPTY: {
                return TypeManager.EMPTY();
            }
        }
        return TypeManager.createType(this, quant);
    }

    public ExprType getMapElementType(Quantifier quant) {
        switch (this.theTypeCode) {
            case MAP: {
                MapDefImpl mapDef = (MapDefImpl)this.theTypeDef;
                FieldDefImpl elemDef = mapDef.getElement();
                return TypeManager.createType(elemDef, quant);
            }
            case ANY: 
            case RECORD: {
                return TypeManager.createType(TypeManager.ANY_ONE(), quant);
            }
            case JSON: {
                return TypeManager.createType(TypeManager.JSON_ONE(), quant);
            }
            case EMPTY: {
                return TypeManager.EMPTY();
            }
        }
        return TypeManager.EMPTY();
    }

    public ExprType getFieldType(int pos, Quantifier quant) {
        switch (this.theTypeCode) {
            case ANY_RECORD: {
                return TypeManager.createType(TypeManager.ANY_ONE(), quant);
            }
            case RECORD: {
                RecordDefImpl recDef = (RecordDefImpl)this.getDef();
                FieldDefImpl fieldDef = recDef.getFieldDef(pos);
                return TypeManager.createType(fieldDef, quant);
            }
        }
        assert (false);
        return null;
    }

    public ExprType getItemType() {
        return TypeManager.createType(this, Quantifier.ONE);
    }

    public boolean equals(Object o) {
        return this.equals(o, true);
    }

    public boolean equals(Object o, boolean compareQuants) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExprType)) {
            return false;
        }
        ExprType other = (ExprType)o;
        if (compareQuants && this.theQuantifier != other.theQuantifier) {
            return false;
        }
        if (this.theTypeCode != other.theTypeCode) {
            return false;
        }
        return this.theTypeDef.equals(other.theTypeDef);
    }

    public int hashCode() {
        return this.theQuantifier.hashCode() + this.theTypeCode.hashCode() + (this.theTypeDef != null ? this.theTypeDef.hashCode() : 0);
    }

    public boolean isSubType(ExprType superType) {
        return this.isSubType(superType, true);
    }

    public boolean isSubType(ExprType superType, boolean compareQuants) {
        if (this == superType) {
            return true;
        }
        if (compareQuants && !TypeManager.isSubQuant(this.theQuantifier, superType.theQuantifier)) {
            return false;
        }
        if (this.theTypeCode == TypeCode.EMPTY) {
            return true;
        }
        if (!TypeManager.isSubTypeCode(this.theTypeCode, superType.theTypeCode)) {
            return false;
        }
        switch (superType.theTypeCode) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case BINARY: 
            case ANY: 
            case ANY_JSON_ATOMIC: 
            case ANY_ATOMIC: 
            case ANY_RECORD: {
                return true;
            }
            case JSON: 
            case RECORD: 
            case ARRAY: 
            case MAP: 
            case TIMESTAMP: 
            case ENUM: 
            case FIXED_BINARY: {
                return this.theTypeDef.isSubtype(superType.theTypeDef);
            }
        }
        throw new QueryStateException("Unknown type code: " + (Object)((Object)this.theTypeCode));
    }

    public boolean containsValue(FieldValueImpl value) {
        assert (!value.isEMPTY());
        TypeCode valueCode = ExprType.getTypeCodeForDefCode(value.getType());
        if (!TypeManager.isSubTypeCode(valueCode, this.theTypeCode)) {
            return false;
        }
        switch (this.theTypeCode) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case BINARY: 
            case ANY: 
            case ANY_JSON_ATOMIC: 
            case ANY_ATOMIC: 
            case ANY_RECORD: {
                return true;
            }
            case JSON: 
            case RECORD: 
            case ARRAY: 
            case MAP: 
            case TIMESTAMP: 
            case ENUM: 
            case FIXED_BINARY: {
                FieldDefImpl valDef = value.getDefinition();
                assert (valDef != null);
                return valDef.isSubtype(this.theTypeDef);
            }
        }
        throw new QueryStateException("Unknown type code: " + (Object)((Object)this.theTypeCode));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDef().getDDLString());
        switch (this.theQuantifier) {
            case ONE: {
                break;
            }
            case QSTN: {
                sb.append("?");
                break;
            }
            case PLUS: {
                sb.append("+");
                break;
            }
            case STAR: {
                sb.append("*");
            }
        }
        return sb.toString();
    }

    public void display(StringBuilder sb, QueryFormatter formatter) {
        this.getDef().display(sb, formatter);
        switch (this.theQuantifier) {
            case ONE: {
                break;
            }
            case QSTN: {
                sb.append("?");
                break;
            }
            case PLUS: {
                sb.append("+");
                break;
            }
            case STAR: {
                sb.append("*");
            }
        }
    }

    static TypeCode getTypeCodeForDefCode(FieldDef.Type t) {
        switch (t) {
            case EMPTY: {
                return TypeCode.EMPTY;
            }
            case ANY: {
                return TypeCode.ANY;
            }
            case ANY_ATOMIC: {
                return TypeCode.ANY_ATOMIC;
            }
            case ANY_JSON_ATOMIC: {
                return TypeCode.ANY_JSON_ATOMIC;
            }
            case JSON: {
                return TypeCode.JSON;
            }
            case ANY_RECORD: {
                return TypeCode.ANY_RECORD;
            }
            case INTEGER: {
                return TypeCode.INT;
            }
            case LONG: {
                return TypeCode.LONG;
            }
            case FLOAT: {
                return TypeCode.FLOAT;
            }
            case DOUBLE: {
                return TypeCode.DOUBLE;
            }
            case NUMBER: {
                return TypeCode.NUMBER;
            }
            case STRING: {
                return TypeCode.STRING;
            }
            case TIMESTAMP: {
                return TypeCode.TIMESTAMP;
            }
            case ENUM: {
                return TypeCode.ENUM;
            }
            case BOOLEAN: {
                return TypeCode.BOOLEAN;
            }
            case BINARY: {
                return TypeCode.BINARY;
            }
            case FIXED_BINARY: {
                return TypeCode.FIXED_BINARY;
            }
            case RECORD: {
                return TypeCode.RECORD;
            }
            case ARRAY: {
                return TypeCode.ARRAY;
            }
            case MAP: {
                return TypeCode.MAP;
            }
        }
        throw new QueryStateException("Unknown type code: " + t);
    }

    public static enum TypeCode {
        EMPTY,
        ANY,
        ANY_ATOMIC,
        ANY_JSON_ATOMIC,
        JSON,
        ANY_RECORD,
        NUMBER,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BOOLEAN,
        BINARY,
        FIXED_BINARY,
        ENUM,
        TIMESTAMP,
        RECORD,
        ARRAY,
        MAP;

    }

    public static enum Quantifier {
        ONE,
        QSTN,
        PLUS,
        STAR;


        public String toString() {
            switch (this) {
                case ONE: {
                    return "";
                }
                case QSTN: {
                    return "?";
                }
                case STAR: {
                    return "*";
                }
                case PLUS: {
                    return "+";
                }
            }
            throw new QueryStateException("Unknown quantifier: " + this.name());
        }
    }
}

