/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KVSecurityException;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;
import oracle.kv.impl.api.parallelscan.ShardScanIterator;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.FieldValue;
import oracle.kv.table.TableIteratorOptions;

public class ReceiveIter
extends PlanIter {
    private final PlanIter theInputIter;
    private volatile transient CachedBinaryPlan theSerializedInputIter = null;
    private final FieldDefImpl theInputType;
    private final boolean theMayReturnNULL;
    private final int[] theSortFieldPositions;
    private final SortSpec[] theSortSpecs;
    private final int[] thePrimKeyPositions;
    private final int[] theTupleRegs;
    private final PreparedStatementImpl.DistributionKind theDistributionKind;
    private final RecordValueImpl thePrimaryKey;
    private final String theTableName;
    private final String theNamespace;
    private final PlanIter[] thePushedExternals;
    private final int theNumRegs;
    private final int theNumIters;

    public ReceiveIter(Expr e, int resultReg, int[] tupleRegs, PlanIter input, FieldDefImpl inputType, boolean mayReturnNULL, int[] sortFieldPositions, SortSpec[] sortSpecs, int[] primKeyPositions, PreparedStatementImpl.DistributionKind distrKind, PrimaryKeyImpl primKey, PlanIter[] pushedExternals, int numRegs, int numIters) {
        super(e, resultReg);
        this.theInputIter = input;
        this.theInputType = inputType;
        this.theMayReturnNULL = mayReturnNULL;
        this.theSortFieldPositions = sortFieldPositions;
        this.theSortSpecs = sortSpecs;
        this.thePrimKeyPositions = primKeyPositions;
        this.theTupleRegs = tupleRegs;
        this.theDistributionKind = distrKind;
        if (primKey != null) {
            this.thePrimaryKey = primKey.getDefinition().createRecord();
            this.thePrimaryKey.copyFrom(primKey);
            this.theTableName = primKey.getTable().getFullName();
            this.theNamespace = primKey.getTable().getNamespace();
        } else {
            this.thePrimaryKey = null;
            this.theTableName = null;
            this.theNamespace = null;
        }
        this.thePushedExternals = pushedExternals;
        this.theNumRegs = numRegs;
        this.theNumIters = numIters;
    }

    public ReceiveIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNumRegs = in.readInt();
        this.theNumIters = in.readInt();
        this.theInputIter = ReceiveIter.deserializeIter(in, serialVersion);
        this.theInputType = (FieldDefImpl)ReceiveIter.deserializeFieldDef(in, serialVersion);
        this.theMayReturnNULL = serialVersion < 12 ? true : in.readBoolean();
        this.theSortFieldPositions = ReceiveIter.deserializeIntArray(in);
        this.theSortSpecs = ReceiveIter.deserializeSortSpecs(in, serialVersion);
        this.thePrimKeyPositions = ReceiveIter.deserializeIntArray(in);
        this.theTupleRegs = ReceiveIter.deserializeIntArray(in);
        short ordinal = in.readShort();
        this.theDistributionKind = PreparedStatementImpl.DistributionKind.values()[ordinal];
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        if (this.theTableName != null) {
            this.theNamespace = serialVersion >= 14 ? SerializationUtil.readString(in, serialVersion) : null;
            this.thePrimaryKey = ReceiveIter.deserializeKey(in, serialVersion);
        } else {
            this.thePrimaryKey = null;
            this.theNamespace = null;
        }
        this.thePushedExternals = ReceiveIter.deserializeIters(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theNumRegs);
        out.writeInt(this.theNumIters);
        ReceiveIter.serializeIter(this.theInputIter, out, serialVersion);
        ReceiveIter.serializeFieldDef(this.theInputType, out, serialVersion);
        if (serialVersion >= 12) {
            out.writeBoolean(this.theMayReturnNULL);
        }
        ReceiveIter.serializeIntArray(this.theSortFieldPositions, out);
        ReceiveIter.serializeSortSpecs(this.theSortSpecs, out, serialVersion);
        ReceiveIter.serializeIntArray(this.thePrimKeyPositions, out);
        ReceiveIter.serializeIntArray(this.theTupleRegs, out);
        out.writeShort(this.theDistributionKind.ordinal());
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        if (this.theTableName != null) {
            if (serialVersion >= 14) {
                SerializationUtil.writeString(out, serialVersion, this.theNamespace);
            }
            ReceiveIter.serializeKey(this.thePrimaryKey, out, serialVersion);
        }
        ReceiveIter.serializeIters(this.thePushedExternals, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.RECV;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theInputIter.getTupleRegs();
    }

    private boolean doesSort() {
        return this.theSortFieldPositions != null;
    }

    public byte[] ensureSerializedIter(short serialVersion) {
        CachedBinaryPlan cachedPlan = this.theSerializedInputIter;
        if (cachedPlan != null && cachedPlan.getPlan() != null && cachedPlan.getSerialVersion() == serialVersion) {
            return cachedPlan.thePlan;
        }
        ReceiveIter receiveIter = this;
        synchronized (receiveIter) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(baos);
                PlanIter.serializeIter(this.theInputIter, dataOut, serialVersion);
                byte[] ba = baos.toByteArray();
                this.theSerializedInputIter = cachedPlan = CachedBinaryPlan.create(ba, serialVersion);
                return ba;
            }
            catch (IOException ioe) {
                throw new QueryException(ioe);
            }
        }
    }

    private void ensureIterator(RuntimeControlBlock rcb, ReceiveIterState state) {
        int batchSize;
        if (state.theRemoteResultsIter != null) {
            return;
        }
        KVStoreImpl store = rcb.getStore();
        ExecuteOptions options = rcb.getExecuteOptions();
        int n = batchSize = options != null ? options.getResultsBatchSize() : KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE;
        assert (batchSize != 0);
        switch (this.theDistributionKind) {
            case SINGLE_PARTITION: {
                state.theRemoteResultsIter = this.runOnOnePartition(store, rcb, batchSize);
                break;
            }
            case ALL_PARTITIONS: {
                state.theRemoteResultsIter = this.runOnAllPartitions(store, rcb, batchSize);
                break;
            }
            case ALL_SHARDS: {
                state.theRemoteResultsIter = this.runOnAllShards(store, rcb, batchSize);
                break;
            }
            default: {
                throw new QueryStateException("Unknown distribution kind: " + (Object)((Object)this.theDistributionKind));
            }
        }
        rcb.setTableIterator(state.theRemoteResultsIter);
    }

    private ParallelScanIterator<FieldValueImpl> runOnAllPartitions(KVStoreImpl store, final RuntimeControlBlock rcb, final int batchSize) {
        ExecuteOptions options = rcb.getExecuteOptions();
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (options != null) {
            config.setMaxConcurrentRequests(options.getMaxConcurrentRequests());
        }
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        StoreIteratorParams params = new StoreIteratorParams(dir, batchSize, null, null, Depth.PARENT_AND_DESCENDANTS, rcb.getConsistency(), rcb.getTimeout(), rcb.getTimeUnit(), rcb.getPartitionSet());
        return new PartitionScanIterator<FieldValueImpl>(store, config, params){

            @Override
            protected QueryPartitionStream createStream(RepGroupId groupId, int partitionId) {
                return new QueryPartitionStream(groupId, partitionId);
            }

            @Override
            protected TableQuery generateGetterOp(byte[] resumeKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryPartitionStream
            extends PartitionScanIterator.PartitionStream {
                private long theNumResultsComputed;

                QueryPartitionStream(RepGroupId groupId, int partitionId) {
                    super(groupId, partitionId, null);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(ReceiveIter.this, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, PreparedStatementImpl.DistributionKind.ALL_PARTITIONS, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, batchSize, rcb.getTraceLevel(), this.resumeKey, null, this.theNumResultsComputed, rcb.getMathContext());
                    return storeImpl.makeReadRequest((InternalOperation)op, new PartitionId(this.partitionId), storeIteratorParams.getConsistency(), storeIteratorParams.getTimeout(), storeIteratorParams.getTimeoutUnit());
                }

                @Override
                protected void setResumeKey(Result result) {
                    super.setResumeKey(result);
                    this.theNumResultsComputed += (long)result.getNumRecords();
                    rcb.trace("Received " + result.getNumRecords() + " results from group : " + this.groupId + " partition " + this.partitionId, 1);
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryPartitionStream other = (QueryPartitionStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.this.compareRecords(rec1, rec2);
                    } else {
                        cmp = ReceiveIter.this.compareAtomics(v1, v2, 0);
                    }
                    if (cmp == 0) {
                        return this.partitionId < other.partitionId ? -1 : 1;
                    }
                    return cmp;
                }
            }
        };
    }

    private ParallelScanIterator<FieldValueImpl> runOnOnePartition(final KVStoreImpl store, final RuntimeControlBlock rcb, final int batchSize) {
        final Consistency consistency = rcb.getConsistency();
        final long timeout = rcb.getTimeout();
        final TimeUnit timeUnit = rcb.getTimeUnit();
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        final PartitionId pid = state.thePartitionId;
        return new ParallelScanIterator<FieldValueImpl>(){
            private List<FieldValueImpl> theResults = null;
            private Iterator<FieldValueImpl> theResultsIter = null;
            private byte[] theResumeKey = null;
            private boolean theMoreRemoteResults = true;
            private long theNumResultsComputed;

            @Override
            public boolean hasNext() {
                if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                    return true;
                }
                this.theResultsIter = null;
                if (!this.theMoreRemoteResults) {
                    return false;
                }
                TableQuery op = new TableQuery(ReceiveIter.this, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, PreparedStatementImpl.DistributionKind.SINGLE_PARTITION, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, batchSize, rcb.getTraceLevel(), this.theResumeKey, null, this.theNumResultsComputed, rcb.getMathContext());
                Request req = store.makeReadRequest((InternalOperation)op, pid, consistency, timeout, timeUnit);
                Result result = store.executeRequest(req);
                this.theResults = result.getQueryResults();
                this.theNumResultsComputed += (long)this.theResults.size();
                this.theMoreRemoteResults = result.hasMoreElements();
                if (this.theResults.isEmpty()) {
                    assert (!this.theMoreRemoteResults);
                    return false;
                }
                this.theResumeKey = result.getPrimaryResumeKey();
                this.theResultsIter = this.theResults.iterator();
                return true;
            }

            @Override
            public FieldValueImpl next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.theResultsIter.next();
            }

            @Override
            public void close() {
                this.theResultsIter = null;
                this.theResults = null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<DetailedMetrics> getPartitionMetrics() {
                return Collections.emptyList();
            }

            @Override
            public List<DetailedMetrics> getShardMetrics() {
                return Collections.emptyList();
            }
        };
    }

    private ParallelScanIterator<FieldValueImpl> runOnAllShards(KVStoreImpl store, final RuntimeControlBlock rcb, int batchSize) {
        ExecuteOptions options = rcb.getExecuteOptions();
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        TableIteratorOptions opts = options != null ? options.createTableIteratorOptions(dir) : new TableIteratorOptions(dir, null, 0L, null);
        return new ShardScanIterator<FieldValueImpl>(store, opts, rcb.getShardSet()){

            @Override
            protected QueryShardStream createStream(RepGroupId groupId) {
                return new QueryShardStream(groupId);
            }

            @Override
            protected TableQuery createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryShardStream
            extends ShardScanIterator.ShardStream {
                private long theNumResultsComputed;

                QueryShardStream(RepGroupId groupId) {
                    super(groupId, null, null);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(ReceiveIter.this, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, PreparedStatementImpl.DistributionKind.ALL_SHARDS, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, batchSize, rcb.getTraceLevel(), this.resumePrimaryKey, this.resumeSecondaryKey, this.theNumResultsComputed, rcb.getMathContext());
                    return storeImpl.makeReadRequest((InternalOperation)op, this.groupId, consistency, requestTimeoutMs, TimeUnit.MILLISECONDS);
                }

                @Override
                protected void setResumeKey(Result result) {
                    super.setResumeKey(result);
                    this.theNumResultsComputed += (long)result.getNumRecords();
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryShardStream other = (QueryShardStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.this.compareRecords(rec1, rec2);
                    } else {
                        cmp = ReceiveIter.this.compareAtomics(v1, v2, 0);
                    }
                    if (cmp == 0) {
                        return this.getGroupId().compareTo(other.getGroupId());
                    }
                    return cmp;
                }
            }
        };
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        boolean runOnClient = false;
        String onClient = System.getProperty("test.queryonclient");
        boolean alwaysFalse = false;
        if (onClient != null && !onClient.isEmpty()) {
            runOnClient = true;
            this.theInputIter.open(rcb);
        }
        PartitionId pid = PartitionId.NULL_ID;
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION) {
            TableImpl table = rcb.getMetadataHelper().getTable(this.theNamespace, this.theTableName);
            if (table == null) {
                String nsName = TableMetadata.makeNamespaceName(this.theNamespace, this.theTableName);
                throw new QueryException("Table does not exist: " + nsName, this.getLocation());
            }
            PrimaryKeyImpl primaryKey = table.createPrimaryKey(this.thePrimaryKey);
            if (this.thePushedExternals != null && this.thePushedExternals.length > 0) {
                int size = this.thePushedExternals.length;
                for (int i = 0; i < size; ++i) {
                    PlanIter iter = this.thePushedExternals[i];
                    if (iter == null) continue;
                    iter.open(rcb);
                    iter.next(rcb);
                    FieldValueImpl val = rcb.getRegVal(iter.getResultReg());
                    iter.close(rcb);
                    FieldValueImpl newVal = BaseTableIter.castValueToIndexKey(table, null, i, val, FunctionLib.FuncCode.OP_EQ);
                    if (newVal != val) {
                        if (newVal == BooleanValueImpl.falseValue) {
                            alwaysFalse = true;
                            break;
                        }
                        val = newVal;
                    }
                    String colName = table.getPrimaryKeyColumnName(i);
                    primaryKey.put(colName, (FieldValue)val);
                }
                pid = primaryKey.getPartitionId(rcb.getStore());
            } else {
                pid = primaryKey.getPartitionId(rcb.getStore());
            }
        }
        ReceiveIterState state = new ReceiveIterState(pid, this.thePrimKeyPositions != null, runOnClient);
        rcb.setState(this.theStatePos, state);
        if (this.theTupleRegs != null) {
            TupleValue tuple = new TupleValue((RecordDefImpl)this.theInputType, rcb.getRegisters(), this.theTupleRegs);
            rcb.setRegVal(this.theResultReg, tuple);
        }
        if (alwaysFalse) {
            state.done();
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        try {
            FieldValueImpl res;
            BinaryValueImpl binPrimKey;
            boolean added;
            ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
            if (state.isDone()) {
                return false;
            }
            if (state.theRunOnClient) {
                return this.theInputIter.next(rcb);
            }
            this.ensureIterator(rcb, state);
            do {
                boolean more;
                if (!(more = state.theRemoteResultsIter.hasNext())) {
                    state.done();
                    return false;
                }
                res = state.theRemoteResultsIter.next();
            } while (this.thePrimKeyPositions != null && !(added = state.thePrimKeysSet.add(binPrimKey = this.createBinaryPrimKey(res))));
            if (this.theTupleRegs != null) {
                TupleValue tuple = (TupleValue)rcb.getRegVal(this.theResultReg);
                tuple.toTuple((RecordValueImpl)res, this.doesSort());
            } else if (this.doesSort() && res.isRecord()) {
                ((RecordValueImpl)res).convertEmptyToNull();
                rcb.setRegVal(this.theResultReg, res);
            } else {
                rcb.setRegVal(this.theResultReg, res.isEMPTY() ? NullValueImpl.getInstance() : res);
            }
            return true;
        }
        catch (StoreIteratorException sie) {
            if (sie.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)sie.getCause();
            }
            if (sie.getCause() instanceof QueryException) {
                throw (QueryException)sie.getCause();
            }
            if (sie.getCause() instanceof QueryStateException) {
                throw (QueryStateException)sie.getCause();
            }
            if (sie.getCause() instanceof KVSecurityException) {
                throw (KVSecurityException)sie.getCause();
            }
            throw sie;
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        if (state.theRunOnClient) {
            this.theInputIter.reset(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
        if (state.theRunOnClient) {
            this.theInputIter.close(rcb);
        }
    }

    private BinaryValueImpl createBinaryPrimKey(FieldValueImpl result) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            if (!result.isRecord()) {
                assert (this.thePrimKeyPositions.length == 1);
                this.writeValue(out, result, 0);
            } else {
                for (int i = 0; i < this.thePrimKeyPositions.length; ++i) {
                    FieldValueImpl fval = ((RecordValueImpl)result).get(this.thePrimKeyPositions[i]);
                    this.writeValue(out, fval, i);
                }
            }
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to create binary prim key due to IOException:\n" + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return FieldDefImpl.binaryDef.createBinary(bytes);
    }

    private void writeValue(DataOutput out, FieldValueImpl val, int i) throws IOException {
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, val.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, val.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(val.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(val.getFloat());
                break;
            }
            case STRING: {
                SerializationUtil.writeString(out, SerialVersion.CURRENT, val.getString());
                break;
            }
            case ENUM: {
                out.writeShort(val.asEnum().getIndex());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected type for primary key column : " + val.getType() + ", at result column " + i);
            }
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        if (this.theSortFieldPositions != null) {
            formatter.indent(sb);
            sb.append("Sort Field Positions : ");
            for (i = 0; i < this.theSortFieldPositions.length; ++i) {
                sb.append(this.theSortFieldPositions[i]);
                if (i >= this.theSortFieldPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        if (this.thePrimKeyPositions != null) {
            formatter.indent(sb);
            sb.append("Primary Key Positions : ");
            for (i = 0; i < this.thePrimKeyPositions.length; ++i) {
                sb.append(this.thePrimKeyPositions[i]);
                if (i >= this.thePrimKeyPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        formatter.indent(sb);
        sb.append("DistributionKind : ").append((Object)this.theDistributionKind);
        sb.append(",\n");
        if (this.thePrimaryKey != null && this.thePrimaryKey.size() > 0) {
            formatter.indent(sb);
            sb.append("Primary Key :").append(this.thePrimaryKey);
            sb.append(",\n");
        }
        if (this.thePushedExternals != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("EXTERNAL KEY EXPRS: " + this.thePushedExternals.length);
            for (PlanIter iter : this.thePushedExternals) {
                sb.append("\n");
                if (iter != null) {
                    iter.display(sb, formatter);
                    continue;
                }
                formatter.indent(sb);
                sb.append("null");
            }
            sb.append(",\n\n");
        }
        formatter.indent(sb);
        sb.append("Number of Registers :").append(this.theNumRegs);
        sb.append(",\n");
        formatter.indent(sb);
        sb.append("Number of Iterators :").append(this.theNumIters);
        sb.append(",\n");
        this.theInputIter.display(sb, formatter);
    }

    int compareRecords(RecordValueImpl rec1, RecordValueImpl rec2) {
        for (int i = 0; i < this.theSortFieldPositions.length; ++i) {
            FieldValueImpl v2;
            int pos = this.theSortFieldPositions[i];
            FieldValueImpl v1 = rec1.get(pos);
            int comp = this.compareAtomics(v1, v2 = rec2.get(pos), i);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    int compareAtomics(FieldValueImpl v1, FieldValueImpl v2, int sortPos) {
        int comp = v1.isNull() ? (v2.isNull() ? 0 : (this.theSortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isNull() ? (this.theSortSpecs[sortPos].theNullsFirst ? 1 : -1) : (v1.isEMPTY() ? (v2.isEMPTY() ? 0 : (v2.isJsonNull() ? (this.theSortSpecs[sortPos].theNullsFirst ? 1 : -1) : (this.theSortSpecs[sortPos].theNullsFirst ? -1 : 1))) : (v2.isEMPTY() ? (v1.isJsonNull() ? (this.theSortSpecs[sortPos].theNullsFirst ? -1 : 1) : (this.theSortSpecs[sortPos].theNullsFirst ? 1 : -1)) : (v1.isJsonNull() ? (v1.isJsonNull() ? 0 : (this.theSortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isJsonNull() ? (this.theSortSpecs[sortPos].theNullsFirst ? 1 : -1) : v1.compareTo(v2))))));
        return this.theSortSpecs[sortPos].theIsDesc ? -comp : comp;
    }

    private static class CachedBinaryPlan {
        private byte[] thePlan = null;
        private short theSerialVersion = (short)-1;

        private CachedBinaryPlan(byte[] plan, short serialVersion) {
            this.thePlan = plan;
            this.theSerialVersion = serialVersion;
        }

        public static CachedBinaryPlan create(byte[] plan, short serialVersion) {
            return new CachedBinaryPlan(plan, serialVersion);
        }

        byte[] getPlan() {
            return this.thePlan;
        }

        short getSerialVersion() {
            return this.theSerialVersion;
        }
    }

    private static class ReceiveIterState
    extends PlanIterState {
        final boolean theRunOnClient;
        final PartitionId thePartitionId;
        ParallelScanIterator<FieldValueImpl> theRemoteResultsIter;
        HashSet<BinaryValueImpl> thePrimKeysSet;

        ReceiveIterState(PartitionId pid, boolean eliminateIndexDups, boolean runOnClient) {
            this.theRunOnClient = runOnClient;
            this.thePartitionId = pid;
            if (eliminateIndexDups) {
                this.thePrimKeysSet = new HashSet(1000);
            }
        }

        @Override
        public void done() {
            super.done();
            this.clear();
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            this.clear();
        }

        @Override
        protected void close() {
            super.close();
            this.clear();
        }

        void clear() {
            if (this.theRemoteResultsIter != null) {
                this.theRemoteResultsIter.close();
                this.theRemoteResultsIter = null;
            }
            if (this.thePrimKeysSet != null) {
                this.thePrimKeysSet.clear();
            }
        }
    }
}

