/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.AndOrIter;
import oracle.kv.impl.query.runtime.AnyOpIter;
import oracle.kv.impl.query.runtime.ArithOpIter;
import oracle.kv.impl.query.runtime.ArithUnaryOpIter;
import oracle.kv.impl.query.runtime.ArrayConstrIter;
import oracle.kv.impl.query.runtime.ArrayFilterIter;
import oracle.kv.impl.query.runtime.ArraySliceIter;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.CaseIter;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.CompOpIter;
import oracle.kv.impl.query.runtime.ConcatIter;
import oracle.kv.impl.query.runtime.ConstIter;
import oracle.kv.impl.query.runtime.ExistsIter;
import oracle.kv.impl.query.runtime.ExternalVarRefIter;
import oracle.kv.impl.query.runtime.FieldStepIter;
import oracle.kv.impl.query.runtime.FuncSizeIter;
import oracle.kv.impl.query.runtime.IsNullIter;
import oracle.kv.impl.query.runtime.IsOfTypeIter;
import oracle.kv.impl.query.runtime.MapConstrIter;
import oracle.kv.impl.query.runtime.MapFilterIter;
import oracle.kv.impl.query.runtime.NotIter;
import oracle.kv.impl.query.runtime.PromoteIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.SFWIter;
import oracle.kv.impl.query.runtime.VarRefIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;

public abstract class PlanIter
implements FastExternalizable {
    private static final int NULL_VALUE = -1;
    protected final int theResultReg;
    protected final int theStatePos;
    protected final QueryException.Location theLocation;

    PlanIter(Expr e, int resultReg) {
        this.theResultReg = resultReg;
        this.theStatePos = e.getQCB().incNumPlanIters();
        this.theLocation = e.getLocation();
    }

    protected PlanIter(int statePos, int resultReg, QueryException.Location location) {
        this.theResultReg = resultReg;
        this.theStatePos = statePos;
        this.theLocation = location;
    }

    protected PlanIter(DataInput in, short serialVersion) throws IOException {
        this.theResultReg = in.readInt();
        this.theStatePos = in.readInt();
        this.theLocation = new QueryException.Location(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeInt(this.theResultReg);
        out.writeInt(this.theStatePos);
        out.writeInt(this.theLocation.getStartLine());
        out.writeInt(this.theLocation.getStartColumn());
        out.writeInt(this.theLocation.getEndLine());
        out.writeInt(this.theLocation.getEndColumn());
    }

    public final int getResultReg() {
        return this.theResultReg;
    }

    public QueryException.Location getLocation() {
        return this.theLocation;
    }

    public abstract PlanIterKind getKind();

    public int[] getTupleRegs() {
        return null;
    }

    public boolean producesTuples() {
        return this.getTupleRegs() != null;
    }

    public abstract void open(RuntimeControlBlock var1);

    public abstract boolean next(RuntimeControlBlock var1);

    public abstract void reset(RuntimeControlBlock var1);

    public abstract void close(RuntimeControlBlock var1);

    public boolean hasNext(RuntimeControlBlock rcb) {
        return !rcb.getState(this.theStatePos).isDone();
    }

    public boolean isClosed(RuntimeControlBlock rcb) {
        return rcb.getState(this.theStatePos).isClosed();
    }

    public final String display() {
        StringBuilder sb = new StringBuilder();
        this.display(sb, new QueryFormatter());
        return sb.toString();
    }

    FunctionLib.FuncCode getFuncCode() {
        return null;
    }

    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayName(sb);
        this.displayRegs(sb);
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        this.displayContent(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    void displayName(StringBuilder sb) {
        if (this.getFuncCode() != null) {
            sb.append((Object)this.getFuncCode());
        } else {
            sb.append((Object)this.getKind());
        }
    }

    final void displayRegs(StringBuilder sb) {
        sb.append("(");
        sb.append("[").append(this.theResultReg).append("]");
        int[] tupleRegs = this.getTupleRegs();
        if (tupleRegs != null) {
            sb.append(", ");
            for (int i = 0; i < tupleRegs.length; ++i) {
                sb.append(tupleRegs[i]);
                if (i >= tupleRegs.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
    }

    protected abstract void displayContent(StringBuilder var1, QueryFormatter var2);

    static void serializeIters(PlanIter[] iters, DataOutput out, short serialVersion) throws IOException {
        if (iters == null) {
            out.writeInt(0);
        } else {
            out.writeInt(iters.length);
            for (PlanIter iter : iters) {
                PlanIter.serializeIter(iter, out, serialVersion);
            }
        }
    }

    static PlanIter[] deserializeIters(DataInput in, short serialVersion) throws IOException {
        int numArgs = in.readInt();
        PlanIter[] iters = new PlanIter[numArgs];
        if (numArgs > 0) {
            for (int i = 0; i < numArgs; ++i) {
                iters[i] = PlanIter.deserializeIter(in, serialVersion);
            }
        }
        return iters;
    }

    public static void serializeIter(PlanIter iter, DataOutput out, short serialVersion) throws IOException {
        if (iter == null) {
            out.writeByte(-1);
            return;
        }
        out.writeByte(iter.getKind().ordinal());
        iter.writeFastExternal(out, serialVersion);
    }

    public static PlanIter deserializeIter(DataInput in, short serialVersion) throws IOException {
        byte iterType = in.readByte();
        if (iterType == -1) {
            return null;
        }
        PlanIter iter = null;
        PlanIterKind kind = PlanIterKind.values()[iterType];
        switch (kind) {
            case CONST: {
                iter = new ConstIter(in, serialVersion);
                break;
            }
            case VAR_REF: {
                iter = new VarRefIter(in, serialVersion);
                break;
            }
            case EXTERNAL_VAR_REF: {
                iter = new ExternalVarRefIter(in, serialVersion);
                break;
            }
            case ARRAY_CONSTR: {
                iter = new ArrayConstrIter(in, serialVersion);
                break;
            }
            case MAP_CONSTR: {
                iter = new MapConstrIter(in, serialVersion);
                break;
            }
            case BASE_TABLE: {
                iter = new BaseTableIter(in, serialVersion);
                break;
            }
            case COMP_OP: {
                iter = new CompOpIter(in, serialVersion);
                break;
            }
            case ANY_OP: {
                iter = new AnyOpIter(in, serialVersion);
                break;
            }
            case AND_OR: {
                iter = new AndOrIter(in, serialVersion);
                break;
            }
            case PROMOTE: {
                iter = new PromoteIter(in, serialVersion);
                break;
            }
            case IS_OF_TYPE: {
                iter = new IsOfTypeIter(in, serialVersion);
                break;
            }
            case CAST: {
                iter = new CastIter(in, serialVersion);
                break;
            }
            case FIELD_STEP: {
                iter = new FieldStepIter(in, serialVersion);
                break;
            }
            case MAP_FILTER: {
                iter = new MapFilterIter(in, serialVersion);
                break;
            }
            case ARRAY_SLICE: {
                iter = new ArraySliceIter(in, serialVersion);
                break;
            }
            case ARRAY_FILTER: {
                iter = new ArrayFilterIter(in, serialVersion);
                break;
            }
            case SFW: {
                iter = new SFWIter(in, serialVersion);
                break;
            }
            case FUNC_SIZE: {
                iter = new FuncSizeIter(in, serialVersion);
                break;
            }
            case ARITH_OP: {
                iter = new ArithOpIter(in, serialVersion);
                break;
            }
            case ARITH_UNARY_OP: {
                iter = new ArithUnaryOpIter(in, serialVersion);
                break;
            }
            case CONCAT: {
                iter = new ConcatIter(in, serialVersion);
                break;
            }
            case RECV: {
                iter = new ReceiveIter(in, serialVersion);
                break;
            }
            case CASE: {
                iter = new CaseIter(in, serialVersion);
                break;
            }
            case EXISTS: {
                iter = new ExistsIter(in, serialVersion);
                break;
            }
            case NOT: {
                iter = new NotIter(in, serialVersion);
                break;
            }
            case IS_NULL: {
                iter = new IsNullIter(in, serialVersion);
                break;
            }
            default: {
                throw new QueryStateException("Unknown query iterator kind: " + (Object)((Object)kind));
            }
        }
        return iter;
    }

    void serializeByteArray(byte[] array, DataOutput out) throws IOException {
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        for (byte element : array) {
            out.writeByte(element);
        }
    }

    byte[] deserializeByteArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            byte[] array = new byte[len];
            for (int i = 0; i < len; ++i) {
                array[i] = in.readByte();
            }
            return array;
        }
        return null;
    }

    static void serializeIntArray(int[] array, DataOutput out) throws IOException {
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        for (int element : array) {
            out.writeInt(element);
        }
    }

    static int[] deserializeIntArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            int[] intArray = new int[len];
            for (int i = 0; i < len; ++i) {
                intArray[i] = in.readInt();
            }
            return intArray;
        }
        return null;
    }

    static void serializeStringArray(String[] array, DataOutput out) throws IOException {
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        for (String element : array) {
            out.writeUTF(element);
        }
    }

    static String[] deserializeStringArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            String[] array = new String[len];
            for (int i = 0; i < len; ++i) {
                array[i] = in.readUTF();
            }
            return array;
        }
        return null;
    }

    static void serializeFieldRange(FieldRange range, DataOutput out, short serialVersion) throws IOException {
        if (range != null) {
            out.writeBoolean(true);
            range.writeFastExternal(out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    static FieldRange deserializeFieldRange(DataInput in, short serialVersion) throws IOException {
        boolean hasRange = in.readBoolean();
        if (hasRange) {
            return new FieldRange(in, serialVersion);
        }
        return null;
    }

    public static void serializeFieldDef(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def, out, serialVersion);
    }

    public static FieldDef deserializeFieldDef(DataInput in, short serialVersion) throws IOException {
        return FieldDefSerialization.readFieldDef(in, serialVersion);
    }

    public static void serializeQuantifier(ExprType.Quantifier quantifier, DataOutput out, short serialVersion) throws IOException {
        int code;
        switch (quantifier) {
            case ONE: {
                code = 1;
                break;
            }
            case QSTN: {
                code = 2;
                break;
            }
            case STAR: {
                code = 3;
                break;
            }
            case PLUS: {
                code = 4;
                break;
            }
            default: {
                throw new IOException("Unknown quantifier: " + quantifier.name());
            }
        }
        out.writeShort(code);
    }

    public static ExprType.Quantifier deserializeQuantifier(DataInput in, short serialVersion) throws IOException {
        short code = in.readShort();
        switch (code) {
            case 1: {
                return ExprType.Quantifier.ONE;
            }
            case 2: {
                return ExprType.Quantifier.QSTN;
            }
            case 3: {
                return ExprType.Quantifier.STAR;
            }
            case 4: {
                return ExprType.Quantifier.PLUS;
            }
        }
        throw new IOException("Unknown quantifier code: " + code);
    }

    static void serializeFieldValue(FieldValue value, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeFieldValue(value, true, out, serialVersion);
    }

    static FieldValueImpl deserializeFieldValue(DataInput in, short serialVersion) throws IOException {
        return (FieldValueImpl)FieldValueSerialization.readFieldValue(null, in, serialVersion);
    }

    static void serializeKey(RecordValueImpl value, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeNonNullFieldValue(value, true, true, out, serialVersion);
    }

    static RecordValueImpl deserializeKey(DataInput in, short serialVersion) throws IOException {
        return (RecordValueImpl)FieldValueSerialization.readNonNullFieldValue(null, null, in, serialVersion);
    }

    static void serializeExprType(ExprType type, DataOutput out, short serialVersion) throws IOException {
        if (type != null) {
            out.writeBoolean(true);
            TypeManager.serializeExprType(type, out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    static ExprType deserializeExprType(DataInput in, short serialVersion) throws IOException {
        boolean hasType = in.readBoolean();
        if (hasType) {
            return TypeManager.deserializeExprType(in, serialVersion);
        }
        return null;
    }

    static void serializeSortSpecs(SortSpec[] specs, DataOutput out, short serialVersion) throws IOException {
        if (specs == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(specs.length);
        for (SortSpec spec : specs) {
            spec.writeFastExternal(out, serialVersion);
        }
    }

    static SortSpec[] deserializeSortSpecs(DataInput in, short serialVersion) throws IOException {
        int num = in.readShort();
        if (num == 0) {
            return null;
        }
        SortSpec[] specs = new SortSpec[num];
        for (int i = 0; i < num; ++i) {
            specs[i] = new SortSpec(in, serialVersion);
        }
        return specs;
    }

    public static enum PlanIterKind {
        CONST,
        VAR_REF,
        EXTERNAL_VAR_REF,
        ARRAY_CONSTR,
        BASE_TABLE,
        COMP_OP,
        ANY_OP,
        AND_OR,
        ARITH_OP,
        ARITH_UNARY_OP,
        PROMOTE,
        FIELD_STEP,
        ARRAY_SLICE,
        ARRAY_FILTER,
        SFW,
        FUNC_SIZE,
        FUNC_KEYS,
        RECV,
        CONCAT,
        CASE,
        MAP_CONSTR,
        EXISTS,
        NOT,
        MAP_FILTER,
        IS_OF_TYPE,
        CAST,
        IS_NULL;

    }
}

