/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;

public class CastIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final FieldDefImpl theTargetType;
    private final ExprType.Quantifier theTargetQuantifier;

    public CastIter(Expr e, int resultReg, PlanIter inputIter, FieldDefImpl targetType, ExprType.Quantifier targetQuantifier) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        assert (targetType != null && targetQuantifier != null);
        this.theTargetType = targetType;
        this.theTargetQuantifier = targetQuantifier;
    }

    CastIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInputIter = CastIter.deserializeIter(in, serialVersion);
        this.theTargetType = (FieldDefImpl)CastIter.deserializeFieldDef(in, serialVersion);
        this.theTargetQuantifier = CastIter.deserializeQuantifier(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        CastIter.serializeIter(this.theInputIter, out, serialVersion);
        CastIter.serializeFieldDef(this.theTargetType, out, serialVersion);
        CastIter.serializeQuantifier(this.theTargetQuantifier, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.CAST;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new CastIterState());
        this.theInputIter.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        CastIterState state = (CastIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = state.next(this.theInputIter.next(rcb));
        state.checkQuantifier(this.theTargetType, this.theTargetQuantifier);
        if (!more) {
            state.done();
            return false;
        }
        if (this.theTargetQuantifier == ExprType.Quantifier.ONE || this.theTargetQuantifier == ExprType.Quantifier.QSTN) {
            state.next(this.theInputIter.next(rcb));
            state.checkQuantifier(this.theTargetType, this.theTargetQuantifier);
            state.done();
        }
        this.cast(rcb);
        return true;
    }

    private void cast(RuntimeControlBlock rcb) {
        int inputReg = this.theInputIter.getResultReg();
        FieldValueImpl fromValue = rcb.getRegVal(inputReg);
        FieldValueImpl retValue = CastIter.castValue(fromValue, this.theTargetType, this.theLocation);
        rcb.setRegVal(this.theResultReg, retValue);
    }

    public static FieldValueImpl castValue(FieldValueImpl fromValue, FieldDefImpl targetType, QueryException.Location loc) {
        if (fromValue.isNull()) {
            return NullValueImpl.getInstance();
        }
        FieldDefImpl fromType = fromValue.getDefinition();
        if (targetType.equals(fromType)) {
            return fromValue;
        }
        if (fromValue.isJsonNull()) {
            throw new QueryException("JSON null can not be cast to any other type.", loc);
        }
        String err_msg = null;
        try {
            switch (targetType.getType()) {
                case INTEGER: {
                    switch (fromType.getType()) {
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case NUMBER: {
                            return ((IntegerDefImpl)targetType).createInteger(fromValue.castAsInt());
                        }
                        case STRING: {
                            return ((IntegerDefImpl)targetType).createInteger(Integer.parseInt(fromValue.castAsString()));
                        }
                    }
                    break;
                }
                case LONG: {
                    switch (fromType.getType()) {
                        case FLOAT: 
                        case DOUBLE: 
                        case NUMBER: 
                        case INTEGER: {
                            return ((LongDefImpl)targetType).createLong(fromValue.castAsLong());
                        }
                        case STRING: {
                            return ((LongDefImpl)targetType).createLong(Long.parseLong(fromValue.castAsString()));
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (fromType.getType()) {
                        case LONG: 
                        case DOUBLE: 
                        case NUMBER: 
                        case INTEGER: {
                            return ((FloatDefImpl)targetType).createFloat(fromValue.castAsFloat());
                        }
                        case STRING: {
                            return ((FloatDefImpl)targetType).createFloat(Float.parseFloat(fromValue.castAsString()));
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (fromType.getType()) {
                        case LONG: 
                        case FLOAT: 
                        case NUMBER: 
                        case INTEGER: {
                            return ((DoubleDefImpl)targetType).createDouble(fromValue.castAsDouble());
                        }
                        case STRING: {
                            return ((DoubleDefImpl)targetType).createDouble(Double.parseDouble(fromValue.castAsString()));
                        }
                    }
                    break;
                }
                case NUMBER: {
                    switch (fromType.getType()) {
                        case INTEGER: {
                            return ((NumberDefImpl)targetType).createNumber(fromValue.getInt());
                        }
                        case LONG: {
                            return ((NumberDefImpl)targetType).createNumber(fromValue.getLong());
                        }
                        case FLOAT: {
                            return ((NumberDefImpl)targetType).createNumber(fromValue.getFloat());
                        }
                        case DOUBLE: {
                            return ((NumberDefImpl)targetType).createNumber(fromValue.getDouble());
                        }
                        case STRING: {
                            return ((NumberDefImpl)targetType).createNumber(fromValue.castAsString());
                        }
                    }
                    break;
                }
                case BOOLEAN: {
                    switch (fromType.getType()) {
                        case STRING: {
                            return ((BooleanDefImpl)targetType).createBoolean(Boolean.parseBoolean(fromValue.castAsString()));
                        }
                    }
                    break;
                }
                case ENUM: {
                    switch (fromType.getType()) {
                        case STRING: {
                            return targetType.createEnum(fromValue.castAsString());
                        }
                    }
                    break;
                }
                case BINARY: {
                    switch (fromType.getType()) {
                        case STRING: {
                            return ((BinaryDefImpl)targetType).fromString(fromValue.castAsString());
                        }
                    }
                    break;
                }
                case FIXED_BINARY: {
                    switch (fromType.getType()) {
                        case STRING: {
                            return ((FixedBinaryDefImpl)targetType).fromString(fromValue.castAsString());
                        }
                    }
                    break;
                }
                case TIMESTAMP: {
                    switch (fromType.getType()) {
                        case TIMESTAMP: {
                            int targetPrecision = ((TimestampDefImpl)targetType).getPrecision();
                            return ((TimestampValueImpl)fromValue).castToPrecision(targetPrecision);
                        }
                        case STRING: {
                            return ((TimestampDefImpl)targetType).fromString(fromValue.castAsString());
                        }
                    }
                    break;
                }
                case STRING: {
                    switch (fromType.getType()) {
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case INTEGER: 
                        case TIMESTAMP: 
                        case ENUM: {
                            return ((StringDefImpl)targetType).createString(fromValue.castAsString());
                        }
                        case BINARY: {
                            return ((StringDefImpl)targetType).createString(fromValue.asBinary().toString());
                        }
                        case FIXED_BINARY: {
                            return ((StringDefImpl)targetType).createString(fromValue.asFixedBinary().toString());
                        }
                        case BOOLEAN: {
                            return ((StringDefImpl)targetType).createString(fromValue.asBoolean().get() ? "TRUE" : "FALSE");
                        }
                    }
                    break;
                }
                case ARRAY: {
                    if (fromType.getType() != FieldDef.Type.ARRAY) break;
                    ArrayDefImpl arrayDef = (ArrayDefImpl)targetType;
                    FieldDefImpl elemDef = arrayDef.getElement();
                    ArrayValueImpl toArray = arrayDef.createArray();
                    ArrayValueImpl fromArray = (ArrayValueImpl)fromValue;
                    int size = fromArray.size();
                    for (int i = 0; i < size; ++i) {
                        FieldValueImpl elem = CastIter.castValue(fromArray.get(i), elemDef, loc);
                        toArray.add(elem);
                    }
                    return toArray;
                }
                case MAP: {
                    if (fromType.getType() != FieldDef.Type.MAP) break;
                    MapDefImpl mapDef = (MapDefImpl)targetType;
                    FieldDefImpl elemDef = mapDef.getElement();
                    MapValueImpl toMap = mapDef.createMap();
                    MapValueImpl fromMap = (MapValueImpl)fromValue;
                    for (Map.Entry<String, FieldValue> entry : fromMap.getFields().entrySet()) {
                        FieldValueImpl elem = CastIter.castValue((FieldValueImpl)entry.getValue(), elemDef, loc);
                        toMap.put(entry.getKey(), elem);
                    }
                    return toMap;
                }
                case RECORD: {
                    String fname;
                    int i;
                    if (fromType.getType() != FieldDef.Type.RECORD) break;
                    RecordDefImpl recDef = (RecordDefImpl)targetType;
                    RecordValueImpl dstRec = recDef.createRecord();
                    RecordValueImpl srcRec = (RecordValueImpl)fromValue;
                    int numFields = srcRec.getNumFields();
                    if (numFields != recDef.getNumFields()) break;
                    for (i = 0; i < numFields && (fname = srcRec.getFieldName(i)).equalsIgnoreCase(recDef.getFieldName(i)); ++i) {
                        FieldDefImpl fdef = recDef.getFieldDef(i);
                        FieldValueImpl fval = CastIter.castValue(srcRec.get(i), fdef, loc);
                        dstRec.put(i, (FieldValue)fval);
                    }
                    if (i == numFields) {
                        return dstRec;
                    }
                    break;
                }
                case JSON: 
                case ANY_JSON_ATOMIC: 
                case ANY: 
                case ANY_RECORD: 
                case ANY_ATOMIC: {
                    if (fromType.isSubtype(targetType)) {
                        return fromValue;
                    }
                    break;
                }
                case EMPTY: {
                    break;
                }
                default: {
                    throw new QueryStateException("Unexpected type: " + targetType.getType());
                }
            }
        }
        catch (IllegalArgumentException iae) {
            err_msg = iae.getMessage();
        }
        throw new QueryException("Cannot cast value \n" + fromValue + "\nof type \n" + fromType.getDDLString() + "\nto type \n" + targetType.getDDLString() + (err_msg != null ? "\n" + err_msg : ""), loc);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        CastIterState state = (CastIterState)rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("CAST(\n");
        formatter.incIndent();
        this.theInputIter.display(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("AS ");
        this.theTargetType.display(sb, formatter);
        sb.append((Object)this.theTargetQuantifier);
        sb.append("),\n");
    }

    private static class CastIterState
    extends PlanIterState {
        int state = -1;

        private CastIterState() {
        }

        boolean next(boolean more) {
            block12: {
                block11: {
                    if (!more) break block11;
                    switch (this.state) {
                        case -1: {
                            this.state = 1;
                            break block12;
                        }
                        case 1: {
                            this.state = 2;
                            break block12;
                        }
                        case 0: 
                        case 2: 
                        case 10: 
                        case 20: {
                            break block12;
                        }
                        default: {
                            throw new QueryStateException("Unknown state in CastIter.");
                        }
                    }
                }
                switch (this.state) {
                    case -1: {
                        this.state = 0;
                        break;
                    }
                    case 1: {
                        this.state = 10;
                        break;
                    }
                    case 2: {
                        this.state = 20;
                        break;
                    }
                    case 0: 
                    case 10: 
                    case 20: {
                        break;
                    }
                    default: {
                        throw new QueryStateException("Unknown state in CastIter.");
                    }
                }
            }
            return more;
        }

        void checkQuantifier(FieldDefImpl targetType, ExprType.Quantifier quantifier) {
            switch (this.state) {
                case -1: {
                    throw new QueryStateException("Called checkQuantifier without any next calls.");
                }
                case 0: {
                    if (quantifier == ExprType.Quantifier.PLUS) {
                        throw new QueryException("The input to a cast expression returned an empty result, but the target type requires at least one item. Target type:\n" + targetType.getDDLString() + (Object)((Object)quantifier));
                    }
                    if (quantifier != ExprType.Quantifier.ONE) break;
                    throw new QueryException("The input to a cast expression returned an empty result, but the target type requires exactly one item. Target type:\n" + targetType.getDDLString() + (Object)((Object)quantifier));
                }
                case 1: {
                    break;
                }
                case 10: {
                    break;
                }
                case 2: 
                case 20: {
                    if (quantifier == ExprType.Quantifier.QSTN) {
                        throw new QueryException("The input to a cast expression returned more than one items, but the target type requires at most one item. Target type:\n" + targetType.getDDLString() + (Object)((Object)quantifier));
                    }
                    if (quantifier != ExprType.Quantifier.ONE) break;
                    throw new QueryException("The input to a cast expression returned more than one items, but the target type requires exactly one item. Target type:\n" + targetType.getDDLString() + (Object)((Object)quantifier));
                }
                default: {
                    throw new QueryStateException("Unknown state in CastIter.");
                }
            }
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            this.state = -1;
        }
    }
}

