/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.DdlException;
import oracle.kv.impl.query.compiler.EscapeUtil;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.JsonCollector;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.compiler.parser.KVQLBaseListener;
import oracle.kv.impl.query.compiler.parser.KVQLParser;
import oracle.kv.impl.query.runtime.ArithUnaryOpIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FieldValueFactory;
import oracle.kv.table.TimeToLive;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Translator
extends KVQLBaseListener {
    private static final String ALL_PRIVS = "ALL";
    private final ParseTreeWalker theWalker = new ParseTreeWalker();
    private final TableMetadataHelper theMetadataHelper;
    private final QueryControlBlock theQCB;
    private final FunctionLib theFuncLib;
    private final StaticContext theInitSctx;
    private StaticContext theSctx;
    private final Stack<StaticContext> theScopes = new Stack();
    private final Stack<Expr> theExprs = new Stack();
    private final Stack<String> theColNames = new Stack();
    private final Stack<SortSpec> theSortSpecs = new Stack();
    private final Stack<FieldDefImpl> theTypes = new Stack();
    private final Stack<ExprType.Quantifier> theQuantifiers = new Stack();
    private final Stack<FieldDefHelper> theFields = new Stack();
    private final JsonCollector jsonCollector = new JsonCollector();
    private TableImpl theTable;
    private String theTableAlias;
    private int theExternalVarsCounter;
    private Expr theRootExpr = null;
    private RuntimeException theException;
    private TableBuilderBase theTableBuilder;
    private boolean theInDDL = false;

    public Translator(QueryControlBlock qcb) {
        this.theQCB = qcb;
        this.theMetadataHelper = qcb.getTableMetaHelper();
        this.theSctx = this.theInitSctx = qcb.getInitSctx();
        this.theFuncLib = CompilerAPI.getFuncLib();
        this.theScopes.push(this.theInitSctx);
    }

    public TableImpl getTable() {
        return this.theTable;
    }

    Expr getRootExpr() {
        return this.theRootExpr;
    }

    public RuntimeException getException() {
        return this.theException;
    }

    public void setException(RuntimeException de) {
        this.theException = de;
    }

    public boolean succeeded() {
        return this.theException == null;
    }

    public boolean isQuery() {
        return this.theRootExpr != null;
    }

    public boolean getRemoveData() {
        return true;
    }

    public void translate(ParseTree tree) {
        try {
            this.theWalker.walk(this, tree);
        }
        catch (DdlException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setException(e);
        }
    }

    void pushScope() {
        StaticContext sctx = new StaticContext(this.theScopes.peek());
        this.theScopes.push(sctx);
        this.theSctx = sctx;
    }

    void popScope() {
        this.theScopes.pop();
        this.theSctx = this.theScopes.peek();
    }

    @Override
    public void exitQuery(KVQLParser.QueryContext ctx) {
        this.theRootExpr = this.theExprs.pop();
        assert (this.theRootExpr != null);
        assert (this.theExprs.isEmpty());
        assert (this.theColNames.isEmpty());
        assert (this.theTypes.isEmpty());
    }

    @Override
    public void enterStatement(KVQLParser.StatementContext ctx) {
        if (ctx.query() == null) {
            this.theInDDL = true;
        }
    }

    @Override
    public void exitStatement(KVQLParser.StatementContext ctx) {
        if (ctx.query() == null) {
            this.theInDDL = false;
        }
    }

    @Override
    public void exitVar_decl(KVQLParser.Var_declContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        String varName = ctx.var_name().getText();
        FieldDefImpl varType = this.theTypes.pop();
        if (varName.equals("$element") || varName.equals("$pos") || varName.equals("$key") || varName.equals("$value")) {
            throw new QueryException(varName + " cannot be used as the name of an external variable");
        }
        ExprVar varExpr = new ExprVar(this.theQCB, this.theInitSctx, loc, varName, varType, this.theExternalVarsCounter++);
        this.theSctx.addVariable(varExpr);
    }

    @Override
    public void enterSfw_expr(KVQLParser.Sfw_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        this.theExprs.push(new ExprSFW(this.theQCB, this.theInitSctx, loc));
        this.enterFrom_clause(ctx.from_clause());
    }

    @Override
    public void exitSfw_expr(KVQLParser.Sfw_exprContext ctx) {
        ExprSFW sfw = (ExprSFW)this.theExprs.peek();
        sfw.analyseSort();
        for (int i = 0; i < sfw.getNumVars(); ++i) {
            this.popScope();
        }
    }

    @Override
    public void enterFrom_clause(KVQLParser.From_clauseContext ctx) {
        int i;
        QueryException.Location loc;
        this.pushScope();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        if (sfwExpr.getNumVars() > 0) {
            for (int numParseChildren = ctx.getChildCount(); numParseChildren > 0; --numParseChildren) {
                ctx.removeLastChild();
            }
            return;
        }
        String[] pathName = null;
        if (ctx.table_name() != null) {
            pathName = Translator.getNamePath(ctx.table_name().id_path());
            loc = Translator.getLocation(ctx.table_name());
        } else {
            pathName = new String[]{ctx.SYSTEM_TABLE_NAME().getText()};
            loc = Translator.getLocation(ctx.SYSTEM_TABLE_NAME());
        }
        this.theTable = this.getTable(pathName, loc);
        if (this.theTable == null) {
            throw new QueryException("Table " + Translator.concatPathName(pathName) + " does not exist", loc);
        }
        this.theTableAlias = ctx.tab_alias() == null ? null : ctx.tab_alias().getText();
        String varName = "$$";
        varName = this.theTableAlias == null ? varName + this.theTable.getFullName() : (this.theTableAlias.charAt(0) == '$' ? this.theTableAlias : varName + this.theTableAlias);
        ExprBaseTable tableExpr = new ExprBaseTable(this.theQCB, this.theInitSctx, loc, this.theTable);
        ExprSFW.FromClause fromClause = sfwExpr.addFromClause(tableExpr, varName);
        ExprVar varExpr = fromClause.getVar();
        this.theSctx.addVariable(varExpr);
        int numParseChildren = ctx.getChildCount();
        ArrayList<KVQLParser.ExprContext> exprCtxs = new ArrayList<KVQLParser.ExprContext>(numParseChildren);
        ArrayList<KVQLParser.Var_nameContext> varCtxs = new ArrayList<KVQLParser.Var_nameContext>(numParseChildren);
        for (i = 0; i < numParseChildren; ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof KVQLParser.ExprContext) {
                exprCtxs.add((KVQLParser.ExprContext)child);
                continue;
            }
            if (!(child instanceof KVQLParser.Var_nameContext)) continue;
            varCtxs.add((KVQLParser.Var_nameContext)child);
        }
        assert (exprCtxs.size() == varCtxs.size());
        for (i = 0; i < exprCtxs.size(); ++i) {
            KVQLParser.ExprContext exprCtx = (KVQLParser.ExprContext)exprCtxs.get(i);
            KVQLParser.Var_nameContext varCtx = (KVQLParser.Var_nameContext)varCtxs.get(i);
            varName = varCtx.getText();
            this.theWalker.walk(this, exprCtx);
            Expr domainExpr = this.theExprs.pop();
            fromClause = sfwExpr.addFromClause(domainExpr, varName);
            varExpr = fromClause.getVar();
            this.pushScope();
            this.theSctx.addVariable(varExpr);
        }
    }

    @Override
    public void exitWhere_clause(KVQLParser.Where_clauseContext ctx) {
        Expr condExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addWhereClause(condExpr);
    }

    @Override
    public void enterSelect_clause(KVQLParser.Select_clauseContext ctx) {
        if (ctx.STAR() != null) {
            ExprSFW sfw = (ExprSFW)this.theExprs.peek();
            int numColumns = sfw.getNumVars();
            ArrayList<Expr> colExprs = new ArrayList<Expr>(numColumns);
            ArrayList<String> colNames = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                ExprVar varExpr = sfw.getVar(i);
                colExprs.add(varExpr);
                colNames.add(varExpr.getName().substring(1));
            }
            sfw.addSelectClause(colNames, colExprs, false);
        } else {
            this.theExprs.push(null);
            this.theColNames.push(null);
        }
    }

    @Override
    public void exitSelect_clause(KVQLParser.Select_clauseContext ctx) {
        if (ctx.STAR() != null) {
            return;
        }
        ArrayList<Expr> colExprs = new ArrayList<Expr>();
        ArrayList<String> colNames = new ArrayList<String>();
        Expr expr = this.theExprs.pop();
        String name = this.theColNames.pop();
        boolean hasASclauses = true;
        while (expr != null) {
            if (name == null) {
                hasASclauses = false;
                if (expr.getKind() == Expr.ExprKind.FIELD_STEP) {
                    name = ((ExprFieldStep)expr).getFieldName();
                } else if (expr.getKind() == Expr.ExprKind.VAR) {
                    name = ((ExprVar)expr).getName().substring(1);
                }
            }
            colExprs.add(expr);
            colNames.add(name);
            expr = this.theExprs.pop();
            name = this.theColNames.pop();
        }
        Collections.reverse(colExprs);
        Collections.reverse(colNames);
        for (int i = 0; i < colNames.size(); ++i) {
            if (colNames.get(i) != null) continue;
            colNames.set(i, "Column_" + (i + 1));
        }
        HashSet<String> uniqueColNames = new HashSet<String>(colNames.size());
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = (String)colNames.get(i);
            if (uniqueColNames.add(colName)) continue;
            throw new QueryException("Duplicate column name in SELECT clause: " + colName, colExprs.get(i).getLocation());
        }
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addSelectClause(colNames, colExprs, hasASclauses);
    }

    @Override
    public void enterCol_alias(KVQLParser.Col_aliasContext ctx) {
        if (ctx.id() == null) {
            this.theColNames.push(null);
        } else {
            this.theColNames.push(ctx.id().getText());
        }
    }

    @Override
    public void exitHint(KVQLParser.HintContext ctx) {
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        if (sfwExpr == null && (sfwExpr = (ExprSFW)this.theExprs.get(this.theExprs.size() - 2)) == null) {
            throw new QueryStateException("SFW expr not found.");
        }
        assert (ctx.table_name().id_path() != null) : "Table name missing from  hint at: " + Translator.getLocation(ctx.table_name());
        ExprBaseTable exprBaseTable = sfwExpr.getTableExpr();
        String tableName = ctx.table_name().getText();
        if (!exprBaseTable.getTable().getFullName().equals(tableName)) {
            throw new QueryException("Table name specified in hint doesn't match the table in the FROM statement.", Translator.getLocation(ctx.table_name()));
        }
        if (ctx.PREFER_INDEXES() != null) {
            for (KVQLParser.Index_nameContext indxCtx : ctx.index_name()) {
                String indexName = indxCtx.getText();
                IndexImpl indx = (IndexImpl)exprBaseTable.getTable().getIndex(indexName);
                if (indx == null) continue;
                exprBaseTable.addIndexHint(indx, false, Translator.getLocation(indxCtx));
            }
        } else if (ctx.FORCE_INDEX() != null) {
            for (KVQLParser.Index_nameContext indxCtx : ctx.index_name()) {
                String indexName = indxCtx.getText();
                IndexImpl indx = (IndexImpl)exprBaseTable.getTable().getIndex(indexName);
                if (indx == null) continue;
                exprBaseTable.addIndexHint(indx, true, Translator.getLocation(indxCtx));
            }
        } else if (ctx.PREFER_PRIMARY_INDEX() != null) {
            exprBaseTable.addIndexHint(null, false, Translator.getLocation(ctx));
        } else if (ctx.FORCE_PRIMARY_INDEX() != null) {
            exprBaseTable.addIndexHint(null, true, Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterOrderby_clause(KVQLParser.Orderby_clauseContext ctx) {
        this.theExprs.push(null);
        this.theSortSpecs.push(null);
    }

    @Override
    public void exitOrderby_clause(KVQLParser.Orderby_clauseContext ctx) {
        ArrayList<Expr> sortExprs = new ArrayList<Expr>();
        ArrayList<SortSpec> sortSpecs = new ArrayList<SortSpec>();
        Expr expr = this.theExprs.pop();
        SortSpec spec = this.theSortSpecs.pop();
        while (expr != null) {
            sortExprs.add(expr);
            sortSpecs.add(spec);
            expr = this.theExprs.pop();
            spec = this.theSortSpecs.pop();
        }
        Collections.reverse(sortExprs);
        Collections.reverse(sortSpecs);
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addSortClause(sortExprs, sortSpecs);
    }

    @Override
    public void enterSort_spec(KVQLParser.Sort_specContext ctx) {
        boolean desc = false;
        boolean nullsFirst = false;
        if (ctx.DESC() != null) {
            desc = true;
        }
        if (ctx.NULLS() == null) {
            nullsFirst = desc;
        } else if (ctx.FIRST() != null) {
            nullsFirst = true;
        }
        this.theSortSpecs.push(new SortSpec(desc, nullsFirst));
    }

    @Override
    public void exitLimit_clause(KVQLParser.Limit_clauseContext ctx) {
        Expr limitExpr = null;
        limitExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addLimit(limitExpr);
    }

    @Override
    public void exitOffset_clause(KVQLParser.Offset_clauseContext ctx) {
        Expr offsetExpr = null;
        offsetExpr = this.theExprs.pop();
        ExprSFW sfwExpr = (ExprSFW)this.theExprs.peek();
        sfwExpr.addOffset(offsetExpr);
    }

    @Override
    public void enterCase_expr(KVQLParser.Case_exprContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitCase_expr(KVQLParser.Case_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        if (ctx.ELSE() != null) {
            exprs.add(this.theExprs.pop());
        }
        Expr expr = this.theExprs.pop();
        while (expr != null) {
            exprs.add(expr);
            expr = this.theExprs.pop();
        }
        Collections.reverse(exprs);
        ExprCase caseExpr = new ExprCase(this.theQCB, this.theInitSctx, loc, exprs);
        this.theExprs.push(caseExpr);
    }

    @Override
    public void exitOr_expr(KVQLParser.Or_exprContext ctx) {
        ExprFuncCall fnCall;
        if (ctx.OR() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        if (op1.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op1;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_OR) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op1);
            }
        } else {
            args.add(op1);
        }
        if (op2.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op2;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_OR) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op2);
            }
        } else {
            args.add(op2);
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_OR), args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitAnd_expr(KVQLParser.And_exprContext ctx) {
        ExprFuncCall fnCall;
        if (ctx.AND() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        if (op1.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op1;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_AND) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op1);
            }
        } else {
            args.add(op1);
        }
        if (op2.getKind() == Expr.ExprKind.FUNC_CALL) {
            fnCall = (ExprFuncCall)op2;
            if (fnCall.getFunction().getCode() == FunctionLib.FuncCode.OP_AND) {
                this.flattenAndOrArgs(fnCall.getChildren(), args);
            } else {
                args.add(op2);
            }
        } else {
            args.add(op2);
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_AND), args);
        this.theExprs.push(expr);
    }

    private void flattenAndOrArgs(Expr.ExprIter children, List<Expr> args) {
        while (children.hasNext()) {
            Expr arg = children.next();
            children.remove(false);
            args.add(arg);
        }
    }

    @Override
    public void exitNot_expr(KVQLParser.Not_exprContext ctx) {
        if (ctx.NOT() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NOT), args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitIs_null_expr(KVQLParser.Is_null_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        if (ctx.NULL() == null) {
            return;
        }
        Function func = ctx.NOT() != null ? this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_IS_NOT_NULL) : this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_IS_NULL);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitExists_expr(KVQLParser.Exists_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EXISTS);
        Expr input = this.theExprs.pop();
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(input);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void exitComp_expr(KVQLParser.Comp_exprContext ctx) {
        Function func;
        QueryException.Location loc = Translator.getLocation(ctx);
        KVQLParser.Comp_opContext cmpctx = ctx.comp_op();
        KVQLParser.Any_opContext anyctx = ctx.any_op();
        if (cmpctx == null && anyctx == null) {
            return;
        }
        Expr op2 = this.theExprs.pop();
        Expr op1 = this.theExprs.pop();
        if (cmpctx != null) {
            if (cmpctx.EQ() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EQ);
            } else if (cmpctx.NEQ() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NEQ);
            } else if (cmpctx.GT() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GT);
            } else if (cmpctx.GTE() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GE);
            } else if (cmpctx.LT() != null) {
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LT);
            } else {
                if (cmpctx.LTE() == null) throw new QueryException("Unexpected comparison operator: " + cmpctx.getText(), loc);
                func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LE);
            }
        } else if (anyctx.EQ_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_EQ_ANY);
        } else if (anyctx.NEQ_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_NEQ_ANY);
        } else if (anyctx.GT_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GT_ANY);
        } else if (anyctx.GTE_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_GE_ANY);
        } else if (anyctx.LT_ANY() != null) {
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LT_ANY);
        } else {
            if (anyctx.LTE_ANY() == null) throw new QueryException("Unexpected comparison operator: " + anyctx.getText(), loc);
            func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_LE_ANY);
        }
        ArrayList<Expr> args = new ArrayList<Expr>(2);
        args.add(op1);
        args.add(op2);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void enterQuantified_type_def(KVQLParser.Quantified_type_defContext ctx) {
        if (ctx.PLUS() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.PLUS);
        } else if (ctx.STAR() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.STAR);
        } else if (ctx.QUESTION_MARK() != null) {
            this.theQuantifiers.push(ExprType.Quantifier.QSTN);
        } else {
            this.theQuantifiers.push(ExprType.Quantifier.ONE);
        }
    }

    @Override
    public void exitIs_of_type_expr(KVQLParser.Is_of_type_exprContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr input = this.theExprs.pop();
        boolean notFlag = ctx.NOT() != null;
        int numTypes = ctx.quantified_type_def().size();
        ArrayList<FieldDef> types = new ArrayList<FieldDef>(numTypes);
        ArrayList<ExprType.Quantifier> quantifiers = new ArrayList<ExprType.Quantifier>(numTypes);
        ArrayList<Boolean> onlyFlags = new ArrayList<Boolean>(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            FieldDefImpl typeDef = this.theTypes.pop();
            ExprType.Quantifier typeQuantifier = this.theQuantifiers.pop();
            types.add(typeDef);
            quantifiers.add(typeQuantifier);
            onlyFlags.add(ctx.ONLY(i) != null);
        }
        ExprIsOfType expr = new ExprIsOfType(this.theQCB, this.theInitSctx, loc, input, notFlag, types, quantifiers, onlyFlags);
        this.theExprs.push(expr);
    }

    @Override
    public void exitCast_expr(KVQLParser.Cast_exprContext ctx) {
        Expr input = this.theExprs.pop();
        FieldDefImpl typeDefImpl = this.theTypes.pop();
        ExprType.Quantifier typeQuantifier = this.theQuantifiers.pop();
        Expr expr = ExprCast.create(this.theQCB, this.theInitSctx, Translator.getLocation(ctx), input, typeDefImpl, typeQuantifier);
        this.theExprs.push(expr);
    }

    @Override
    public void exitAdd_expr(KVQLParser.Add_exprContext ctx) {
        if (ctx.PLUS().isEmpty() && ctx.MINUS().isEmpty()) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_ADD_SUB);
        String operations = "";
        ArrayList<Expr> args = new ArrayList<Expr>(ctx.getChildCount() / 2 + 2);
        for (int c = ctx.getChildCount() - 1; c >= 0; c -= 2) {
            ParseTree pt = ctx.getChild(c);
            if (pt instanceof RuleNode) {
                Expr op = this.theExprs.pop();
                if (c > 0) {
                    ParseTree ptOp = ctx.getChild(c - 1);
                    if (ptOp instanceof TerminalNode) {
                        int tokenId = ((TerminalNode)ptOp).getSymbol().getType();
                        if (tokenId == 129) {
                            operations = "+" + operations;
                            args.add(op);
                            continue;
                        }
                        if (tokenId == 130) {
                            operations = "-" + operations;
                            args.add(op);
                            continue;
                        }
                        throw new QueryStateException("Unexpected arithmetic operator in: " + ctx.getText());
                    }
                    throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
                }
                operations = "+" + operations;
                args.add(op);
                continue;
            }
            throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
        }
        Collections.reverse(args);
        StringValueImpl ops = FieldDefImpl.stringDef.createString(operations);
        args.add(new ExprConst(this.theQCB, this.theInitSctx, loc, ops));
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitMultiply_expr(KVQLParser.Multiply_exprContext ctx) {
        if (ctx.STAR().isEmpty() && ctx.DIV().isEmpty()) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_MULT_DIV);
        String operations = "";
        ArrayList<Expr> args = new ArrayList<Expr>(ctx.getChildCount() / 2 + 2);
        for (int c = ctx.getChildCount() - 1; c >= 0; c -= 2) {
            ParseTree pt = ctx.getChild(c);
            if (pt instanceof RuleNode) {
                Expr op = this.theExprs.pop();
                if (c > 0) {
                    ParseTree ptOp = ctx.getChild(c - 1);
                    if (ptOp instanceof TerminalNode) {
                        int tokenId = ((TerminalNode)ptOp).getSymbol().getType();
                        if (tokenId == 113) {
                            operations = "*" + operations;
                            args.add(op);
                            continue;
                        }
                        if (tokenId == 131) {
                            operations = "/" + operations;
                            args.add(op);
                            continue;
                        }
                        throw new QueryStateException("Unexpected arithmetic operator in: " + ctx.getText());
                    }
                    throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
                }
                operations = "*" + operations;
                args.add(op);
                continue;
            }
            throw new QueryStateException("Unexpected arithmetic parse tree in: " + ctx.getText());
        }
        Collections.reverse(args);
        StringValueImpl ops = FieldDefImpl.stringDef.createString(operations);
        args.add(new ExprConst(this.theQCB, this.theInitSctx, loc, ops));
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitUnary_expr(KVQLParser.Unary_exprContext ctx) {
        FieldValueImpl val;
        if (ctx.MINUS() == null) {
            return;
        }
        QueryException.Location loc = Translator.getLocation(ctx);
        Function func = this.theFuncLib.getFunc(FunctionLib.FuncCode.OP_ARITH_UNARY);
        Expr op = this.theExprs.pop();
        if (op.getKind() == Expr.ExprKind.CONST && !(val = ((ExprConst)op).getValue()).isNull()) {
            FieldValueImpl negVal = ArithUnaryOpIter.getNegativeOfValue(val, Translator.getLocation(ctx));
            ExprConst expr = new ExprConst(this.theQCB, this.theInitSctx, loc, negVal);
            this.theExprs.push(expr);
            return;
        }
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(op);
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, args);
        this.theExprs.push(expr);
    }

    @Override
    public void exitPath_expr(KVQLParser.Path_exprContext ctx) {
        ExprType declaredType;
        Expr expr = this.theExprs.peek();
        if (!expr.isStepExpr()) {
            return;
        }
        IndexExpr ie = IndexExpr.create(expr);
        if (ie != null && expr.getType().isAnyJson() && (declaredType = ie.getIndexDeclaredType()) != null) {
            ExprType t = TypeManager.createType(TypeManager.ANY_JATOMIC_ONE(), declaredType.getQuantifier());
            expr.setType(t);
        }
    }

    @Override
    public void enterMap_field_step(KVQLParser.Map_field_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprVar ctxItemVar = null;
        ExprFieldStep step = new ExprFieldStep(this.theQCB, this.theInitSctx, loc, inputExpr);
        if (ctx.id() == null && ctx.string() == null) {
            ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            step.addCtxVars(ctxItemVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitMap_field_step(KVQLParser.Map_field_stepContext ctx) {
        String fieldName = null;
        Expr fieldNameExpr = null;
        if (ctx.id() != null) {
            fieldName = ctx.id().getText();
        } else if (ctx.string() != null) {
            fieldName = Translator.stripFirstLast(ctx.string().getText());
            fieldName = EscapeUtil.inlineEscapedChars(fieldName);
        } else {
            fieldNameExpr = this.theExprs.pop();
        }
        ExprFieldStep step = (ExprFieldStep)this.theExprs.peek();
        step.addFieldNameExpr(fieldName, fieldNameExpr);
        if (ctx.id() == null && ctx.string() == null) {
            this.popScope();
        }
    }

    @Override
    public void enterMap_filter_step(KVQLParser.Map_filter_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ExprMapFilter.FilterKind kind = ctx.KEYS() != null ? ExprMapFilter.FilterKind.KEYS : ExprMapFilter.FilterKind.VALUES;
        Expr inputExpr = this.theExprs.pop();
        ExprMapFilter step = new ExprMapFilter(this.theQCB, this.theInitSctx, loc, kind, inputExpr);
        if (ctx.expr() != null) {
            ExprVar ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            ExprVar ctxElemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$value", step);
            ExprVar ctxKeyVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$key", step);
            step.addCtxVars(ctxItemVar, ctxElemVar, ctxKeyVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
            this.theSctx.addVariable(ctxElemVar);
            this.theSctx.addVariable(ctxKeyVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitMap_filter_step(KVQLParser.Map_filter_stepContext ctx) {
        Expr predExpr = null;
        if (ctx.expr() != null) {
            predExpr = this.theExprs.pop();
            ExprMapFilter filterStep = (ExprMapFilter)this.theExprs.peek();
            filterStep.addPredExpr(predExpr);
            this.popScope();
        }
    }

    @Override
    public void enterArray_slice_step(KVQLParser.Array_slice_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprVar ctxItemVar = null;
        ExprArraySlice step = new ExprArraySlice(this.theQCB, this.theInitSctx, loc, inputExpr);
        assert (ctx.COLON() != null);
        ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
        step.addCtxVars(ctxItemVar);
        this.pushScope();
        this.theSctx.addVariable(ctxItemVar);
        this.theExprs.push(step);
    }

    @Override
    public void exitArray_slice_step(KVQLParser.Array_slice_stepContext ctx) {
        Expr lowExpr = null;
        Expr highExpr = null;
        List<KVQLParser.ExprContext> args = ctx.expr();
        if (args.size() == 2) {
            highExpr = this.theExprs.pop();
            lowExpr = this.theExprs.pop();
        } else if (args.size() == 1) {
            if (ctx.getChild(1) instanceof KVQLParser.ExprContext) {
                lowExpr = this.theExprs.pop();
            } else {
                highExpr = this.theExprs.pop();
            }
        }
        ExprArraySlice step = (ExprArraySlice)this.theExprs.peek();
        step.addBoundaryExprs(lowExpr, highExpr);
        this.popScope();
    }

    @Override
    public void enterArray_filter_step(KVQLParser.Array_filter_stepContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        Expr inputExpr = this.theExprs.pop();
        ExprArrayFilter step = new ExprArrayFilter(this.theQCB, this.theInitSctx, loc, inputExpr);
        if (ctx.expr() != null) {
            ExprVar ctxItemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$", step);
            ExprVar ctxElemVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$element", step);
            ExprVar ctxElemPosVar = new ExprVar(this.theQCB, this.theInitSctx, loc, "$pos", step);
            step.addCtxVars(ctxItemVar, ctxElemVar, ctxElemPosVar);
            this.pushScope();
            this.theSctx.addVariable(ctxItemVar);
            this.theSctx.addVariable(ctxElemVar);
            this.theSctx.addVariable(ctxElemPosVar);
        }
        this.theExprs.push(step);
    }

    @Override
    public void exitArray_filter_step(KVQLParser.Array_filter_stepContext ctx) {
        ExprArrayFilter filterStep;
        Expr predExpr = null;
        if (ctx.expr() != null) {
            predExpr = this.theExprs.pop();
            filterStep = (ExprArrayFilter)this.theExprs.pop();
            filterStep.addPredExpr(predExpr);
            this.popScope();
        } else {
            filterStep = (ExprArrayFilter)this.theExprs.pop();
        }
        Expr expr = filterStep.convertToSliceStep();
        this.theExprs.push(expr);
    }

    @Override
    public void enterArray_constructor(KVQLParser.Array_constructorContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitArray_constructor(KVQLParser.Array_constructorContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        ExprArrayConstr arrayConstr = new ExprArrayConstr(this.theQCB, this.theInitSctx, loc, inputs, false);
        this.theExprs.push(arrayConstr);
    }

    @Override
    public void enterMap_constructor(KVQLParser.Map_constructorContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitMap_constructor(KVQLParser.Map_constructorContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        ExprMapConstr mapConstr = new ExprMapConstr(this.theQCB, this.theInitSctx, loc, inputs);
        this.theExprs.push(mapConstr);
    }

    @Override
    public void enterFunc_call(KVQLParser.Func_callContext ctx) {
        this.theExprs.push(null);
    }

    @Override
    public void exitFunc_call(KVQLParser.Func_callContext ctx) {
        QueryException.Location loc = Translator.getLocation(ctx);
        ArrayList<Expr> inputs = new ArrayList<Expr>();
        Expr input = this.theExprs.pop();
        while (input != null) {
            inputs.add(input);
            input = this.theExprs.pop();
        }
        Collections.reverse(inputs);
        Function func = this.theSctx.findFunction(ctx.id().getText(), inputs.size());
        if (func == null) {
            throw new QueryException("Could not find function with name " + ctx.id().getText() + " and arity " + inputs.size(), Translator.getLocation(ctx.id()));
        }
        Expr expr = ExprFuncCall.create(this.theQCB, this.theInitSctx, loc, func, inputs);
        this.theExprs.push(expr);
    }

    @Override
    public void exitVar_ref(KVQLParser.Var_refContext ctx) {
        String varName = ctx.getText();
        ExprVar varExpr = this.theScopes.peek().findVariable(varName);
        if (varExpr == null) {
            throw new QueryException(" Unknown variable " + varName, Translator.getLocation(ctx));
        }
        this.theExprs.push(varExpr);
    }

    @Override
    public void exitColumn_ref(KVQLParser.Column_refContext ctx) {
        String tableName;
        KVQLParser.IdContext col;
        QueryException.Location loc = Translator.getLocation(ctx);
        List<KVQLParser.IdContext> ids = ctx.id();
        if (ids.size() == 1) {
            col = ids.get(0);
            tableName = this.theTable.getFullName();
        } else {
            assert (ids.size() == 2);
            col = ids.get(1);
            tableName = ids.get(0).getText();
            if (!(tableName.equalsIgnoreCase(this.theTable.getFullName()) || this.theTableAlias != null && tableName.equals(this.theTableAlias))) {
                throw new QueryException("Unknown table: " + tableName, Translator.getLocation(ids.get(0)));
            }
            tableName = this.theTable.getFullName();
        }
        if (this.theTable.getField(col.getText()) == null) {
            throw new QueryException("Table: " + tableName + " has no column named " + col.getText(), Translator.getLocation(col));
        }
        String varName = this.theTableAlias == null ? "$$" + tableName : (this.theTableAlias.charAt(0) == '$' ? this.theTableAlias : "$$" + this.theTableAlias);
        ExprVar varExpr = this.theScopes.peek().findVariable(varName);
        ExprFieldStep expr = new ExprFieldStep(this.theQCB, this.theInitSctx, loc, varExpr, col.getText());
        this.theExprs.push(expr);
    }

    @Override
    public void exitConst_expr(KVQLParser.Const_exprContext ctx) {
        FieldValue value;
        QueryException.Location loc;
        block13: {
            loc = Translator.getLocation(ctx);
            try {
                Object val;
                if (ctx.number() != null) {
                    String numberString = ctx.number().getText();
                    try {
                        if (ctx.number().INT() != null) {
                            Long val2 = Long.parseLong(numberString);
                            value = Integer.MIN_VALUE <= val2 && val2 <= Integer.MAX_VALUE ? FieldDefImpl.integerDef.createInteger(val2.intValue()) : FieldDefImpl.longDef.createLong(val2);
                            break block13;
                        }
                        if (ctx.number().FLOAT() != null) {
                            Double val3 = Double.parseDouble(numberString);
                            value = FieldDefImpl.doubleDef.createDouble(val3);
                            break block13;
                        }
                        numberString = Translator.stripNumericLetter(numberString);
                        value = FieldValueFactory.createNumber(new BigDecimal(numberString));
                    }
                    catch (NumberFormatException nfe) {
                        value = FieldValueFactory.createNumber(new BigDecimal(numberString));
                    }
                    break block13;
                }
                if (ctx.TRUE() != null) {
                    val = Boolean.parseBoolean(ctx.TRUE().getText());
                    value = FieldDefImpl.booleanDef.createBoolean((Boolean)val);
                } else if (ctx.FALSE() != null) {
                    val = Boolean.parseBoolean(ctx.FALSE().getText());
                    value = FieldDefImpl.booleanDef.createBoolean((Boolean)val);
                } else if (ctx.NULL() != null) {
                    value = NullJsonValueImpl.getInstance();
                } else {
                    val = Translator.stripFirstLast(ctx.string().getText());
                    val = EscapeUtil.inlineEscapedChars((String)val);
                    value = FieldDefImpl.stringDef.createString((String)val);
                }
            }
            catch (NumberFormatException nfe) {
                throw new QueryException("Invalid numeric literal: " + ctx.getText(), loc);
            }
        }
        ExprConst constExpr = new ExprConst(this.theQCB, this.theInitSctx, loc, (FieldValueImpl)value);
        this.theExprs.push(constExpr);
    }

    private static String stripNumericLetter(String numberString) {
        char lastChar = numberString.charAt(numberString.length() - 1);
        if (lastChar == 'n' || lastChar == 'N') {
            numberString = numberString.substring(0, numberString.length() - 1);
        }
        return numberString;
    }

    @Override
    public void enterAny(KVQLParser.AnyContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type Any not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyDef());
    }

    @Override
    public void enterAnyAtomic(KVQLParser.AnyAtomicContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyAtomic not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyAtomicDef());
    }

    @Override
    public void enterAnyJsonAtomic(KVQLParser.AnyJsonAtomicContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyJsonAtomic not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyJsonAtomicDef());
    }

    @Override
    public void enterJSON(KVQLParser.JSONContext ctx) {
        this.theTypes.push(FieldDefFactory.createJsonDef());
    }

    @Override
    public void enterAnyRecord(KVQLParser.AnyRecordContext ctx) {
        if (this.theInDDL) {
            throw new QueryException("Type AnyRecord not allowed in DDL statements.", Translator.getLocation(ctx));
        }
        this.theTypes.push(FieldDefFactory.createAnyRecordDef());
    }

    @Override
    public void enterRecord(KVQLParser.RecordContext ctx) {
        this.theFields.push(null);
    }

    @Override
    public void exitRecord(KVQLParser.RecordContext ctx) {
        FieldMap fieldMap = new FieldMap();
        FieldDefHelper field = this.theFields.pop();
        assert (field != null);
        while (field != null) {
            this.setNameForNamedType(field.getName(), field.getType());
            field.validate();
            fieldMap.put(field.getName(), field.getType(), field.getNullable(), field.getDefault());
            field = this.theFields.pop();
        }
        fieldMap.reverseFieldOrder();
        RecordDefImpl type = FieldDefFactory.createRecordDef(fieldMap, null);
        this.theTypes.push(type);
    }

    @Override
    public void enterField_def(KVQLParser.Field_defContext ctx) {
        String name = ctx.id().getText();
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            comment = EscapeUtil.inlineEscapedChars(comment);
        }
        FieldDefHelper field = new FieldDefHelper(name, comment, Translator.getLocation(ctx));
        this.theFields.push(field);
    }

    @Override
    public void exitField_def(KVQLParser.Field_defContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        FieldDefHelper field = this.theFields.peek();
        field.setType(this.theTypes.pop());
        assert (this.theTypes.empty());
    }

    @Override
    public void enterDefault_value(KVQLParser.Default_valueContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        FieldDefHelper fieldDefHelper = this.theFields.peek();
        FieldDefImpl type = this.theTypes.peek();
        fieldDefHelper.setType(type);
        String strval = ctx.getChild(1).getText();
        fieldDefHelper.setDefault(strval, ctx);
    }

    @Override
    public void enterNot_null(KVQLParser.Not_nullContext ctx) {
        assert (!this.theFields.empty());
        FieldDefHelper field = this.theFields.peek();
        FieldDefImpl type = this.theTypes.peek();
        field.setType(type);
        field.setNullable(false, ctx);
    }

    @Override
    public void exitArray(KVQLParser.ArrayContext ctx) {
        FieldDefImpl elemType = this.theTypes.pop();
        this.setNameForNamedType(null, elemType);
        ArrayDefImpl type = FieldDefFactory.createArrayDef(elemType);
        this.theTypes.push(type);
    }

    @Override
    public void exitMap(KVQLParser.MapContext ctx) {
        FieldDefImpl elemType = this.theTypes.pop();
        this.setNameForNamedType(null, elemType);
        MapDefImpl type = FieldDefFactory.createMapDef(elemType);
        this.theTypes.push(type);
    }

    @Override
    public void enterInt(KVQLParser.IntContext ctx) {
        boolean isLong = ctx.integer_def().LONG_T() != null;
        FieldDefImpl type = isLong ? FieldDefFactory.createLongDef() : FieldDefFactory.createIntegerDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterFloat(KVQLParser.FloatContext ctx) {
        boolean isNumber;
        boolean isDouble = ctx.float_def().DOUBLE_T() != null;
        boolean bl = isNumber = ctx.float_def().NUMBER_T() != null;
        DoubleDefImpl type = isDouble ? FieldDefFactory.createDoubleDef() : (isNumber ? FieldDefFactory.createNumberDef() : FieldDefFactory.createFloatDef());
        this.theTypes.push(type);
    }

    @Override
    public void enterStringT(KVQLParser.StringTContext ctx) {
        StringDefImpl type = FieldDefFactory.createStringDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterEnum(KVQLParser.EnumContext ctx) {
        String[] values = Translator.makeIdArray(ctx.enum_def().id_list().id());
        try {
            EnumDefImpl type = FieldDefFactory.createEnumDef(values);
            this.theTypes.push(type);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid ENUM type '" + ctx.enum_def().getText() + "': " + iae.getMessage();
            throw new QueryException(msg, Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterBoolean(KVQLParser.BooleanContext ctx) {
        BooleanDefImpl type = FieldDefFactory.createBooleanDef();
        this.theTypes.push(type);
    }

    @Override
    public void enterBinary(KVQLParser.BinaryContext ctx) {
        int size = 0;
        if (ctx.binary_def().INT() != null) {
            size = Integer.parseInt(ctx.binary_def().INT().getText());
        }
        FieldDefImpl type = size == 0 ? FieldDefFactory.createBinaryDef() : FieldDefFactory.createFixedBinaryDef(size);
        this.theTypes.push(type);
    }

    @Override
    public void enterTimestamp(KVQLParser.TimestampContext ctx) {
        int precision = -1;
        if (ctx.timestamp_def().INT() != null) {
            precision = Integer.parseInt(ctx.timestamp_def().INT().getText());
            if (precision > 9) {
                throw new QueryException("Timestamp precision exceeds the maximum allowed precision (9)");
            }
            if (precision < 0) {
                throw new QueryException("Timestamp precision cannot be a negative number");
            }
        }
        if (this.theInDDL && precision < 0) {
            throw new QueryException("In DDL statements there is no default precision for the Timestamp type. The precision must be explicitly specified.", Translator.getLocation(ctx));
        }
        if (precision < 0) {
            precision = 9;
        }
        TimestampDefImpl type = FieldDefFactory.createTimestampDef(precision);
        this.theTypes.push(type);
    }

    private void setNameForNamedType(String name, FieldDef type) {
        if (type.isRecord()) {
            ((RecordDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("RECORD")));
        } else if (type.isEnum()) {
            ((EnumDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("ENUM")));
        } else if (type.isFixedBinary()) {
            ((FixedBinaryDefImpl)type).setName(name != null ? name : this.theQCB.generateFieldName(this.getNamePrefix("FIXEDBINARY")));
        }
    }

    private String getNamePrefix(String name) {
        if (this.theTableBuilder instanceof TableEvolver) {
            return name + ((TableEvolver)this.theTableBuilder).getTableVersion();
        }
        return name;
    }

    @Override
    public void enterCreate_table_statement(KVQLParser.Create_table_statementContext ctx) {
        String name = Translator.getPathLeaf(ctx.table_name().id_path());
        TableImpl parentTable = this.getParentTable(ctx.table_name().id_path());
        KVQLParser.Table_defContext table_def = ctx.table_def();
        if (table_def.key_def() == null || table_def.key_def().isEmpty() || table_def.key_def().size() > 1) {
            throw new QueryException("Table definition must contain a single primary key definition", Translator.getLocation(table_def));
        }
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            EscapeUtil.inlineEscapedChars(comment);
        }
        this.theFields.push(null);
        this.theTableBuilder = TableBuilder.createTableBuilder(this.theQCB.getNamespace(), name, comment, parentTable);
    }

    @Override
    public void exitCreate_table_statement(KVQLParser.Create_table_statementContext ctx) {
        assert (this.theTableBuilder != null);
        assert (!this.theFields.isEmpty());
        assert (this.theTypes.isEmpty());
        ArrayList<FieldDefHelper> fields = new ArrayList<FieldDefHelper>();
        FieldDefHelper field = this.theFields.pop();
        assert (field != null);
        while (field != null) {
            this.setNameForNamedType(field.getName(), field.getType());
            field.validate();
            fields.add(field);
            field = this.theFields.pop();
        }
        assert (this.theFields.isEmpty());
        Collections.reverse(fields);
        for (FieldDefHelper field1 : fields) {
            this.theTableBuilder.addField(field1.getName(), (FieldDef)field1.getType(), (Boolean)field1.getNullable(), field1.getDefault());
        }
        try {
            this.theTableBuilder.validatePrimaryKeyFields();
            this.theTable = this.theTableBuilder.buildTable();
            this.theTableBuilder = null;
        }
        catch (Exception e) {
            throw new QueryException("Cannot build table: " + e.getMessage());
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE TABLE must execute on a server");
        }
        boolean ifNotExists = ctx.EXISTS() != null;
        this.theQCB.getStatementFactory().createTable(this.theTable, ifNotExists);
    }

    @Override
    public void enterKey_def(KVQLParser.Key_defContext ctx) {
        assert (this.theTableBuilder != null);
        try {
            if (ctx.shard_key_def() == null) {
                if (ctx.id_list_with_size() == null) {
                    throw new QueryException("PRIMARY KEY must contain a list of fields", Translator.getLocation(ctx));
                }
                this.makePrimaryKey(ctx.id_list_with_size().id_with_size());
                return;
            }
            List<KVQLParser.Id_with_sizeContext> shardKeyList = ctx.shard_key_def().id_list_with_size().id_with_size();
            this.theTableBuilder.shardKey(Translator.makeKeyIdArray(shardKeyList));
            ArrayList<KVQLParser.Id_with_sizeContext> pkey = new ArrayList<KVQLParser.Id_with_sizeContext>(shardKeyList);
            if (ctx.id_list_with_size() != null) {
                pkey.addAll(ctx.id_list_with_size().id_with_size());
            }
            this.makePrimaryKey(pkey);
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
        }
    }

    @Override
    public void enterTtl_def(KVQLParser.Ttl_defContext ctx) {
        KVQLParser.DurationContext duration = ctx.duration();
        QueryException.Location loc = Translator.getLocation(ctx);
        try {
            this.theTableBuilder.setDefaultTTL(TimeToLive.createTimeToLive(Integer.parseInt(duration.INT().getText()), Translator.convertToTimeUnit(duration.TIME_UNIT())));
        }
        catch (NumberFormatException nfex) {
            String msg = "Invalid TTL value: " + duration.INT().getText() + " in " + duration.INT().getText() + " " + duration.TIME_UNIT().getText();
            throw new QueryException(msg, loc);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid TTL Unit: " + (Object)((Object)Translator.convertToTimeUnit(duration.TIME_UNIT())) + " in " + duration.INT().getText() + " " + duration.TIME_UNIT().getText();
            throw new QueryException(msg, loc);
        }
    }

    @Override
    public void enterAlter_table_statement(KVQLParser.Alter_table_statementContext ctx) {
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("ALTER TABLE must execute on a server");
        }
        String[] pathName = Translator.getNamePath(ctx.table_name().id_path());
        TableImpl currentTable = this.getTable(pathName, Translator.getLocation(ctx));
        if (currentTable == null) {
            Translator.noTable(pathName, Translator.getLocation(ctx));
        }
        this.theTableBuilder = TableEvolver.createTableEvolver(currentTable);
    }

    @Override
    public void exitAlter_table_statement(KVQLParser.Alter_table_statementContext ctx) {
        TableEvolver evolver = (TableEvolver)this.theTableBuilder;
        try {
            this.theTable = evolver.evolveTable();
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
        }
        this.theTableBuilder = null;
        this.theQCB.getStatementFactory().evolveTable(this.theTable);
    }

    @Override
    public void enterAdd_field_statement(KVQLParser.Add_field_statementContext ctx) {
        String comment = null;
        if (ctx.comment() != null) {
            comment = Translator.stripFirstLast(ctx.comment().string().getText());
            comment = EscapeUtil.inlineEscapedChars(comment);
        }
        FieldDefHelper fieldDefHelper = new FieldDefHelper("", comment, Translator.getLocation(ctx));
        this.theFields.push(fieldDefHelper);
    }

    @Override
    public void exitAdd_field_statement(KVQLParser.Add_field_statementContext ctx) {
        assert (!this.theFields.empty());
        assert (!this.theTypes.empty());
        assert (this.theTableBuilder != null);
        TableEvolver evolver = (TableEvolver)this.theTableBuilder;
        FieldDefHelper field = this.theFields.pop();
        field.setType(this.theTypes.pop());
        assert (this.theTypes.empty());
        List<String> stepsList = Translator.getStepsList(ctx.schema_path());
        String newFieldName = stepsList.get(stepsList.size() - 1);
        this.setNameForNamedType(newFieldName, field.getType());
        field.validate();
        try {
            evolver.addField(new TablePath(evolver.getFieldMap(), stepsList), (FieldDef)field.getType(), (Boolean)field.getNullable(), field.getDefault());
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), Translator.getLocation(ctx.schema_path()));
        }
    }

    @Override
    public void exitDrop_field_statement(KVQLParser.Drop_field_statementContext ctx) {
        List<String> stepsList = Translator.getStepsList(ctx.schema_path());
        try {
            this.theTableBuilder.removeField(new TablePath(this.theTableBuilder.getFieldMap(), stepsList));
        }
        catch (IllegalArgumentException iae) {
            throw new QueryException(iae.getMessage(), iae, Translator.getLocation(ctx.schema_path()));
        }
    }

    static List<String> getStepsList(KVQLParser.Schema_pathContext schemaPathCtx) {
        KVQLParser.Init_schema_path_stepContext initStep = schemaPathCtx.init_schema_path_step();
        List<KVQLParser.Schema_path_stepContext> steps = schemaPathCtx.schema_path_step();
        ArrayList<String> stepsList = new ArrayList<String>(steps.size() + 1);
        stepsList.add(initStep.id().getText());
        if (initStep.LBRACK() != null) {
            assert (initStep.RBRACK() != null);
            for (TerminalNode t : initStep.LBRACK()) {
                stepsList.add("[]");
            }
        }
        for (KVQLParser.Schema_path_stepContext step : steps) {
            if (step.id() != null) {
                stepsList.add(step.id().getText());
                if (step.LBRACK() == null) continue;
                assert (step.RBRACK() != null);
                for (TerminalNode t : step.LBRACK()) {
                    stepsList.add("[]");
                }
                continue;
            }
            stepsList.add("values()");
        }
        return stepsList;
    }

    @Override
    public void enterModify_field_statement(KVQLParser.Modify_field_statementContext ctx) {
        throw new QueryException("MODIFY is not supported at this time", Translator.getLocation(ctx));
    }

    @Override
    public void enterDrop_table_statement(KVQLParser.Drop_table_statementContext ctx) {
        boolean ifExists = ctx.EXISTS() != null;
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        this.theTable = this.getTableSilently(tableName);
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP TABLE must execute on a server");
        }
        this.theQCB.getStatementFactory().dropTable(Translator.concatPathName(tableName), this.theTable, ifExists, this.getRemoveData());
    }

    @Override
    public void enterCreate_index_statement(KVQLParser.Create_index_statementContext ctx) {
        boolean ifNotExists = ctx.EXISTS() != null;
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        String[] fieldNames = Translator.getIndexFieldNames(ctx.index_path_list().index_path());
        FieldDef.Type[] typeArray = Translator.makeTypeArray(ctx.index_path_list().index_path());
        String indexComment = null;
        if (ctx.comment() != null) {
            indexComment = Translator.stripFirstLast(ctx.comment().string().getText());
            indexComment = EscapeUtil.inlineEscapedChars(indexComment);
        }
        this.theTable = this.getTable(tableName, Translator.getLocation(ctx));
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().createIndex(Translator.concatPathName(tableName), this.theTable, indexName, fieldNames, typeArray, null, null, indexComment, ifNotExists, false);
    }

    private static String[] getIndexFieldNames(List<KVQLParser.Index_pathContext> list) {
        String[] names = new String[list.size()];
        int i = 0;
        for (KVQLParser.Index_pathContext path : list) {
            boolean isValues;
            if (path.path_type() == null) {
                names[i] = path.getText();
            } else if (path.name_path() != null) {
                names[i] = path.name_path().getText();
            } else if (path.values_expr() != null) {
                names[i] = path.values_expr().getText();
            } else {
                throw new IllegalStateException("Unexpected name path in index statement: " + path.getText());
            }
            boolean isMapKeys = path.keys_expr() != null;
            boolean bl = isValues = path.values_expr() != null;
            if (!isMapKeys && !isValues) {
                ++i;
                continue;
            }
            String indexPath = names[i];
            String lower = indexPath.toLowerCase();
            if (lower.startsWith("keys(") || lower.startsWith("keyof(") || lower.startsWith("elementof(")) {
                StringBuilder sb = new StringBuilder();
                int lp = lower.indexOf(40);
                int rp = lower.indexOf(41, lp);
                sb.append(indexPath.substring(lp + 1, rp));
                sb.append(".");
                sb.append(isValues ? "values()" : "keys()");
                if (indexPath.length() > rp + 1) {
                    sb.append(indexPath.substring(rp + 1, indexPath.length()));
                }
                names[i] = sb.toString();
            }
            ++i;
        }
        return names;
    }

    private static FieldDef.Type[] makeTypeArray(List<KVQLParser.Index_pathContext> list) {
        FieldDef.Type[] types = new FieldDef.Type[list.size()];
        boolean returnTypes = false;
        int i = 0;
        for (KVQLParser.Index_pathContext path : list) {
            KVQLParser.Path_typeContext typeExpr = path.path_type();
            if (typeExpr == null) {
                types[i] = null;
            } else {
                returnTypes = true;
                if (typeExpr.INTEGER_T() != null) {
                    types[i] = FieldDef.Type.INTEGER;
                } else if (typeExpr.LONG_T() != null) {
                    types[i] = FieldDef.Type.LONG;
                } else if (typeExpr.DOUBLE_T() != null) {
                    types[i] = FieldDef.Type.DOUBLE;
                } else if (typeExpr.NUMBER_T() != null) {
                    types[i] = FieldDef.Type.NUMBER;
                } else if (typeExpr.STRING_T() != null) {
                    types[i] = FieldDef.Type.STRING;
                } else if (typeExpr.BOOLEAN_T() != null) {
                    types[i] = FieldDef.Type.BOOLEAN;
                }
            }
            ++i;
        }
        if (returnTypes) {
            return types;
        }
        return null;
    }

    @Override
    public void enterDrop_index_statement(KVQLParser.Drop_index_statementContext ctx) {
        boolean ifExists = ctx.EXISTS() != null;
        boolean override = ctx.OVERRIDE() != null;
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        this.theTable = this.getTableSilently(tableName);
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().dropIndex(Translator.concatPathName(tableName), this.theTable, indexName, ifExists, override);
    }

    @Override
    public void exitCreate_text_index_statement(KVQLParser.Create_text_index_statementContext ctx) {
        boolean ifNotExists = false;
        if (ctx.EXISTS() != null) {
            ifNotExists = true;
        }
        boolean override = ctx.OVERRIDE() != null;
        String[] tableName = Translator.getNamePath(ctx.table_name().id_path());
        String indexName = ctx.index_name().id().getText();
        IndexImpl.AnnotatedField[] ftsFieldArray = this.makeFtsFieldArray(ctx.fts_field_list().fts_path_list().fts_path());
        HashMap<String, String> properties = new HashMap<String, String>();
        KVQLParser.Es_propertiesContext propCtx = ctx.es_properties();
        if (propCtx != null) {
            for (KVQLParser.Es_property_assignmentContext prop : propCtx.es_property_assignment()) {
                if (prop.ES_SHARDS() != null) {
                    String shards = prop.INT().toString();
                    if (Integer.parseInt(shards) < 1) {
                        throw new DdlException("The " + prop.ES_SHARDS() + " value of " + shards + " is not allowed.");
                    }
                    properties.put(prop.ES_SHARDS().toString(), shards);
                    continue;
                }
                if (prop.ES_REPLICAS() == null) continue;
                String replicas = prop.INT().toString();
                if (Integer.parseInt(replicas) < 0) {
                    throw new DdlException("The " + prop.ES_REPLICAS() + " value of " + replicas + " is not allowed.");
                }
                properties.put(prop.ES_REPLICAS().toString(), replicas);
            }
        }
        if (properties.isEmpty()) {
            properties = null;
        }
        String indexComment = null;
        if (ctx.comment() != null) {
            indexComment = Translator.stripFirstLast(ctx.comment().string().getText());
            indexComment = EscapeUtil.inlineEscapedChars(indexComment);
        }
        this.theTable = this.getTable(tableName, Translator.getLocation(ctx));
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE FULLTEXT INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().createIndex(Translator.concatPathName(tableName), this.theTable, indexName, null, null, ftsFieldArray, properties, indexComment, ifNotExists, override);
    }

    @Override
    public void enterDescribe_statement(KVQLParser.Describe_statementContext ctx) {
        boolean describeAsJson;
        String[] tableName = null;
        String indexName = null;
        ArrayList<List<String>> schemaPaths = null;
        if (ctx.table_name() != null) {
            tableName = Translator.getNamePath(ctx.table_name().id_path());
            if (this.getTable(tableName, Translator.getLocation(ctx.table_name())) == null) {
                Translator.noTable(tableName, Translator.getLocation(ctx.table_name()));
            }
            if (ctx.schema_path_list() != null) {
                List<KVQLParser.Schema_pathContext> pathCtxList = ctx.schema_path_list().schema_path();
                schemaPaths = new ArrayList<List<String>>(pathCtxList.size());
                for (KVQLParser.Schema_pathContext spctx : pathCtxList) {
                    schemaPaths.add(Translator.getStepsList(spctx));
                }
            }
            if (ctx.index_name() != null) {
                indexName = ctx.index_name().id().getText();
            }
        }
        boolean bl = describeAsJson = ctx.JSON() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DESCRIBE TABLE must execute on a server");
        }
        this.theQCB.getStatementFactory().describeTable(Translator.concatPathName(tableName), indexName, schemaPaths, describeAsJson);
    }

    @Override
    public void enterShow_statement(KVQLParser.Show_statementContext ctx) {
        boolean describeAsJson;
        if (this.getShowUserOrRoleOp(ctx)) {
            return;
        }
        String[] tableName = null;
        boolean showTables = false;
        boolean showIndexes = false;
        if (ctx.table_name() != null) {
            tableName = Translator.getNamePath(ctx.table_name().id_path());
            if (this.getTable(tableName, Translator.getLocation(ctx.table_name())) == null) {
                Translator.noTable(tableName, Translator.getLocation(ctx.table_name()));
            }
            if (ctx.INDEXES() != null) {
                showIndexes = true;
            }
        } else {
            assert (ctx.TABLES() != null);
            showTables = true;
        }
        boolean bl = describeAsJson = ctx.JSON() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("SHOW TABLE|INDEX must execute on a server");
        }
        this.theQCB.getStatementFactory().showTableOrIndex(Translator.concatPathName(tableName), showTables, showIndexes, describeAsJson);
    }

    @Override
    public void exitCreate_user_statement(KVQLParser.Create_user_statementContext ctx) {
        boolean isEnabled;
        boolean passExpired;
        String userName = Translator.getIdentifierName(ctx.create_user_identified_clause(), "user");
        boolean isExternal = ctx.create_user_identified_clause().IDENTIFIED_EXTERNALLY() != null;
        boolean isAdmin = ctx.ADMIN() != null;
        boolean bl = passExpired = ctx.create_user_identified_clause().PASSWORD_EXPIRE() != null;
        boolean bl2 = ctx.account_lock() != null ? !Translator.isAccountLocked(ctx.account_lock()) : (isEnabled = true);
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE USER must execute on a server");
        }
        if (!isExternal) {
            Long pwdLifetimeInMillis = ctx.create_user_identified_clause().password_lifetime() == null ? null : Long.valueOf(Translator.resolvePassLifeTime(ctx.create_user_identified_clause().password_lifetime()));
            String plainPass = Translator.resolvePlainPassword(ctx.create_user_identified_clause().identified_clause());
            if (passExpired) {
                pwdLifetimeInMillis = -1L;
            }
            this.theQCB.getStatementFactory().createUser(userName, isEnabled, isAdmin, plainPass, pwdLifetimeInMillis);
        } else {
            this.theQCB.getStatementFactory().createExternalUser(userName, isEnabled, isAdmin);
        }
    }

    @Override
    public void exitCreate_role_statement(KVQLParser.Create_role_statementContext ctx) {
        String roleName = Translator.getIdentifierName(ctx.id(), "role");
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("CREATE ROLE must execute on a server");
        }
        this.theQCB.getStatementFactory().createRole(roleName);
    }

    @Override
    public void exitAlter_user_statement(KVQLParser.Alter_user_statementContext ctx) {
        Boolean isEnabled;
        Long pwdLifetimeInMillis;
        String userName = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
        boolean retainPassword = false;
        String newPass = null;
        KVQLParser.Reset_password_clauseContext resetPassCtx = ctx.reset_password_clause();
        if (resetPassCtx != null) {
            newPass = Translator.resolvePlainPassword(resetPassCtx.identified_clause());
            retainPassword = resetPassCtx.RETAIN_CURRENT_PASSWORD() != null;
        }
        boolean clearRetainedPassword = ctx.CLEAR_RETAINED_PASSWORD() != null;
        boolean passwordExpire = ctx.PASSWORD_EXPIRE() != null;
        Long l = pwdLifetimeInMillis = ctx.password_lifetime() == null ? null : Long.valueOf(Translator.resolvePassLifeTime(ctx.password_lifetime()));
        Boolean bl = ctx.account_lock() != null ? Boolean.valueOf(!Translator.isAccountLocked(ctx.account_lock())) : (isEnabled = null);
        if (passwordExpire) {
            pwdLifetimeInMillis = -1L;
        }
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("ALTER USER must execute on a server");
        }
        this.theQCB.getStatementFactory().alterUser(userName, isEnabled, newPass, retainPassword, clearRetainedPassword, pwdLifetimeInMillis);
    }

    @Override
    public void exitDrop_user_statement(KVQLParser.Drop_user_statementContext ctx) {
        boolean cascade;
        String userName = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
        boolean bl = cascade = ctx.CASCADE() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP USER must execute on a server");
        }
        this.theQCB.getStatementFactory().dropUser(userName, cascade);
    }

    @Override
    public void exitDrop_role_statement(KVQLParser.Drop_role_statementContext ctx) {
        String roleName = Translator.getIdentifierName(ctx.id(), "role");
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("DROP ROLE must execute on a server");
        }
        this.theQCB.getStatementFactory().dropRole(roleName);
    }

    @Override
    public void exitGrant_statement(KVQLParser.Grant_statementContext ctx) {
        HashSet<String> privSet = new HashSet<String>();
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("GRANT must execute on a server");
        }
        if (ctx.grant_roles() != null) {
            String[] roleNames = Translator.makeIdArray(ctx.grant_roles().id_list().id());
            if (ctx.grant_roles().principal().USER() != null) {
                assert (ctx.grant_roles().principal().ROLE() == null);
                String grantee = Translator.getIdentifierName(ctx.grant_roles().principal().identifier_or_string(), "user");
                this.theQCB.getStatementFactory().grantRolesToUser(grantee, roleNames);
            } else {
                String grantee = Translator.getIdentifierName(ctx.grant_roles().principal().id(), "role");
                this.theQCB.getStatementFactory().grantRolesToRole(grantee, roleNames);
            }
            return;
        }
        if (ctx.grant_system_privileges() != null) {
            List<KVQLParser.Priv_itemContext> privItemList = ctx.grant_system_privileges().sys_priv_list().priv_item();
            Translator.getPrivSet(privItemList, privSet);
            String roleName = Translator.getIdentifierName(ctx.grant_system_privileges().id(), "role");
            this.theQCB.getStatementFactory().grantPrivileges(roleName, null, privSet);
            return;
        }
        if (ctx.grant_object_privileges() != null) {
            if (!ctx.grant_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<KVQLParser.Priv_itemContext> privItemList = ctx.grant_object_privileges().obj_priv_list().priv_item();
                Translator.getPrivSet(privItemList, privSet);
            }
            String roleName = Translator.getIdentifierName(ctx.grant_object_privileges().id(), "role");
            String[] onTable = Translator.getNamePath(ctx.grant_object_privileges().object().table_name().id_path());
            this.theQCB.getStatementFactory().grantPrivileges(roleName, Translator.concatPathName(onTable), privSet);
        }
    }

    @Override
    public void exitRevoke_statement(KVQLParser.Revoke_statementContext ctx) {
        HashSet<String> privSet = new HashSet<String>();
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("REVOKE must execute on a server");
        }
        if (ctx.revoke_roles() != null) {
            String[] roleNames = Translator.makeIdArray(ctx.revoke_roles().id_list().id());
            if (ctx.revoke_roles().principal().USER() != null) {
                assert (ctx.revoke_roles().principal().ROLE() == null);
                String revokee = Translator.getIdentifierName(ctx.revoke_roles().principal().identifier_or_string(), "user");
                this.theQCB.getStatementFactory().revokeRolesFromUser(revokee, roleNames);
            } else {
                String revokee = Translator.getIdentifierName(ctx.revoke_roles().principal().id(), "role");
                this.theQCB.getStatementFactory().revokeRolesFromRole(revokee, roleNames);
            }
            return;
        }
        if (ctx.revoke_system_privileges() != null) {
            List<KVQLParser.Priv_itemContext> privItemList = ctx.revoke_system_privileges().sys_priv_list().priv_item();
            Translator.getPrivSet(privItemList, privSet);
            String roleName = Translator.getIdentifierName(ctx.revoke_system_privileges().id(), "role");
            this.theQCB.getStatementFactory().revokePrivileges(roleName, null, privSet);
            return;
        }
        if (ctx.revoke_object_privileges() != null) {
            if (!ctx.revoke_object_privileges().obj_priv_list().ALL().isEmpty()) {
                privSet.add(ALL_PRIVS);
            } else {
                List<KVQLParser.Priv_itemContext> privItemList = ctx.revoke_object_privileges().obj_priv_list().priv_item();
                Translator.getPrivSet(privItemList, privSet);
            }
            String roleName = Translator.getIdentifierName(ctx.revoke_object_privileges().id(), "role");
            String[] onTable = Translator.getNamePath(ctx.revoke_object_privileges().object().table_name().id_path());
            this.theQCB.getStatementFactory().revokePrivileges(roleName, Translator.concatPathName(onTable), privSet);
        }
    }

    @Override
    public void exitJsonAtom(KVQLParser.JsonAtomContext ctx) {
        this.jsonCollector.exitJsonAtom(ctx);
    }

    @Override
    public void exitJsonArrayValue(KVQLParser.JsonArrayValueContext ctx) {
        this.jsonCollector.exitJsonArrayValue(ctx);
    }

    @Override
    public void exitJsonObjectValue(KVQLParser.JsonObjectValueContext ctx) {
        this.jsonCollector.exitJsonObjectValue(ctx);
    }

    @Override
    public void exitJsonPair(KVQLParser.JsonPairContext ctx) {
        this.jsonCollector.exitJsonPair(ctx);
    }

    @Override
    public void exitArrayOfJsonValues(KVQLParser.ArrayOfJsonValuesContext ctx) {
        this.jsonCollector.exitArrayOfJsonValues(ctx);
    }

    @Override
    public void exitEmptyJsonArray(KVQLParser.EmptyJsonArrayContext ctx) {
        this.jsonCollector.exitEmptyJsonArray(ctx);
    }

    @Override
    public void exitJsonObject(KVQLParser.JsonObjectContext ctx) {
        this.jsonCollector.exitJsonObject(ctx);
    }

    @Override
    public void exitEmptyJsonObject(KVQLParser.EmptyJsonObjectContext ctx) {
        this.jsonCollector.exitEmptyJsonObject(ctx);
    }

    @Override
    public void exitJson_text(KVQLParser.Json_textContext ctx) {
        this.jsonCollector.exitJson_text(ctx);
    }

    private boolean getShowUserOrRoleOp(KVQLParser.Show_statementContext ctx) {
        boolean asJson;
        boolean bl = asJson = ctx.JSON() != null;
        if (this.theQCB.getStatementFactory() == null) {
            throw new DdlException("SHOW must execute on a server");
        }
        if (ctx.identifier_or_string() != null && ctx.USER() != null) {
            String name = Translator.getIdentifierName(ctx.identifier_or_string(), "user");
            this.theQCB.getStatementFactory().showUser(name, asJson);
            return true;
        }
        if (ctx.id() != null && ctx.ROLE() != null) {
            String name = Translator.getIdentifierName(ctx.id(), "role");
            this.theQCB.getStatementFactory().showRole(name, asJson);
            return true;
        }
        if (ctx.USERS() != null) {
            this.theQCB.getStatementFactory().showUser(null, asJson);
            return true;
        }
        if (ctx.ROLES() != null) {
            this.theQCB.getStatementFactory().showRole(null, asJson);
            return true;
        }
        return false;
    }

    private static boolean isAccountLocked(KVQLParser.Account_lockContext ctx) {
        if (ctx.LOCK() != null) {
            assert (ctx.UNLOCK() == null);
            return true;
        }
        return false;
    }

    private static String getIdentifierName(KVQLParser.IdContext ctx, String idType) {
        if (ctx != null) {
            return ctx.getText();
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String getIdentifierName(KVQLParser.Identifier_or_stringContext ctx, String idType) {
        String result;
        if (ctx.id() != null) {
            return Translator.getIdentifierName(ctx.id(), idType);
        }
        if (ctx.string() != null && !(result = EscapeUtil.inlineEscapedChars(Translator.stripFirstLast(ctx.string().getText()))).equals("")) {
            return result;
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String getIdentifierName(KVQLParser.Create_user_identified_clauseContext ctx, String idType) {
        String result;
        if (ctx.identified_clause() != null && ctx.id() != null) {
            return Translator.getIdentifierName(ctx.id(), idType);
        }
        if (ctx.IDENTIFIED_EXTERNALLY() != null && ctx.string() != null && !(result = EscapeUtil.inlineEscapedChars(Translator.stripFirstLast(ctx.string().getText()))).equals("")) {
            return result;
        }
        throw new QueryException("Invalid empty name of " + idType, Translator.getLocation(ctx));
    }

    private static String resolvePlainPassword(KVQLParser.Identified_clauseContext ctx) {
        String passStr = ctx.by_password().string().getText();
        if (passStr.isEmpty() || passStr.length() <= 2) {
            throw new QueryException("Invalid empty password", Translator.getLocation(ctx));
        }
        return passStr;
    }

    private static long resolvePassLifeTime(KVQLParser.Password_lifetimeContext ctx) {
        long timeValue;
        try {
            timeValue = Integer.parseInt(ctx.duration().INT().getText());
            if (timeValue <= 0L) {
                throw new QueryException("Time value must not be zero or negative", Translator.getLocation(ctx));
            }
        }
        catch (NumberFormatException nfe) {
            throw new QueryException("Invalid numeric value for time value", Translator.getLocation(ctx));
        }
        TimeUnit timeUnit = Translator.convertToTimeUnit(ctx.duration().TIME_UNIT());
        return TimeUnit.MILLISECONDS.convert(timeValue, timeUnit);
    }

    private static TimeUnit convertToTimeUnit(TerminalNode node) {
        String unitStr = node.getText();
        try {
            return TimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            try {
                return DDLTimeUnit.valueOf(unitStr.toUpperCase(Locale.ENGLISH)).getUnit();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new QueryException("Unrecognized time unit " + unitStr, Translator.getLocation(node));
            }
        }
    }

    private static String[] getNamePath(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        String[] result = new String[steps.size()];
        int i = 0;
        for (KVQLParser.IdContext step : steps) {
            result[i] = step.getText();
            ++i;
        }
        return result;
    }

    private static String[] getParentPath(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        if (steps.size() == 1) {
            return null;
        }
        String[] result = new String[steps.size() - 1];
        int i = 0;
        for (KVQLParser.IdContext step : steps) {
            result[i] = step.getText();
            if (++i != steps.size() - 1) continue;
            break;
        }
        return result;
    }

    private static String getPathLeaf(KVQLParser.Id_pathContext ctx) {
        List<KVQLParser.IdContext> steps = ctx.id();
        return steps.get(steps.size() - 1).getText();
    }

    private static String concatPathName(String[] pathName) {
        if (pathName == null) {
            return null;
        }
        int numSteps = pathName.length;
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < numSteps; ++i) {
            name.append(pathName[i]);
            if (i >= numSteps - 1) continue;
            name.append('.');
        }
        return name.toString();
    }

    private TableImpl getParentTable(KVQLParser.Id_pathContext ctx) {
        String[] parentPath = Translator.getParentPath(ctx);
        if (parentPath == null) {
            return null;
        }
        TableImpl parent = this.getTable(parentPath, Translator.getLocation(ctx));
        if (parent == null) {
            String fullPath = Translator.concatPathName(Translator.getNamePath(ctx));
            Translator.noParentTable(Translator.concatPathName(parentPath), fullPath, Translator.getLocation(ctx));
        }
        return parent;
    }

    private TableImpl getTable(String[] pathName, QueryException.Location location) {
        if (this.theMetadataHelper == null) {
            throw new QueryException("No metadata found for table " + TableMetadata.makeNamespaceName(this.theQCB.getNamespace(), Translator.concatPathName(pathName)), location);
        }
        return this.theMetadataHelper.getTable(this.theQCB.getNamespace(), pathName);
    }

    private TableImpl getTableSilently(String[] pathName) {
        return this.theMetadataHelper == null ? null : this.theMetadataHelper.getTable(this.theQCB.getNamespace(), pathName);
    }

    private static String[] makeIdArray(List<KVQLParser.IdContext> list) {
        String[] ids = new String[list.size()];
        int i = 0;
        for (KVQLParser.IdContext idCtx : list) {
            ids[i++] = idCtx.getText();
        }
        return ids;
    }

    private static String[] makeKeyIdArray(List<KVQLParser.Id_with_sizeContext> list) {
        String[] ids = new String[list.size()];
        int i = 0;
        for (KVQLParser.Id_with_sizeContext idCtx : list) {
            ids[i++] = idCtx.id().getText();
        }
        return ids;
    }

    private void makePrimaryKey(List<KVQLParser.Id_with_sizeContext> list) {
        for (KVQLParser.Id_with_sizeContext idCtx : list) {
            String keyField = idCtx.id().getText();
            this.theTableBuilder.primaryKey(keyField);
            if (idCtx.storage_size() == null) continue;
            int size = Integer.parseInt(idCtx.storage_size().INT().getText());
            this.theTableBuilder.primaryKeySize(keyField, size);
        }
    }

    private static void getPrivSet(List<KVQLParser.Priv_itemContext> pCtxList, Set<String> privSet) {
        for (KVQLParser.Priv_itemContext privItem : pCtxList) {
            if (privItem.ALL_PRIVILEGES() != null) {
                privSet.add(ALL_PRIVS);
                continue;
            }
            privSet.add(Translator.getIdentifierName(privItem.id(), "privilege"));
        }
    }

    private IndexImpl.AnnotatedField[] makeFtsFieldArray(List<KVQLParser.Fts_pathContext> list) {
        IndexImpl.AnnotatedField[] fieldspecs = new IndexImpl.AnnotatedField[list.size()];
        int i = 0;
        for (KVQLParser.Fts_pathContext pctx : list) {
            KVQLParser.Index_pathContext path = pctx.index_path();
            String fieldName = path.getText();
            String jsonStr = (String)this.jsonCollector.get(pctx.jsobject());
            fieldspecs[i++] = new IndexImpl.AnnotatedField(fieldName, jsonStr);
        }
        return fieldspecs;
    }

    private static String stripFirstLast(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static void noTable(String[] pathName, QueryException.Location location) {
        throw new QueryException("Table does not exist: " + Translator.concatPathName(pathName), location);
    }

    private static void noParentTable(String parentName, String fullName, QueryException.Location location) {
        throw new QueryException("Parent table does not exist (" + parentName + ") in table path " + fullName, location);
    }

    private static QueryException.Location getLocation(ParserRuleContext ctx) {
        int startLine = -1;
        int startColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        if (ctx != null && ctx.getStart() != null) {
            startLine = ctx.getStart().getLine();
            startColumn = ctx.getStart().getCharPositionInLine();
        }
        if (ctx != null && ctx.getStop() != null) {
            endLine = ctx.getStop().getLine();
            endColumn = ctx.getStop().getCharPositionInLine();
        }
        return new QueryException.Location(startLine, startColumn, endLine, endColumn);
    }

    private static QueryException.Location getLocation(TerminalNode node) {
        int startLine = -1;
        int startColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        if (node != null && node.getSymbol() != null) {
            startLine = node.getSymbol().getLine();
            startColumn = node.getSymbol().getCharPositionInLine();
            endLine = node.getSymbol().getLine();
            endColumn = node.getSymbol().getCharPositionInLine();
        }
        return new QueryException.Location(startLine, startColumn, endLine, endColumn);
    }

    static enum DDLTimeUnit {
        S{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.SECONDS;
            }
        }
        ,
        M{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MINUTES;
            }
        }
        ,
        H{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.HOURS;
            }
        }
        ,
        D{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.DAYS;
            }
        };


        abstract TimeUnit getUnit();
    }

    private static class FieldDefHelper {
        final String name;
        final String comment;
        final QueryException.Location location;
        FieldDefImpl type = null;
        FieldValueImpl defaultValue = null;
        boolean nullable = true;

        FieldDefHelper(String name, String comment, QueryException.Location location) {
            this.name = name;
            this.comment = comment;
            this.location = location;
        }

        String getName() {
            return this.name;
        }

        void setType(FieldDefImpl t) {
            this.type = t;
        }

        FieldDefImpl getType() {
            return this.type;
        }

        void setNullable(boolean v, KVQLParser.Not_nullContext ctx) {
            this.nullable = v;
            if (!this.nullable) {
                if (this.type.isAtomic()) {
                    return;
                }
                throw new QueryException("Fields of type: " + this.type.getType() + " cannot be created as not-nullable", Translator.getLocation(ctx));
            }
        }

        boolean getNullable() {
            return this.nullable;
        }

        void setDefault(String strval, KVQLParser.Default_valueContext ctx) {
            if (this.type == null) {
                throw new QueryStateException("Type must be set before setting a default value.");
            }
            if (!this.type.isAtomic()) {
                throw new QueryException("Fields of type: " + this.type.getType() + " cannot have default values", Translator.getLocation(ctx));
            }
            if (ctx.string() != null) {
                if (!(this.type.isString() || this.type.isTimestamp() || this.type.isBinary() || this.type.isFixedBinary())) {
                    throw new QueryException("Quoted default value for a non-string field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
                }
                strval = Translator.stripFirstLast(strval);
                strval = EscapeUtil.inlineEscapedChars(strval);
            }
            if (ctx.number() != null) {
                if (!(this.type.isInteger() || this.type.isLong() || this.type.isFloat() || this.type.isNumber() || this.type.isDouble() || this.type.isTimestamp())) {
                    throw new QueryException("Numeric default value for a non-numeric field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
                }
                strval = Translator.stripNumericLetter(strval);
            }
            if (ctx.id() != null && !this.type.isEnum()) {
                throw new QueryException("id as default value for a non-enum field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
            }
            if (!(ctx.TRUE() == null && ctx.FALSE() == null || this.type.isBoolean())) {
                throw new QueryException("Boolean default value for a non-boolean field. Field = " + this.name + " Value = " + strval, Translator.getLocation(ctx));
            }
            try {
                switch (this.type.getType()) {
                    case INTEGER: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createInteger(Integer.parseInt(strval)));
                        break;
                    }
                    case LONG: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createLong(Long.parseLong(strval)));
                        break;
                    }
                    case FLOAT: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createFloat(Float.parseFloat(strval)));
                        break;
                    }
                    case DOUBLE: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createDouble(Double.parseDouble(strval)));
                        break;
                    }
                    case NUMBER: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createNumber(new BigDecimal(strval)));
                        break;
                    }
                    case STRING: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createString(strval));
                        break;
                    }
                    case ENUM: {
                        this.defaultValue = this.type.createEnum(strval);
                        break;
                    }
                    case BOOLEAN: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.createBoolean(Boolean.parseBoolean(strval)));
                        break;
                    }
                    case TIMESTAMP: {
                        if (ctx.string() != null) {
                            this.defaultValue = (FieldValueImpl)((Object)this.type.asTimestamp().fromString(strval));
                            break;
                        }
                        assert (ctx.number().INT() != null);
                        this.defaultValue = ((TimestampDefImpl)this.type).createTimestamp(new Timestamp(Long.parseLong(strval)));
                        break;
                    }
                    case BINARY: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.asBinary().fromString(strval));
                        break;
                    }
                    case FIXED_BINARY: {
                        this.defaultValue = (FieldValueImpl)((Object)this.type.asFixedBinary().fromString(strval));
                        break;
                    }
                    default: {
                        throw new QueryException("Unexpected type for default value. Field = " + this.name + " Type = " + this.type + " Value = " + strval, Translator.getLocation(ctx));
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new QueryException(iae.getMessage(), Translator.getLocation(ctx));
            }
        }

        FieldValueImpl getDefault() {
            return this.defaultValue;
        }

        void validate() {
            if (this.defaultValue == null && !this.nullable) {
                throw new QueryException("Non-nullable field without a default value.  Field = " + this.name, this.location);
            }
            this.type.setDescription(this.comment);
        }
    }
}

