/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.Index;

class IndexExpr {
    Expr theExpr;
    TableImpl theTable;
    List<String> theSteps = new ArrayList<String>();
    List<TablePath.StepKind> theStepKinds = new ArrayList<TablePath.StepKind>();
    boolean theDoesFiltering;
    boolean theIsJson;
    boolean theIsDirect = true;
    boolean theIsUnnested;
    int thePosition = -1;
    boolean theIsMultiKey;
    String theMapBothKey;
    FieldDefImpl theJsonDeclaredType;

    IndexExpr() {
    }

    public void reset() {
        this.thePosition = -1;
        this.theIsMultiKey = false;
        this.theMapBothKey = null;
        this.theJsonDeclaredType = null;
    }

    public void clear() {
        this.theSteps.clear();
        this.theStepKinds.clear();
        this.theIsJson = false;
        this.theDoesFiltering = false;
        this.theIsDirect = true;
        this.theIsUnnested = false;
        this.thePosition = -1;
        this.theIsMultiKey = false;
        this.theMapBothKey = null;
        this.theJsonDeclaredType = null;
    }

    boolean matched() {
        return this.thePosition >= 0;
    }

    public int numSteps() {
        return this.theSteps.size();
    }

    public final String getStep(int i) {
        return this.theSteps.get(i);
    }

    public final String getLastStep() {
        return this.theSteps.get(this.theSteps.size() - 1);
    }

    public void reverseSteps() {
        Collections.reverse(this.theSteps);
        Collections.reverse(this.theStepKinds);
    }

    public final void add(String step, TablePath.StepKind kind) {
        this.theSteps.add(step);
        this.theStepKinds.add(kind);
    }

    static IndexExpr create(Expr expr) {
        IndexExpr epath = new IndexExpr();
        epath.theExpr = expr;
        block7: while (true) {
            switch (expr.getKind()) {
                case FIELD_STEP: {
                    Expr stepExpr = (ExprFieldStep)expr;
                    String fieldName = ((ExprFieldStep)stepExpr).getFieldName();
                    ExprType inType = ((ExprFieldStep)stepExpr).getInput().getType();
                    if (fieldName == null) {
                        return null;
                    }
                    if (!epath.theIsJson && (expr.getType().isAnyJson() || expr.getType().isAnyJsonAtomic())) {
                        epath.theIsJson = true;
                    }
                    if (inType.isArray()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        FieldDefImpl elemDef = ((ArrayDefImpl)inType.getDef()).getElement();
                        if (elemDef.isArray()) {
                            return null;
                        }
                        if (elemDef.isRecord()) {
                            epath.add(fieldName, TablePath.StepKind.REC_FIELD);
                        } else {
                            epath.add(fieldName, TablePath.StepKind.MAP_FIELD);
                        }
                        epath.add("[]", TablePath.StepKind.BRACKETS);
                        epath.theIsMultiKey = true;
                    } else if (inType.isRecord()) {
                        epath.add(fieldName, TablePath.StepKind.REC_FIELD);
                    } else {
                        epath.add(fieldName, TablePath.StepKind.MAP_FIELD);
                    }
                    expr = expr.getInput();
                    continue block7;
                }
                case MAP_FILTER: {
                    Expr stepExpr = (ExprMapFilter)expr;
                    ExprType inType = expr.getInput().getType();
                    if (!inType.isMap() && !inType.isAnyJson()) {
                        return null;
                    }
                    if (inType.isMap()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        epath.theIsMultiKey = true;
                    }
                    if (((ExprMapFilter)stepExpr).getFilterKind() == ExprMapFilter.FilterKind.KEYS) {
                        epath.add("keys()", TablePath.StepKind.KEYS);
                    } else {
                        epath.add("values()", TablePath.StepKind.VALUES);
                    }
                    epath.theDoesFiltering = ((ExprMapFilter)stepExpr).getPredExpr() != null;
                    expr = expr.getInput();
                    continue block7;
                }
                case ARRAY_SLICE: 
                case ARRAY_FILTER: {
                    Expr step;
                    ExprType inType = expr.getInput().getType();
                    if (!inType.isArray() && !inType.isAnyJson()) {
                        return null;
                    }
                    if (inType.isArray()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        epath.theIsMultiKey = true;
                    }
                    epath.add("[]", TablePath.StepKind.BRACKETS);
                    if (expr.getKind() == Expr.ExprKind.ARRAY_SLICE) {
                        step = (ExprArraySlice)expr;
                        epath.theDoesFiltering = ((ExprArraySlice)step).hasBounds();
                    } else {
                        step = (ExprArrayFilter)expr;
                        epath.theDoesFiltering = ((ExprArrayFilter)step).getPredExpr() != null;
                    }
                    expr = expr.getInput();
                    continue block7;
                }
                case VAR: {
                    ExprVar varExpr = (ExprVar)expr;
                    if (varExpr.isExternal() || varExpr.isContext()) {
                        return null;
                    }
                    expr = varExpr.getDomainExpr();
                    if (expr.getKind() == Expr.ExprKind.BASE_TABLE) continue block7;
                    epath.theIsDirect = false;
                    if (!expr.isMultiValued()) continue block7;
                    epath.theIsUnnested = true;
                    continue block7;
                }
                case BASE_TABLE: {
                    ExprBaseTable tableExpr = (ExprBaseTable)expr;
                    epath.reverseSteps();
                    epath.theTable = tableExpr.getTable();
                    return epath;
                }
            }
            break;
        }
        return null;
    }

    boolean matchToIndexPath(IndexImpl index, IndexImpl.IndexField ipath) {
        IndexExpr epath = this;
        boolean mapBothIndex = index.isMapBothIndex();
        String mapKey = null;
        int inumSteps = ipath.numSteps();
        int enumSteps = epath.numSteps();
        if (epath.theIsMultiKey && !ipath.isMultiKey()) {
            return false;
        }
        int ii = 0;
        int ie = 0;
        while (ii < inumSteps && ie < enumSteps) {
            boolean eq;
            TablePath.StepKind ekind;
            String istep = ipath.getStep(ii);
            String estep = epath.getStep(ie);
            TablePath.StepKind ikind = ipath.getStepKind(ii);
            boolean bl = ikind == (ekind = epath.theStepKinds.get(ie)) && (ipath.isMapKeyStep(ii) ? istep.equals(estep) : istep.equalsIgnoreCase(estep)) ? true : (eq = false);
            if (eq) {
                ++ii;
                ++ie;
                continue;
            }
            if (ikind == TablePath.StepKind.BRACKETS) {
                if (ii == inumSteps - 1) {
                    return false;
                }
                ++ii;
                continue;
            }
            if (ekind == TablePath.StepKind.BRACKETS) {
                if (ie == enumSteps - 1) {
                    return false;
                }
                ++ie;
                continue;
            }
            if (ipath.isValuesStep(ii) && mapBothIndex) {
                mapKey = estep;
                ++ii;
                ++ie;
                continue;
            }
            return false;
        }
        if (ii == inumSteps && ie == enumSteps) {
            epath.thePosition = ipath.getPosition();
            epath.theIsMultiKey = ipath.isMultiKey();
            epath.theMapBothKey = mapKey;
            epath.theJsonDeclaredType = ipath.getDeclaredType();
            return true;
        }
        return false;
    }

    ExprType getIndexDeclaredType() {
        Map<String, Index> indexes = this.theTable.getIndexes();
        for (Map.Entry<String, Index> entry : indexes.entrySet()) {
            IndexImpl index = (IndexImpl)entry.getValue();
            List<IndexImpl.IndexField> indexPaths = index.getIndexFields();
            for (IndexImpl.IndexField ipath : indexPaths) {
                if (ipath.getDeclaredType() == null || !this.matchToIndexPath(index, ipath)) continue;
                ExprType.Quantifier quant = this.theMapBothKey == null && ipath.isMultiKey() ? ExprType.Quantifier.STAR : ExprType.Quantifier.QSTN;
                return TypeManager.createType(ipath.getDeclaredType(), quant);
            }
        }
        return null;
    }

    final String getPathName() {
        StringBuilder sb = new StringBuilder();
        int numSteps = this.theSteps.size();
        for (int i = 0; i < numSteps; ++i) {
            String step = this.theSteps.get(i);
            if ("[]".equals(step)) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append(step);
            if (i >= numSteps - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

