/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public abstract class Function {
    final FunctionLib.FuncCode theCode;
    final String theName;
    final boolean theIsVariadic;
    final ArrayList<ExprType> theParamTypes;
    final ExprType theReturnType;

    Function(FunctionLib.FuncCode code, String name, ExprType retType) {
        this.theCode = code;
        this.theName = name;
        this.theIsVariadic = false;
        this.theParamTypes = null;
        this.theReturnType = retType;
    }

    Function(FunctionLib.FuncCode code, String name, ExprType paramType, ExprType retType) {
        this(code, name, paramType, retType, false);
    }

    Function(FunctionLib.FuncCode code, String name, ExprType paramType, ExprType retType, boolean isVariadic) {
        this.theCode = code;
        this.theName = name;
        this.theIsVariadic = isVariadic;
        this.theParamTypes = new ArrayList(1);
        this.theParamTypes.add(paramType);
        this.theReturnType = retType;
    }

    Function(FunctionLib.FuncCode code, String name, ExprType param1Type, ExprType param2Type, ExprType retType) {
        this.theCode = code;
        this.theName = name;
        this.theIsVariadic = false;
        this.theParamTypes = new ArrayList(2);
        this.theParamTypes.add(param1Type);
        this.theParamTypes.add(param1Type);
        this.theReturnType = retType;
    }

    Function(FunctionLib.FuncCode code, String name, ArrayList<ExprType> paramTypes, ExprType retType) {
        this.theCode = code;
        this.theName = name;
        this.theIsVariadic = false;
        this.theParamTypes = paramTypes;
        this.theReturnType = retType;
    }

    final FunctionLib.FuncCode getCode() {
        return this.theCode;
    }

    final String getName() {
        return this.theName;
    }

    final int getArity() {
        return this.theParamTypes.size();
    }

    boolean isVariadic() {
        return this.theIsVariadic;
    }

    boolean isValueComparison() {
        return false;
    }

    boolean isAnyComparison() {
        return false;
    }

    final boolean isComparison() {
        return this.isValueComparison() || this.isAnyComparison();
    }

    ExprType getParamType(int i) {
        if (i < this.theParamTypes.size()) {
            return this.theParamTypes.get(i);
        }
        assert (this.isVariadic());
        if (this.theParamTypes.isEmpty()) {
            return TypeManager.ANY_STAR();
        }
        return this.theParamTypes.get(this.theParamTypes.size() - 1);
    }

    ExprType getRetType(ExprFuncCall caller) {
        return this.theReturnType;
    }

    abstract boolean mayReturnNULL(ExprFuncCall var1);

    Expr normalizeCall(ExprFuncCall funcCall) {
        return funcCall;
    }

    abstract PlanIter codegen(CodeGenerator var1, Expr var2, PlanIter[] var3);

    static Function getFunction(FunctionLib.FuncCode c) {
        return CompilerAPI.getFuncLib().getFunc(c);
    }
}

