/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.IsNullIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;

class FuncIsNull
extends Function {
    FuncIsNull(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_QSTN(), TypeManager.BOOLEAN_ONE());
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        QueryControlBlock qcb = fncall.getQCB();
        StaticContext sctx = fncall.getSctx();
        QueryException.Location loc = fncall.getLocation();
        Expr arg = fncall.getArg(0);
        if (!arg.mayReturnNULL() && this.theCode == FunctionLib.FuncCode.OP_IS_NULL) {
            return new ExprConst(qcb, sctx, loc, false);
        }
        if (arg.getKind() == Expr.ExprKind.CONST) {
            FieldValueImpl val = ((ExprConst)arg).getValue();
            if (this.theCode == FunctionLib.FuncCode.OP_IS_NULL) {
                return new ExprConst(qcb, sctx, loc, val.isNull());
            }
            return new ExprConst(qcb, sctx, loc, !val.isNull());
        }
        return fncall;
    }

    @Override
    boolean isValueComparison() {
        return true;
    }

    @Override
    public boolean mayReturnNULL(ExprFuncCall caller) {
        return false;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, Expr caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        return new IsNullIter(caller, resultReg, this.theCode, argIters[0]);
    }
}

