/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.CompOpIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

public class FuncCompOp
extends Function {
    FuncCompOp(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_STAR(), TypeManager.ANY_STAR(), TypeManager.BOOLEAN_ONE());
    }

    @Override
    boolean isValueComparison() {
        return true;
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall fncall) {
        return fncall.getArg(0).mayReturnNULL() || fncall.getArg(1).mayReturnNULL();
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        FieldDef.Type tc1;
        QueryException.Location loc = fncall.getLocation();
        QueryControlBlock qcb = fncall.getQCB();
        StaticContext sctx = fncall.getSctx();
        boolean strict = qcb.strictMode();
        Expr op0 = fncall.getArg(0);
        Expr op1 = fncall.getArg(1);
        FieldDefImpl op0Def = op0.getType().getDef();
        FieldDefImpl op1Def = op1.getType().getDef();
        FieldDef.Type tc0 = op0Def.getType();
        if (tc0 == (tc1 = op1Def.getType())) {
            return fncall;
        }
        if (!TypeManager.areTypesComparable(op0.getType(), op1.getType())) {
            if (strict) {
                throw new QueryException("Incompatible types for comparison operator: \nType1: " + op0.getType() + "\nType2: " + op1.getType(), fncall.getLocation());
            }
            return new ExprConst(qcb, sctx, loc, false);
        }
        return FuncCompOp.handleConstOperand(fncall);
    }

    static Expr handleConstOperand(ExprFuncCall fncall) {
        int constPos;
        QueryException.Location loc = fncall.getLocation();
        QueryControlBlock qcb = fncall.getQCB();
        StaticContext sctx = fncall.getSctx();
        Function func = fncall.getFunction();
        Expr arg0 = fncall.getArg(0);
        Expr arg1 = fncall.getArg(1);
        FunctionLib.FuncCode opCode = func.getCode();
        boolean isAnyOp = func.isAnyComparison();
        Expr varOp = null;
        ExprConst constOp = null;
        if (isAnyOp) {
            opCode = FuncAnyOp.anyToComp(opCode);
        }
        if (arg0.getKind() == Expr.ExprKind.CONST) {
            constOp = (ExprConst)arg0;
            constPos = 0;
            varOp = arg1;
            opCode = FuncCompOp.swapCompOp(opCode);
        } else if (arg1.getKind() == Expr.ExprKind.CONST) {
            constOp = (ExprConst)arg1;
            constPos = 1;
            varOp = arg0;
        } else {
            return fncall;
        }
        boolean strict = fncall.getQCB().strictMode();
        FieldDefImpl varDef = varOp.getType().getDef();
        FieldValueImpl constVal = constOp.getValue();
        boolean varNullable = varOp.mayReturnNULL();
        boolean varScalar = varOp.isScalar();
        if (varOp.isMultiValued() && !isAnyOp) {
            return fncall;
        }
        FieldValueImpl newConstVal = FuncCompOp.castConstInCompOp(varDef, false, varNullable, varScalar, constVal, opCode, strict);
        if (newConstVal == constVal) {
            if (constVal.isJsonNull() && (opCode == FunctionLib.FuncCode.OP_GE || opCode == FunctionLib.FuncCode.OP_LE)) {
                func = isAnyOp ? CompilerAPI.getFuncLib().getFunc(FunctionLib.FuncCode.OP_EQ_ANY) : CompilerAPI.getFuncLib().getFunc(FunctionLib.FuncCode.OP_EQ);
                return ExprFuncCall.create(qcb, sctx, loc, func, fncall.getArgs());
            }
            return fncall;
        }
        if (newConstVal == BooleanValueImpl.falseValue) {
            return new ExprConst(qcb, sctx, loc, false);
        }
        if (newConstVal == BooleanValueImpl.trueValue) {
            return new ExprConst(qcb, sctx, loc, true);
        }
        ExprConst newConstOp = new ExprConst(qcb, sctx, loc, newConstVal);
        fncall.setArg(constPos, newConstOp, true);
        return fncall;
    }

    public static FieldValueImpl castConstInCompOp(FieldDefImpl targetType, boolean allowJsonNull, boolean nullable, boolean scalar, FieldValueImpl val, FunctionLib.FuncCode opCode, boolean strict) {
        if (targetType.getType() == FieldDef.Type.EMPTY) {
            if (opCode == FunctionLib.FuncCode.OP_NEQ) {
                return BooleanValueImpl.trueValue;
            }
            return BooleanValueImpl.falseValue;
        }
        if (val.isJsonNull()) {
            if (!(nullable || opCode == FunctionLib.FuncCode.OP_NEQ || opCode != FunctionLib.FuncCode.OP_LT && opCode != FunctionLib.FuncCode.OP_GT && (allowJsonNull || targetType.isJson() || targetType.isAnyJsonAtomic() || targetType.isAny()))) {
                return BooleanValueImpl.falseValue;
            }
            return val;
        }
        if (targetType.getType() == val.getType() || targetType.isWildcard()) {
            return val;
        }
        switch (targetType.getType()) {
            case INTEGER: {
                if (val.isLong()) {
                    long lng = ((LongValueImpl)val).get();
                    if (lng < Integer.MIN_VALUE || lng > Integer.MAX_VALUE) {
                        if (nullable) {
                            return val;
                        }
                        switch (opCode) {
                            case OP_EQ: {
                                return BooleanValueImpl.falseValue;
                            }
                            case OP_NEQ: {
                                if (scalar) {
                                    return BooleanValueImpl.trueValue;
                                }
                                return val;
                            }
                            case OP_LT: {
                                if (lng <= Integer.MIN_VALUE) {
                                    return BooleanValueImpl.falseValue;
                                }
                                if (scalar) {
                                    return BooleanValueImpl.trueValue;
                                }
                                return val;
                            }
                            case OP_LE: {
                                if (lng < Integer.MIN_VALUE) {
                                    return BooleanValueImpl.falseValue;
                                }
                                if (scalar) {
                                    return BooleanValueImpl.trueValue;
                                }
                                return val;
                            }
                            case OP_GT: {
                                if (lng <= Integer.MIN_VALUE) {
                                    if (scalar) {
                                        return BooleanValueImpl.trueValue;
                                    }
                                    return val;
                                }
                                return BooleanValueImpl.falseValue;
                            }
                            case OP_GE: {
                                if (lng < Integer.MIN_VALUE) {
                                    if (scalar) {
                                        return BooleanValueImpl.trueValue;
                                    }
                                    return val;
                                }
                                return BooleanValueImpl.falseValue;
                            }
                        }
                        throw new QueryStateException("Unexpected function " + (Object)((Object)opCode));
                    }
                    return FieldDefImpl.integerDef.createInteger((int)lng);
                }
                if (!val.isNumeric()) break;
                return val;
            }
            case LONG: {
                if (val.isInteger()) {
                    return FieldDefImpl.longDef.createLong(((IntegerValueImpl)val).get());
                }
                if (!val.isNumeric()) break;
                return val;
            }
            case FLOAT: {
                if (val.isInteger()) {
                    return FieldDefImpl.floatDef.createFloat(((IntegerValueImpl)val).get());
                }
                if (val.isLong()) {
                    return FieldDefImpl.floatDef.createFloat(((LongValueImpl)val).get());
                }
                if (val.isDouble()) {
                    double dbl = ((DoubleValueImpl)val).get();
                    if (dbl < -3.4028234663852886E38 || dbl > 3.4028234663852886E38) {
                        if (nullable) {
                            return val;
                        }
                        switch (opCode) {
                            case OP_EQ: {
                                return BooleanValueImpl.falseValue;
                            }
                            case OP_NEQ: {
                                return val;
                            }
                            case OP_LT: 
                            case OP_LE: {
                                if (dbl < (double)1.4E-45f) {
                                    return BooleanValueImpl.falseValue;
                                }
                                return val;
                            }
                            case OP_GT: 
                            case OP_GE: {
                                if (dbl < (double)1.4E-45f) {
                                    return val;
                                }
                                return BooleanValueImpl.falseValue;
                            }
                        }
                        throw new QueryStateException("Unexpected function " + (Object)((Object)opCode));
                    }
                    return FieldDefImpl.floatDef.createFloat((float)dbl);
                }
                if (!val.isNumeric()) break;
                return val;
            }
            case DOUBLE: {
                if (val.isInteger()) {
                    return FieldDefImpl.doubleDef.createDouble(((IntegerValueImpl)val).get());
                }
                if (val.isLong()) {
                    return FieldDefImpl.doubleDef.createDouble(((LongValueImpl)val).get());
                }
                if (val.isFloat()) {
                    return FieldDefImpl.doubleDef.createDouble(((FloatValueImpl)val).get());
                }
                if (!val.isNumeric()) break;
                return val;
            }
            case NUMBER: {
                if (val.isInteger()) {
                    return FieldDefImpl.numberDef.createNumber(((IntegerValueImpl)val).get());
                }
                if (val.isLong()) {
                    return FieldDefImpl.numberDef.createNumber(((LongValueImpl)val).get());
                }
                if (val.isFloat()) {
                    return FieldDefImpl.numberDef.createNumber(((FloatValueImpl)val).get());
                }
                if (!val.isDouble()) break;
                return FieldDefImpl.numberDef.createNumber(((DoubleValueImpl)val).get());
            }
            case ENUM: {
                if (!val.isString()) break;
                try {
                    return targetType.createEnum(((StringValueImpl)val).get());
                }
                catch (IllegalArgumentException e) {
                    if (strict) {
                        throw e;
                    }
                    return BooleanValueImpl.falseValue;
                }
            }
        }
        throw new QueryStateException("Unexpected case in castConstInCompOp()\nTarget type =\n  " + targetType.getDDLString() + "\nValue =\n  " + val + "\nValue type = " + val.getType() + "\nComparison op = " + (Object)((Object)opCode));
    }

    static FunctionLib.FuncCode swapCompOp(FunctionLib.FuncCode op) {
        switch (op) {
            case OP_GT: {
                return FunctionLib.FuncCode.OP_LT;
            }
            case OP_GE: {
                return FunctionLib.FuncCode.OP_LE;
            }
            case OP_LT: {
                return FunctionLib.FuncCode.OP_GT;
            }
            case OP_LE: {
                return FunctionLib.FuncCode.OP_GE;
            }
        }
        return op;
    }

    static FunctionLib.FuncCode getNegationOp(FunctionLib.FuncCode op) {
        switch (op) {
            case OP_GT: {
                return FunctionLib.FuncCode.OP_LE;
            }
            case OP_GE: {
                return FunctionLib.FuncCode.OP_LT;
            }
            case OP_LT: {
                return FunctionLib.FuncCode.OP_GE;
            }
            case OP_LE: {
                return FunctionLib.FuncCode.OP_GT;
            }
            case OP_EQ: {
                return FunctionLib.FuncCode.OP_NEQ;
            }
            case OP_NEQ: {
                return FunctionLib.FuncCode.OP_EQ;
            }
        }
        throw new QueryStateException("Unexpected function " + (Object)((Object)op));
    }

    public static String printOp(FunctionLib.FuncCode op) {
        switch (op) {
            case OP_GT: {
                return ">";
            }
            case OP_GE: {
                return ">=";
            }
            case OP_LT: {
                return "<";
            }
            case OP_LE: {
                return "<=";
            }
            case OP_EQ: {
                return "=";
            }
            case OP_NEQ: {
                return "!=";
            }
        }
        throw new QueryStateException("Unexpected function " + (Object)((Object)op));
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, Expr fncall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(fncall);
        return new CompOpIter(fncall, resultReg, this.theCode, argIters);
    }
}

