/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

class ExprFieldStep
extends Expr {
    private Expr theInput;
    private Expr theFieldNameExpr;
    private String theFieldName;
    private int theFieldPos = -1;
    private ExprVar theCtxItemVar;

    ExprFieldStep(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input) {
        super(qcb, sctx, Expr.ExprKind.FIELD_STEP, location);
        this.theInput = input;
        this.theInput.addParent(this);
    }

    ExprFieldStep(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input, String fieldName) {
        this(qcb, sctx, location, input);
        this.theFieldName = fieldName;
        this.getFieldPos();
    }

    void addCtxVars(ExprVar ctxItemVar) {
        this.theCtxItemVar = ctxItemVar;
    }

    void addFieldNameExpr(String fieldName, Expr fieldNameExpr) {
        this.theFieldName = fieldName;
        this.theFieldNameExpr = fieldNameExpr;
        if (this.theFieldNameExpr != null) {
            assert (this.theFieldName == null);
            this.theFieldNameExpr.addParent(this);
        }
        this.checkConst();
        if (!this.isConst()) {
            this.theFieldNameExpr = ExprPromote.create(this, this.theFieldNameExpr, TypeManager.STRING_QSTN());
        } else {
            this.getFieldPos();
        }
    }

    @Override
    int getNumChildren() {
        return this.theFieldNameExpr != null ? 2 : 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
        this.getFieldPos();
    }

    Expr getFieldNameExpr() {
        return this.theFieldNameExpr;
    }

    void setFieldNameExpr(Expr newExpr, boolean destroy) {
        assert (this.theFieldName == null);
        this.theFieldNameExpr.removeParent(this, destroy);
        this.theFieldNameExpr = newExpr;
        newExpr.addParent(this);
    }

    String getFieldName() {
        return this.theFieldName;
    }

    ExprVar getCtxItemVar() {
        return this.theCtxItemVar;
    }

    public boolean isConst() {
        return this.theFieldName != null;
    }

    public void checkConst() {
        if (this.isConst()) {
            assert (this.theFieldNameExpr == null);
            assert (this.theCtxItemVar == null);
            return;
        }
        if (this.theFieldNameExpr.getKind() == Expr.ExprKind.CONST && this.theFieldNameExpr.getType().getCode() == ExprType.TypeCode.STRING) {
            FieldValueImpl value = ((ExprConst)this.theFieldNameExpr).getValue();
            this.theFieldName = value.getString();
            this.theFieldNameExpr.removeParent(this, true);
            this.theFieldNameExpr = null;
            this.theCtxItemVar = null;
        }
        if (this.theCtxItemVar != null && !this.theCtxItemVar.hasParents()) {
            this.theCtxItemVar = null;
        }
    }

    int getFieldPos() {
        if (this.theFieldPos >= 0) {
            return this.theFieldPos;
        }
        if (this.theFieldName == null) {
            return -1;
        }
        FieldDefImpl inType = this.theInput.getType().getDef();
        while (inType.isArray()) {
            inType = ((ArrayDefImpl)inType).getElement();
        }
        if (!inType.isRecord()) {
            return -1;
        }
        try {
            this.theFieldPos = ((RecordDefImpl)inType).getFieldPos(this.theFieldName);
        }
        catch (IllegalArgumentException e) {
            throw new QueryException("There is no field named " + this.theFieldName + " in type " + inType, this.getLocation());
        }
        return this.theFieldPos;
    }

    @Override
    public ExprType computeType() {
        ExprType inType = this.theInput.getType();
        if (inType.isEmpty()) {
            return TypeManager.EMPTY();
        }
        this.checkConst();
        while (inType.isArray()) {
            inType = inType.getArrayElementType(ExprType.Quantifier.STAR);
        }
        if (this.theQCB.strictMode() && inType.isAtomic()) {
            throw new QueryException("Wrong input type for path step (must be a record, array, or map type): " + inType.getDef().getDDLString(), this.theLocation);
        }
        if (inType.isAtomic()) {
            return TypeManager.EMPTY();
        }
        ExprType.Quantifier inQuant = inType.getQuantifier();
        if (inType.isRecord() && this.isConst()) {
            return inType.getFieldType(this.getFieldPos(), inQuant);
        }
        if (inType.isAnyJson() || inType.isAny()) {
            inQuant = ExprType.Quantifier.STAR;
        }
        ExprType.Quantifier outQuant = inType.isRecord() ? inQuant : TypeManager.getUnionQuant(inQuant, ExprType.Quantifier.QSTN);
        return inType.getMapElementType(outQuant);
    }

    @Override
    public boolean mayReturnNULL() {
        if (this.theInput.mayReturnNULL() || this.getType().isAny() || this.getType().isAnyJson()) {
            return true;
        }
        FieldDef inType = this.theInput.getType().getDef();
        while (inType.isArray()) {
            inType = inType.asArray().getElement();
        }
        if (inType.isMap()) {
            return false;
        }
        if (inType.isRecord()) {
            if (this.theFieldName == null) {
                return true;
            }
            return inType.asRecord().isNullable(this.theFieldName);
        }
        return true;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("type :\n");
        formatter.indent(sb);
        this.theType.display(sb, formatter);
        sb.append("\n");
        this.theInput.display(sb, formatter);
        sb.append(".\n");
        formatter.indent(sb);
        if (this.isConst()) {
            sb.append(this.theFieldName);
        } else {
            this.theFieldNameExpr.display(sb, formatter);
        }
    }
}

