/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.impl.api.query.PreparedDdlStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.DdlException;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StatementFactory;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;

public class CompilerAPI {
    static StaticContext theRootSctx = new StaticContext(null);
    static FunctionLib theFunctionLib = new FunctionLib(theRootSctx);

    static FunctionLib getFuncLib() {
        return theFunctionLib;
    }

    public static PreparedStatement prepare(TableAPIImpl tableAPI, String queryString, ExecuteOptions options) {
        String namespace = options == null ? null : options.getNamespace();
        try {
            StaticContext querySctx = new StaticContext(theRootSctx);
            QueryControlBlock qcb = new QueryControlBlock(tableAPI, queryString, querySctx, namespace);
            qcb.compile();
            if (qcb.succeeded()) {
                return new PreparedStatementImpl(qcb.getQueryPlan(), qcb.getResultDef(), qcb.getNumRegs(), qcb.getNumIterators(), qcb.getInitSctx().getExternalVars(), qcb);
            }
            if (qcb.getException() instanceof QueryStateException) {
                Logger logger = tableAPI.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qcb.getException().toString());
                }
                throw qcb.getException();
            }
            if (qcb.getException() instanceof FaultException) {
                throw qcb.getException();
            }
            if (qcb.getException() instanceof QueryException) {
                throw qcb.getException();
            }
            throw new IllegalArgumentException(qcb.getErrorMessage());
        }
        catch (DdlException ddle) {
            return new PreparedDdlStatementImpl(queryString, namespace);
        }
    }

    public static QueryControlBlock compile(String queryString, TableMetadataHelper metadataHelper, StatementFactory statementFactory, String namespace) {
        StaticContext querySctx = new StaticContext(theRootSctx);
        QueryControlBlock qcb = new QueryControlBlock(metadataHelper, statementFactory, queryString, querySctx, namespace);
        qcb.compile();
        return qcb;
    }

    public static QueryControlBlock parse(String queryString, TableMetadataHelper metadataHelper, String namespace) {
        StaticContext initSctx = new StaticContext(theRootSctx);
        QueryControlBlock qcb = new QueryControlBlock(metadataHelper, null, queryString, initSctx, namespace);
        qcb.parse();
        return qcb;
    }
}

